/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml;

import com.atlassian.bamboo.configuration.external.yaml.BambooYamlEntityType;
import com.atlassian.bamboo.configuration.external.yaml.BambooYamlSpecsService;
import com.atlassian.bamboo.configuration.external.yaml.BambooYamlVersion;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlDeploymentDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlPlanDefinition;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.util.Yamlizator;
import com.atlassian.bamboo.specs.yaml.BambooYamlParserUtils;
import com.atlassian.bamboo.specs.yaml.MapNode;
import com.atlassian.bamboo.specs.yaml.StringNode;
import com.atlassian.bamboo.specs.yaml.YamlSpecsValidationException;
import com.atlassian.bamboo.utils.SystemProperty;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class BambooYamlSpecsServiceImpl
implements BambooYamlSpecsService {
    @Override
    @NotNull
    public List<Map<String, Object>> splitDocuments(@NotNull String yamlString, @Nullable Path yamlDirectory) {
        int includeMaxDepth = (int)SystemProperty.SPECS_YAML_INCLUDE_MAX_DEPTH.getTypedValue();
        Yaml yamlizator = yamlDirectory == null ? Yamlizator.getYaml() : Yamlizator.getYamlWithRepositoryIncludes((int)includeMaxDepth, (Path)yamlDirectory);
        ValidationContext validationContext = ValidationContext.empty();
        ArrayList<Map<String, Object>> yamlStructures = new ArrayList<Map<String, Object>>();
        try {
            Iterable rawObjects = yamlizator.loadAll(yamlString);
            if (rawObjects == null) {
                throw new YamlSpecsValidationException("Unable to parse the YAML file - no documents defined");
            }
            Iterator rawObjectsIterator = rawObjects.iterator();
            int i = 1;
            while (rawObjectsIterator.hasNext()) {
                Object rawObject = rawObjectsIterator.next();
                if (rawObject == null) {
                    throw new YamlSpecsValidationException("Unable to parse the YAML file - document " + i + " is empty");
                }
                yamlStructures.add(BambooYamlParserUtils.checkMapType((ValidationContext)validationContext, (Map)((Map)BambooYamlParserUtils.checkType((ValidationContext)validationContext, rawObject, Map.class))));
                ++i;
            }
        }
        catch (PropertiesValidationException | YAMLException e) {
            throw new YamlSpecsValidationException("Invalid format of the YAML file: " + e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new YamlSpecsValidationException("Unable to parse the YAML file, it may be malformed", (Throwable)e);
        }
        return yamlStructures;
    }

    @Override
    @NotNull
    public BambooYamlVersion determineVersion(@NotNull Map<String, Object> yamlStructure) throws YamlSpecsValidationException {
        try {
            ValidationContext validationContext = ValidationContext.empty();
            MapNode node = new MapNode(yamlStructure, validationContext);
            return node.getOptionalString(BambooYamlParserUtils.CFG_VERSION).map(StringNode::get).map(BambooYamlVersion::fromVersion).orElse(BambooYamlVersion.VERSION_1);
        }
        catch (PropertiesValidationException e) {
            throw new YamlSpecsValidationException("Could not determine YAML document version: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @NotNull
    public BambooYamlEntityType determineEntityType(@NotNull Map<String, Object> yamlStructure) throws YamlSpecsValidationException {
        if (yamlStructure.containsKey(BambooYamlPlanDefinition.Config.STAGES)) {
            return BambooYamlEntityType.PLAN;
        }
        if (yamlStructure.containsKey(BambooYamlDeploymentDefinition.Config.DEPLOYMENT)) {
            if (yamlStructure.containsKey("deployment-permissions")) {
                return BambooYamlEntityType.DEPLOYMENT_PROJECT_PERMISSIONS;
            }
            return BambooYamlEntityType.DEPLOYMENT_PROJECT;
        }
        if (yamlStructure.containsKey("plan-permissions") && yamlStructure.containsKey(BambooYamlPlanDefinition.Config.PLAN)) {
            return BambooYamlEntityType.PLAN_PERMISSIONS;
        }
        throw new YamlSpecsValidationException("Unknown entity type defined in YAML document");
    }
}

