/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml;

import com.atlassian.bamboo.configuration.external.RssExecutionOutputHandler;
import com.atlassian.bamboo.configuration.external.yaml.BambooYamlParser;
import com.atlassian.bamboo.configuration.external.yaml.BambooYamlVersion;
import com.atlassian.bamboo.configuration.external.yaml.format.BambooYamlVersion1Converter;
import com.atlassian.bamboo.configuration.external.yaml.override.BambooYamlOverrider;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlDeploymentDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlDeploymentPermissionsDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlPlanDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlPlanPermissionsDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.BranchIntegrationSettings;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.BranchManagementConfiguration;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.CreatePlanBranchSettings;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.DeletePlanBranchSettings;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.MasterBranch;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.PlanBranchConfiguration;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Docker;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Notification;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Requirement;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Trigger;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.notifications.BasicNotificationEvent;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.notifications.JobErrorNotificationEvent;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.notifications.NotificationEvent;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.notifications.PlanFailedNotificationEvent;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.permissions.Permission;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.permissions.PermissionSet;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.BasicNotificationsRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.EmailNotificationRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.GroupNotificationRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.NotificationRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.PluginAwareRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.UserNotificationRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.WebhookNotificationRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.triggers.DefaultTrigger;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.triggers.PluginAwareTrigger;
import com.atlassian.bamboo.configuration.external.yaml.properties.deployment.DeploymentProject;
import com.atlassian.bamboo.configuration.external.yaml.properties.deployment.Environment;
import com.atlassian.bamboo.configuration.external.yaml.properties.deployment.EnvironmentPermissions;
import com.atlassian.bamboo.configuration.external.yaml.properties.deployment.ReleaseNaming;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Artifact;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Job;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Other;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Plan;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Stage;
import com.atlassian.bamboo.deployments.configuration.CustomEnvironmentConfigPluginExporter;
import com.atlassian.bamboo.deployments.configuration.CustomEnvironmentConfigPluginModuleDescriptor;
import com.atlassian.bamboo.notification.NotificationRecipientExporter;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.NotificationRecipientModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.TaskConditionModuleDescriptor;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.deployment.Deployment;
import com.atlassian.bamboo.specs.api.builders.deployment.configuration.EnvironmentPluginConfiguration;
import com.atlassian.bamboo.specs.api.builders.notification.NotificationRecipient;
import com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier;
import com.atlassian.bamboo.specs.api.builders.plan.configuration.PluginConfiguration;
import com.atlassian.bamboo.specs.api.builders.project.Project;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.deployment.DeploymentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.EnvironmentProperties;
import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.yaml.ListNode;
import com.atlassian.bamboo.specs.yaml.MapNode;
import com.atlassian.bamboo.specs.yaml.Node;
import com.atlassian.bamboo.specs.yaml.StringNode;
import com.atlassian.bamboo.specs.yaml.YamlSpecsValidationException;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.task.condition.TaskCondition;
import com.atlassian.bamboo.task.export.DefaultTaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.task.export.TaskValidationContextImpl;
import com.atlassian.bamboo.trigger.TriggerActivator;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.export.TriggerDefinitionExporter;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.v2.build.ImportExportAwarePlugin;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorOfClassPredicate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooYamlParserImpl
implements BambooYamlParser {
    private static final Logger log = Logger.getLogger(BambooYamlParserImpl.class);
    @VisibleForTesting
    public static final Predicate<ModuleDescriptor<TriggerActivator>> TRIGGER_MODULE_DESCRIPTORS_PREDICATE = new ModuleDescriptorOfClassPredicate(TriggerModuleDescriptor.class).and((Predicate)new EnabledModulePredicate());
    private final BambooYamlVersion1Converter bambooYamlVersion1Converter;
    private final BambooYamlOverrider bambooYamlOverrider;
    private final I18nBean i18nBean;
    private final PluginAccessor pluginAccessor;
    private final TaskManager taskManager;

    @Inject
    public BambooYamlParserImpl(BambooYamlVersion1Converter bambooYamlVersion1Converter, BambooYamlOverrider bambooYamlOverrider, I18nBeanFactory i18nBeanFactory, PluginAccessor pluginAccessor, TaskManager taskManager) {
        this.bambooYamlVersion1Converter = bambooYamlVersion1Converter;
        this.bambooYamlOverrider = bambooYamlOverrider;
        this.i18nBean = i18nBeanFactory.getI18nBean();
        this.pluginAccessor = pluginAccessor;
        this.taskManager = taskManager;
    }

    @Override
    @NotNull
    public BambooYamlPlanDefinition parsePlan(@NotNull Map<String, Object> rawYamlStructure, @NotNull BambooYamlVersion yamlVersion, @NotNull VcsRepositoryData repository, @NotNull RssExecutionOutputHandler stdout) {
        try {
            if (yamlVersion == BambooYamlVersion.VERSION_1) {
                return this.parsePlan(this.bambooYamlVersion1Converter.convertToYamlVersion2(rawYamlStructure), BambooYamlVersion.VERSION_2, repository, stdout);
            }
            if (rawYamlStructure.containsKey(BambooYamlPlanDefinition.Config.BRANCH_OVERRIDES)) {
                return this.parsePlan(this.bambooYamlOverrider.overrideMatchedBranch(rawYamlStructure, repository.getBranch(), stdout), BambooYamlVersion.VERSION_2, repository, stdout);
            }
            MapNode yamlStructure = new MapNode(rawYamlStructure, ValidationContext.empty());
            Plan plan = this.parsePlan(yamlStructure.getMap(BambooYamlPlanDefinition.Config.PLAN));
            ListNode stageStructures = yamlStructure.getList(BambooYamlPlanDefinition.Config.STAGES, MapNode.class);
            Set customJobKeys = stageStructures.stream().map(stageStructure -> this.extractJobKeys(yamlStructure, (MapNode)stageStructure)).flatMap(Collection::stream).collect(Collectors.toCollection(HashSet::new));
            AtomicInteger jobCounter = new AtomicInteger(1);
            HashSet usedJobKeys = new HashSet();
            HashSet usedJobNames = new HashSet();
            TaskValidationContext validationContext = new TaskValidationContextImpl.Builder().withPlan((PlanProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new com.atlassian.bamboo.specs.api.builders.plan.Plan(new Project().key(plan.getProjectKey()), plan.getName(), plan.getKey()))).withRepository(repository.getName()).build();
            List<Stage> stages = stageStructures.stream().map(stageStructure -> this.parseStage(yamlStructure, (MapNode)stageStructure, customJobKeys, usedJobKeys, usedJobNames, jobCounter, validationContext)).collect(Collectors.toList());
            List<Notification> notifications = yamlStructure.getOptionalList(BambooYamlPlanDefinition.Config.NOTIFICATIONS, MapNode.class).map(notificationList -> notificationList.stream().map(notification -> this.parseNotification((MapNode)notification, Notification.Scope.PLAN)).collect(Collectors.toList())).orElse(Collections.singletonList(Notification.createDefaultNotification()));
            List<Trigger> triggers = yamlStructure.getOptionalList(BambooYamlPlanDefinition.Config.TRIGGERS, Node.class).map(triggersList -> triggersList.stream().map(node -> this.parseTrigger((Node)node, validationContext)).collect(Collectors.toList())).orElse(Collections.singletonList(new DefaultTrigger()));
            Map<String, String> variables = this.parseVariables(yamlStructure, BambooYamlPlanDefinition.Config.VARIABLES);
            List labels = yamlStructure.getOptionalList(BambooYamlPlanDefinition.Config.LABELS, StringNode.class).map(n -> n.stream().map(StringNode::get).collect(Collectors.toList())).orElse(null);
            Docker docker = yamlStructure.getOptionalNode(BambooYamlPlanDefinition.Config.DOCKER).map(this::parseDocker).orElse(null);
            BranchManagementConfiguration branchManagementConfiguration = yamlStructure.getOptionalNode(BambooYamlPlanDefinition.Config.BRANCHES).map(this::parseBranchManagementConfiguration).orElseGet(BambooYamlParserImpl::getDefaultBranchManagementSettings);
            PlanBranchConfiguration planBranchConfiguration = yamlStructure.getOptionalNode(BambooYamlPlanDefinition.Config.BRANCH_CONFIG).map(this::parsePlanBranchConfiguration).orElse(null);
            List pluginConfigurations = yamlStructure.getOptionalMap(BambooYamlPlanDefinition.Config.OTHER).map(this::parsePlanPluginConfigurations).orElse(null);
            List unusedProperties = yamlStructure.getUnusedProperties();
            ImporterUtils.checkThat((String)this.i18nBean.getText("rss.import.yaml.unused.plan.properties", Collections.singletonList(Joiner.on((String)", ").join((Iterable)unusedProperties))), (boolean)unusedProperties.isEmpty());
            return new BambooYamlPlanDefinition(plan, stages, notifications, triggers, variables, labels, docker, branchManagementConfiguration, planBranchConfiguration, pluginConfigurations);
        }
        catch (PropertiesValidationException e) {
            throw new YamlSpecsValidationException("Document structure is incorrect: " + e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    @VisibleForTesting
    public static BranchManagementConfiguration getDefaultBranchManagementSettings() {
        return new BranchManagementConfiguration(BambooYamlParserImpl.getDefaultCreatePlanBranchSettings(), BambooYamlParserImpl.getDefaultDeletePlanBranchSettings(), null, true);
    }

    @Override
    @NotNull
    public BambooYamlDeploymentDefinition parseDeployment(@NotNull Map<String, Object> structure, @NotNull BambooYamlVersion yamlVersion, @NotNull VcsRepositoryData repository) {
        if (yamlVersion == BambooYamlVersion.VERSION_1) {
            throw new IllegalArgumentException("Deployment project is not supported in YAML v1");
        }
        try {
            MapNode yamlStructure = new MapNode(structure, ValidationContext.empty());
            DeploymentProject deploymentProject = this.parseDeploymentProject(yamlStructure.getMap(BambooYamlDeploymentDefinition.Config.DEPLOYMENT));
            ReleaseNaming releaseNaming = this.parseReleaseNaming(yamlStructure.getNode(BambooYamlDeploymentDefinition.Config.RELEASE_NAMING));
            PlanKey key = PlanKeys.getPlanKey((String)deploymentProject.getSourcePlan());
            TaskValidationContext taskValidationContext = new TaskValidationContextImpl.Builder().withDeployment((DeploymentProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new Deployment(new PlanIdentifier(PlanKeys.getProjectKeyPart((PlanKey)key), key.getPartialKey()), deploymentProject.getName()).releaseNaming(new com.atlassian.bamboo.specs.api.builders.deployment.ReleaseNaming(releaseNaming.getNextVersionName())))).withRepository(repository.getName()).build();
            List<Environment> environments = this.parseEnvironments(yamlStructure, taskValidationContext);
            List unusedProperties = yamlStructure.getUnusedProperties();
            ImporterUtils.checkThat((String)this.i18nBean.getText("rss.import.yaml.unused.deployment.properties", Collections.singletonList(Joiner.on((String)", ").join((Iterable)unusedProperties))), (boolean)unusedProperties.isEmpty());
            return new BambooYamlDeploymentDefinition(deploymentProject, releaseNaming, environments);
        }
        catch (PropertiesValidationException e) {
            throw new YamlSpecsValidationException("Document structure is incorrect: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @NotNull
    public BambooYamlDeploymentPermissionsDefinition parseDeploymentPermissions(Map<String, Object> structure, BambooYamlVersion yamlVersion) {
        if (yamlVersion == BambooYamlVersion.VERSION_1) {
            throw new IllegalArgumentException("Deployment project permissions is not supported in YAML v1");
        }
        ValidationContext validationContext = ValidationContext.empty();
        try {
            MapNode yamlStructure = new MapNode(structure, validationContext);
            String deploymentProjectName = this.getDeploymentProjectName(yamlStructure);
            List<PermissionSet> deploymentProjectPermissions = this.parsePermissionSets((ListNode<MapNode>)yamlStructure.getList("deployment-permissions", MapNode.class), Permission.Entity.DEPLOYMENT_PROJECT);
            List<PermissionSet> defaultEnvironmentPermissions = this.parseDefaultEnvironmentPermissions(yamlStructure);
            List<EnvironmentPermissions> environmentPermissions = this.parseEnvironmentPermissions(yamlStructure);
            List unusedProperties = yamlStructure.getUnusedProperties();
            ImporterUtils.checkThat((String)this.i18nBean.getText("rss.import.yaml.unused.deployment.properties", Collections.singletonList(Joiner.on((String)", ").join((Iterable)unusedProperties))), (boolean)unusedProperties.isEmpty());
            return new BambooYamlDeploymentPermissionsDefinition(deploymentProjectName, deploymentProjectPermissions, defaultEnvironmentPermissions, environmentPermissions);
        }
        catch (PropertiesValidationException e) {
            throw new YamlSpecsValidationException("Document structure is incorrect: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @NotNull
    public BambooYamlPlanPermissionsDefinition parsePlanPermissions(Map<String, Object> structure, BambooYamlVersion yamlVersion) throws YamlSpecsValidationException {
        if (yamlVersion == BambooYamlVersion.VERSION_1) {
            throw new IllegalArgumentException("Plan permissions is not supported in YAML v1");
        }
        ValidationContext validationContext = ValidationContext.empty();
        try {
            MapNode yamlStructure = new MapNode(structure, validationContext);
            String planKey = this.getPlanKey(yamlStructure);
            List<PermissionSet> permissions = this.parsePermissionSets((ListNode<MapNode>)yamlStructure.getList("plan-permissions", MapNode.class), Permission.Entity.PLAN);
            List unusedProperties = yamlStructure.getUnusedProperties();
            ImporterUtils.checkThat((String)this.i18nBean.getText("rss.import.yaml.unused.plan.properties", Collections.singletonList(Joiner.on((String)", ").join((Iterable)unusedProperties))), (boolean)unusedProperties.isEmpty());
            return new BambooYamlPlanPermissionsDefinition(planKey, permissions);
        }
        catch (PropertiesValidationException e) {
            throw new YamlSpecsValidationException("Document structure is incorrect: " + e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    private static CreatePlanBranchSettings getDefaultCreatePlanBranchSettings() {
        return new CreatePlanBranchSettings(CreatePlanBranchSettings.Type.BRANCH, null);
    }

    @NotNull
    private static DeletePlanBranchSettings getDefaultDeletePlanBranchSettings() {
        return new DeletePlanBranchSettings(true, 1, 30);
    }

    @NotNull
    private String getDeploymentProjectName(MapNode yamlStructure) {
        Node node = yamlStructure.getNode(BambooYamlDeploymentDefinition.Config.DEPLOYMENT);
        if (node instanceof StringNode) {
            return ((StringNode)node).get();
        }
        if (node instanceof MapNode) {
            return ((MapNode)node).getString(DeploymentProject.Config.NAME).get();
        }
        throw new YamlSpecsValidationException(yamlStructure.getValidationContext().toString() + " Can't read deployment project name");
    }

    @NotNull
    private String getPlanKey(MapNode yamlStructure) {
        Node node = yamlStructure.getNode(BambooYamlPlanDefinition.Config.PLAN);
        if (node instanceof StringNode) {
            return ((StringNode)node).get();
        }
        if (node instanceof MapNode) {
            return ((MapNode)node).getString("key").get();
        }
        throw new YamlSpecsValidationException(yamlStructure.getValidationContext().toString() + " Unknown plan key format " + node);
    }

    @NotNull
    private List<EnvironmentPermissions> parseEnvironmentPermissions(MapNode structure) {
        return structure.getOptionalList("environment-permissions", MapNode.class).map(environmentList -> environmentList.stream().map(this::parseEnvironmentPermission).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @NotNull
    private EnvironmentPermissions parseEnvironmentPermission(MapNode mapNode) {
        Collection properties = mapNode.getProperties();
        if (properties.isEmpty()) {
            throw new PropertiesValidationException(mapNode.getValidationContext(), "No environment name provided");
        }
        if (properties.size() > 1) {
            throw new PropertiesValidationException(mapNode.getValidationContext(), "Ambiguous environment name provided");
        }
        String name = (String)properties.iterator().next();
        List<PermissionSet> permissionSets = this.parsePermissionSets((ListNode<MapNode>)mapNode.getList(name, MapNode.class), Permission.Entity.ENVIRONMENT);
        return new EnvironmentPermissions(name, permissionSets);
    }

    @NotNull
    private List<PermissionSet> parseDefaultEnvironmentPermissions(@NotNull MapNode yamlStructure) {
        Optional list = yamlStructure.getOptionalList("default-environment-permissions", MapNode.class);
        if (list.isPresent()) {
            return this.parsePermissionSets((ListNode<MapNode>)((ListNode)list.get()), Permission.Entity.ENVIRONMENT);
        }
        return Collections.emptyList();
    }

    private List<PermissionSet> parsePermissionSets(ListNode<MapNode> list, Permission.Entity entity) {
        return list.stream().map(node -> this.parsePermissionSet((MapNode)node, entity)).collect(Collectors.toList());
    }

    private PermissionSet parsePermissionSet(MapNode node, Permission.Entity entity) {
        try {
            Set<String> users = this.getPermissionSetAttribute(node, "users", Function.identity());
            Set<String> groups = this.getPermissionSetAttribute(node, "groups", Function.identity());
            Set<PermissionSet.Role> roles = this.getPermissionSetAttribute(node, "roles", PermissionSet.Role::byLabel);
            Set<Permission> permissions = this.getPermissionSetAttribute(node, "permissions", val -> Permission.byLabel(val, entity));
            return new PermissionSet(users, groups, roles, permissions);
        }
        catch (Exception e) {
            throw new YamlSpecsValidationException(node.getValidationContext().with(e.getMessage()).toString(), (Throwable)e);
        }
    }

    private <T> Set<T> getPermissionSetAttribute(@NotNull MapNode node, @NotNull String key, @NotNull Function<String, T> converter) {
        HashSet<T> result = new HashSet<T>();
        Optional optionalUsers = node.getOptionalNode(key);
        if (optionalUsers.isPresent()) {
            if (optionalUsers.get() instanceof StringNode) {
                String value = ((StringNode)optionalUsers.get()).get();
                result.add(converter.apply(value));
            } else {
                result.addAll(node.getOptionalList(key, StringNode.class).map(usersList -> usersList.stream().map(StringNode::get).map(converter).collect(Collectors.toSet())).orElse(Collections.emptySet()));
            }
        }
        return result;
    }

    private List<Environment> parseEnvironments(MapNode structure, TaskValidationContext validationContext) {
        Optional optionalList = structure.getOptionalList(BambooYamlDeploymentDefinition.Config.ENVIRONMENTS, StringNode.class);
        if (!optionalList.isPresent()) {
            return new ArrayList<Environment>();
        }
        ListNode environmentsList = (ListNode)optionalList.get();
        return environmentsList.stream().map(node -> this.parseEnvironment(node.get(), structure.getMap(node.get()), validationContext)).collect(Collectors.toList());
    }

    private Environment parseEnvironment(String name, MapNode structure, TaskValidationContext validationContext) {
        Docker docker = structure.getOptionalNode(Environment.Config.DOCKER).map(this::parseDocker).orElse(null);
        TaskValidationContext taskValidationContext = new TaskValidationContextImpl.Builder().withContext(validationContext).withEnvironment((EnvironmentProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new com.atlassian.bamboo.specs.api.builders.deployment.Environment(name))).build();
        List<Task> tasks = structure.getList(Environment.Config.TASKS, Node.class).stream().map(taskStructure -> this.parseTask((Node)taskStructure, taskValidationContext)).collect(Collectors.toList());
        List<Task> finalTasks = structure.getOptionalList(Environment.Config.FINAL_TASKS, Node.class).map(tasksList -> tasksList.stream().map(taskStructure -> this.parseTask((Node)taskStructure, taskValidationContext)).collect(Collectors.toList())).orElse(Collections.emptyList());
        List requirements = structure.getOptionalList(Environment.Config.REQUIREMENTS, Node.class).map(this::getRequirements).orElse(new ArrayList());
        Map<String, String> variables = this.parseVariables(structure, Environment.Config.VARIABLES);
        List<Trigger> triggers = structure.getOptionalList(Environment.Config.TRIGGERS, Node.class).map(triggersList -> triggersList.stream().map(node -> this.parseTrigger((Node)node, validationContext)).collect(Collectors.toList())).orElse(Collections.emptyList());
        List<Notification> notifications = structure.getOptionalList(Environment.Config.NOTIFICATIONS, MapNode.class).map(notificationList -> notificationList.stream().map(notification -> this.parseNotification((MapNode)notification, Notification.Scope.DEPLOYMENT)).collect(Collectors.toList())).orElse(Collections.emptyList());
        List environmentPluginConfigurations = structure.getOptionalMap(Environment.Config.OTHER).map(this::parseEnvironmentPluginConfigurations).orElse(null);
        return new Environment(name, tasks, finalTasks, variables, requirements, triggers, notifications, docker, environmentPluginConfigurations);
    }

    @NotNull
    private List<EnvironmentPluginConfiguration<?>> parseEnvironmentPluginConfigurations(final MapNode node) {
        ArrayList result = new ArrayList();
        Collection moduleDescriptors = this.pluginAccessor.getModuleDescriptors(new ModuleDescriptorOfClassPredicate(CustomEnvironmentConfigPluginModuleDescriptor.class).and((Predicate)new EnabledModulePredicate()));
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            CustomEnvironmentConfigPluginModuleDescriptor customEnvironmentConfigPluginModuleDescriptor;
            CustomEnvironmentConfigPluginExporter exporter;
            if (!(moduleDescriptor instanceof CustomEnvironmentConfigPluginModuleDescriptor) || (exporter = (customEnvironmentConfigPluginModuleDescriptor = (CustomEnvironmentConfigPluginModuleDescriptor)moduleDescriptor).getExporter()) == null) continue;
            try {
                EnvironmentPluginConfiguration config = (EnvironmentPluginConfiguration)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Callable<EnvironmentPluginConfiguration<?>>("Can't convert YAML config"){

                    @Nullable
                    public EnvironmentPluginConfiguration<?> call() {
                        return exporter.fromYaml((Node)node);
                    }
                });
                if (config == null) continue;
                result.add(config);
            }
            catch (Exception e) {
                log.error((Object)("Error when read plugin config by " + moduleDescriptor.getCompleteKey() + " :" + e.getMessage()), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private Map<String, String> parseVariables(MapNode structure, String property) {
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        structure.getOptionalMap(property).ifPresent(variablesList -> variablesList.getProperties().forEach(variableName -> variables.put((String)variableName, variablesList.getString(variableName).get())));
        return variables;
    }

    @NotNull
    private ReleaseNaming parseReleaseNaming(@NotNull Node node) {
        boolean appliesToBranchesDefault = false;
        boolean autoIncrementDefault = false;
        if (node instanceof StringNode) {
            return new ReleaseNaming(((StringNode)node).get(), false, false, Collections.emptyList());
        }
        if (node instanceof MapNode) {
            MapNode yaml = (MapNode)node;
            String name = yaml.getString(ReleaseNaming.Config.NAME).get();
            boolean appliesToBranches = this.getBooleanProperty(yaml, ReleaseNaming.Config.APPLIES_TO_BRANCHES, false);
            boolean autoIncrement = this.getBooleanProperty(yaml, ReleaseNaming.Config.AUTOINCREMENT, false);
            List autoincrementList = yaml.getOptionalList(ReleaseNaming.Config.AUTOINCREMENT_VARIABLES, StringNode.class).map(n -> n.stream().map(StringNode::get).collect(Collectors.toList())).orElse(new ArrayList());
            return new ReleaseNaming(name, appliesToBranches, autoIncrement, autoincrementList);
        }
        throw new PropertiesValidationException(node.getValidationContext(), "Can't parse release naming. Unknown format");
    }

    private boolean getBooleanProperty(MapNode yamlStructureMap, String property, boolean defaultValue) {
        return yamlStructureMap.getOptionalString(property).map(StringNode::get).map(Boolean::parseBoolean).orElse(defaultValue);
    }

    private DeploymentProject parseDeploymentProject(MapNode deploymentStructureMap) {
        String name = deploymentStructureMap.getString(DeploymentProject.Config.NAME).get();
        String sourcePlan = deploymentStructureMap.getString(DeploymentProject.Config.SOURCE_PLAN).get();
        return new DeploymentProject(name, sourcePlan);
    }

    @NotNull
    private Docker parseDocker(@NotNull Node dockerStructure) {
        if (dockerStructure instanceof StringNode) {
            return new Docker(((StringNode)dockerStructure).get(), Collections.emptyMap(), Collections.emptyList(), true);
        }
        if (dockerStructure instanceof MapNode) {
            MapNode dockerStructureMap = (MapNode)dockerStructure;
            String image = dockerStructureMap.getString(Docker.Config.IMAGE).get();
            LinkedHashMap<String, String> volumes = new LinkedHashMap<String, String>();
            ArrayList<String> dockerRunArguments = new ArrayList<String>();
            dockerStructureMap.getOptionalMap(Docker.Config.VOLUMES).ifPresent(volumeMappings -> volumeMappings.getProperties().forEach(volume -> volumes.put((String)volume, volumeMappings.getString(volume).get())));
            boolean useDefaultVolumes = this.getBooleanProperty(dockerStructureMap, Docker.Config.USE_DEFAULT_VOLUMES, true);
            dockerStructureMap.getOptionalList(Docker.Config.ARGUMENTS, StringNode.class).ifPresent(l -> l.getList().forEach(s -> {
                if (!StringUtils.isBlank((CharSequence)s.get())) {
                    dockerRunArguments.add(s.get().trim());
                }
            }));
            return new Docker(image, volumes, dockerRunArguments, useDefaultVolumes);
        }
        throw new PropertiesValidationException(dockerStructure.getValidationContext(), "Unknown configuration format of docker");
    }

    @NotNull
    private MasterBranch parseBranch(@NotNull Node branchStructure) {
        if (branchStructure instanceof StringNode) {
            return new MasterBranch(((StringNode)branchStructure).get());
        }
        if (branchStructure instanceof MapNode) {
            MapNode branchStructureMap = (MapNode)branchStructure;
            String name = branchStructureMap.getString(MasterBranch.Config.NAME).get();
            String displayName = branchStructureMap.getOptionalString(MasterBranch.Config.DISPLAY_NAME).map(StringNode::get).orElse(null);
            if (StringUtils.isBlank((CharSequence)displayName)) {
                return new MasterBranch(name);
            }
            return new MasterBranch(name, displayName);
        }
        throw new PropertiesValidationException(branchStructure.getValidationContext(), "Unknown configuration format of repository branch");
    }

    @NotNull
    private Plan parsePlan(@NotNull MapNode planStructure) {
        String projectKey = planStructure.getString(Plan.Config.PROJECT_KEY).get();
        String key = planStructure.getString(Plan.Config.KEY).get();
        String name = planStructure.getString(Plan.Config.NAME).get();
        MasterBranch repositoryBranch = planStructure.getOptionalNode(Plan.Config.BRANCH).map(this::parseBranch).orElse(null);
        return new Plan(projectKey, key, name, repositoryBranch);
    }

    @NotNull
    private BranchManagementConfiguration parseBranchManagementConfiguration(@NotNull Node node) {
        if (node instanceof MapNode) {
            MapNode branchManagementConfigurationMap = (MapNode)node;
            CreatePlanBranchSettings create = branchManagementConfigurationMap.getOptionalNode(BranchManagementConfiguration.Config.CREATE).map(this::parseCreatePlanBranchSettings).orElseGet(BambooYamlParserImpl::getDefaultCreatePlanBranchSettings);
            DeletePlanBranchSettings delete = branchManagementConfigurationMap.getOptionalNode(BranchManagementConfiguration.Config.DELETE).map(this::parseDeletePlanBranchSettings).orElseGet(BambooYamlParserImpl::getDefaultDeletePlanBranchSettings);
            BranchIntegrationSettings integration = branchManagementConfigurationMap.getOptionalNode(BranchManagementConfiguration.Config.INTEGRATION).map(this::parseBranchIntegrationSettings).orElse(null);
            boolean linkToJira = branchManagementConfigurationMap.getOptionalString(BranchManagementConfiguration.Config.LINK_TO_JIRA).map(str -> Boolean.parseBoolean(str.get())).orElse(false);
            return new BranchManagementConfiguration(create, delete, integration, linkToJira);
        }
        throw new PropertiesValidationException(node.getValidationContext(), "Unknown branch configuration format");
    }

    @NotNull
    private PlanBranchConfiguration parsePlanBranchConfiguration(@NotNull Node node) {
        if (node instanceof MapNode) {
            MapNode planBranchConfigurationMap = (MapNode)node;
            BranchIntegrationSettings integration = planBranchConfigurationMap.getOptionalNode(PlanBranchConfiguration.Config.INTEGRATION).map(this::parseBranchIntegrationSettings).orElse(null);
            boolean disableAutomaticallyBranchCleanup = planBranchConfigurationMap.getOptionalString(PlanBranchConfiguration.Config.DISABLE_EXPIRY).map(str -> Boolean.parseBoolean(str.get())).orElse(false);
            return new PlanBranchConfiguration(integration, disableAutomaticallyBranchCleanup);
        }
        throw new PropertiesValidationException(node.getValidationContext(), "Unknown branch configuration format");
    }

    @NotNull
    private BranchIntegrationSettings parseBranchIntegrationSettings(@NotNull Node node) {
        if (node instanceof MapNode) {
            BranchIntegrationSettings.Strategy strategy;
            String branch;
            MapNode mapNode = (MapNode)node;
            Optional mergeFrom = mapNode.getOptionalString(BranchIntegrationSettings.Config.MERGE_FROM);
            Optional mergeTo = mapNode.getOptionalString(BranchIntegrationSettings.Config.MERGE_TO);
            if (mergeFrom.isPresent() && mergeTo.isPresent()) {
                throw new PropertiesValidationException(node.getValidationContext(), String.format("Can't use both merge strategies for branch integration. Use %s or %s", BranchIntegrationSettings.Config.MERGE_FROM, BranchIntegrationSettings.Config.MERGE_TO));
            }
            if (!mergeFrom.isPresent() && !mergeTo.isPresent()) {
                throw new PropertiesValidationException(node.getValidationContext(), String.format("Can't enable branch integration without merge strategy. Use %s or %s", BranchIntegrationSettings.Config.MERGE_FROM, BranchIntegrationSettings.Config.MERGE_TO));
            }
            if (mergeFrom.isPresent()) {
                branch = ((StringNode)mergeFrom.get()).get();
                strategy = BranchIntegrationSettings.Strategy.BRANCH_UPDATER;
            } else {
                branch = ((StringNode)mergeTo.get()).get();
                strategy = BranchIntegrationSettings.Strategy.GATEKEEPER;
            }
            boolean push = mapNode.getOptionalString(BranchIntegrationSettings.Config.PUSH).map(str -> Boolean.parseBoolean(str.get())).orElse(false);
            return new BranchIntegrationSettings(strategy, branch, push);
        }
        throw new PropertiesValidationException(node.getValidationContext(), "Unknown branch integration settings format");
    }

    @NotNull
    private DeletePlanBranchSettings parseDeletePlanBranchSettings(@NotNull Node node) {
        if (node instanceof StringNode) {
            if (DeletePlanBranchSettings.Config.DISABLED.equals(((StringNode)node).get())) {
                return new DeletePlanBranchSettings(false, 0, 0);
            }
            throw new PropertiesValidationException(node.getValidationContext(), "Unknown format of delete plan branch configuration. Use '" + DeletePlanBranchSettings.Config.DISABLED + "' if want to avoid automatic plan branches removal.");
        }
        if (node instanceof MapNode) {
            MapNode mapNode = (MapNode)node;
            int deleteDays = this.parseBranchRemovalDaysParameter(mapNode, DeletePlanBranchSettings.Config.DELETED_DAYS, 0, 1);
            int inactiveDays = this.parseBranchRemovalDaysParameter(mapNode, DeletePlanBranchSettings.Config.INACTIVE_DAYS, 1, 30);
            return new DeletePlanBranchSettings(true, deleteDays, inactiveDays);
        }
        throw new PropertiesValidationException(node.getValidationContext(), "Unknown format of delete plan branch configuration");
    }

    private int parseBranchRemovalDaysParameter(MapNode node, String key, int minimumCleanUpPeriod, int defaultTimeout) throws PropertiesValidationException {
        return node.getOptionalString(key).map(str -> {
            if (DeletePlanBranchSettings.Config.DISABLED.equals(str.get())) {
                return -1;
            }
            int i = this.safeParseInteger((StringNode)str, str.getValidationContext().with(key), m -> "Should be integer");
            if (i < minimumCleanUpPeriod) {
                throw new PropertiesValidationException(str.getValidationContext(), this.i18nBean.getText("chain.config.branches.deletion.error.wrong.range", Collections.singletonList(minimumCleanUpPeriod)));
            }
            return i;
        }).orElse(defaultTimeout);
    }

    @NotNull
    private CreatePlanBranchSettings parseCreatePlanBranchSettings(@NotNull Node node) {
        if (node instanceof StringNode) {
            CreatePlanBranchSettings.Type type;
            try {
                type = CreatePlanBranchSettings.Type.parse(((StringNode)node).get());
            }
            catch (IllegalArgumentException e) {
                throw new PropertiesValidationException(node.getValidationContext(), e.getMessage());
            }
            return new CreatePlanBranchSettings(type, null);
        }
        if (node instanceof MapNode) {
            MapNode mapNode = (MapNode)node;
            String matchPattern = mapNode.getString(CreatePlanBranchSettings.Type.BRANCH.getKey()).get();
            return new CreatePlanBranchSettings(CreatePlanBranchSettings.Type.BRANCH, matchPattern);
        }
        throw new PropertiesValidationException(node.getValidationContext(), "Unknown create plan branch settings format");
    }

    @Nullable
    private List<PluginConfiguration> parsePlanPluginConfigurations(MapNode node) {
        List<PluginConfiguration> pluginConfiguration = this.getPluginSupportedConfigurations(node);
        if (pluginConfiguration.size() > 0) {
            return pluginConfiguration;
        }
        return null;
    }

    private Set<String> extractJobKeys(@NotNull MapNode documentStructure, @NotNull MapNode stageStructure) {
        Optional<ListNode> jobNames;
        Collection properties = stageStructure.getProperties();
        ImporterUtils.checkThat((ValidationContext)stageStructure.getValidationContext(), (properties.size() == 1 ? 1 : 0) != 0, (String)"Stage must have its name defined as the only YAML property", (Object[])new Object[0]);
        String name = (String)properties.iterator().next();
        Node innerStageStructure = stageStructure.getNode(name);
        if (innerStageStructure instanceof MapNode) {
            jobNames = ((MapNode)innerStageStructure).getOptionalList(Stage.Config.JOBS, StringNode.class);
        } else if (innerStageStructure instanceof ListNode) {
            jobNames = Optional.of(((ListNode)innerStageStructure).asListOf(StringNode.class));
        } else {
            throw new PropertiesValidationException(innerStageStructure.getValidationContext(), "Unknown configuration format of stage");
        }
        return jobNames.map(l -> l.stream().map(StringNode::get).map(arg_0 -> ((MapNode)documentStructure).getMap(arg_0)).map(jobStructure -> jobStructure.getOptionalString(Job.Config.KEY)).filter(Optional::isPresent).map(Optional::get).map(StringNode::get).collect(Collectors.toSet())).orElseGet(Collections::emptySet);
    }

    @NotNull
    private Stage parseStage(@NotNull MapNode documentStructure, @NotNull MapNode stageStructure, @NotNull Collection<String> customJobKeys, @NotNull Collection<String> usedJobKeys, @NotNull Collection<String> usedJobNames, @NotNull AtomicInteger jobCounter, @NotNull TaskValidationContext validationContext) {
        boolean isFinal;
        boolean isManual;
        Optional<ListNode> jobNames;
        Collection properties = stageStructure.getProperties();
        ImporterUtils.checkThat((ValidationContext)stageStructure.getValidationContext(), (properties.size() == 1 ? 1 : 0) != 0, (String)"Stage must have its name defined as the only YAML property", (Object[])new Object[0]);
        String name = (String)properties.iterator().next();
        Node innerStageStructure = stageStructure.getNode(name);
        if (innerStageStructure instanceof MapNode) {
            MapNode innerStageMapStructure = (MapNode)innerStageStructure;
            jobNames = innerStageMapStructure.getOptionalList(Stage.Config.JOBS, StringNode.class);
            isManual = innerStageMapStructure.getOptionalString(Stage.Config.MANUAL).map(stringNode -> Boolean.parseBoolean(stringNode.get())).orElse(false);
            isFinal = innerStageMapStructure.getOptionalString(Stage.Config.FINAL).map(stringNode -> Boolean.parseBoolean(stringNode.get())).orElse(false);
        } else if (innerStageStructure instanceof ListNode) {
            jobNames = Optional.of(((ListNode)innerStageStructure).asListOf(StringNode.class));
            isManual = false;
            isFinal = false;
        } else {
            throw new PropertiesValidationException(innerStageStructure.getValidationContext(), "Unknown configuration format of stage");
        }
        List jobs = jobNames.map(l -> l.stream().map(StringNode::get).peek(jobName -> ImporterUtils.checkThat((ValidationContext)innerStageStructure.getValidationContext(), (boolean)usedJobNames.add((String)jobName), (String)"Duplicate job name: %s", (Object[])new Object[]{jobName})).map(jobName -> this.parseJob((String)jobName, documentStructure.getMap(jobName), customJobKeys, usedJobKeys, jobCounter, validationContext)).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        return new Stage(name, jobs, isManual, isFinal);
    }

    @NotNull
    private Job parseJob(@NotNull String name, @NotNull MapNode jobStructure, @NotNull Collection<String> customJobKeys, @NotNull Collection<String> usedJobKeys, @NotNull AtomicInteger jobCounter, @NotNull TaskValidationContext validationContext) {
        String key = jobStructure.getOptionalString(Job.Config.KEY).map(StringNode::get).orElseGet(() -> IntStream.generate(jobCounter::getAndIncrement).mapToObj(i -> "JOB" + i).filter(jobKey -> !usedJobKeys.contains(jobKey) && !customJobKeys.contains(jobKey)).findFirst().orElseThrow(IllegalStateException::new));
        ImporterUtils.checkThat((ValidationContext)jobStructure.getValidationContext(), (boolean)usedJobKeys.add(key), (String)("Duplicate job key: " + key), (Object[])new Object[0]);
        TaskValidationContext taskValidationContext = new TaskValidationContextImpl.Builder().withContext(validationContext).withJob((JobProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new com.atlassian.bamboo.specs.api.builders.plan.Job(name, key))).build();
        List<Task> tasks = jobStructure.getOptionalList(Job.Config.TASKS, Node.class).map(tasksList -> tasksList.stream().map(taskStructure -> this.parseTask((Node)taskStructure, taskValidationContext)).collect(Collectors.toList())).orElse(Collections.emptyList());
        List<Task> finalTasks = jobStructure.getOptionalList(Job.Config.FINAL_TASKS, Node.class).map(tasksList -> tasksList.stream().map(taskStructure -> this.parseTask((Node)taskStructure, taskValidationContext)).collect(Collectors.toList())).orElse(Collections.emptyList());
        List<Requirement> requirements = jobStructure.getOptionalList(Job.Config.REQUIREMENTS, Node.class).map(this::getRequirements).orElse(Collections.emptyList());
        List<Artifact> artifacts = jobStructure.getOptionalList(Job.Config.ARTIFACTS, MapNode.class).map(artifactsList -> artifactsList.stream().map(this::parseArtifact).collect(Collectors.toList())).orElse(Collections.emptyList());
        Docker docker = jobStructure.getOptionalNode(Job.Config.DOCKER).map(this::parseDocker).orElse(null);
        Other other = jobStructure.getOptionalMap(Job.Config.OTHER).map(this::parseJobPluginConfiguration).orElse(null);
        return new Job(key, name, tasks, finalTasks, requirements, artifacts, docker, other);
    }

    @NotNull
    private List<Requirement> getRequirements(ListNode<Node> requirementsList) {
        return requirementsList.stream().map(item -> {
            if (item instanceof StringNode) {
                return new Requirement(((StringNode)item).get(), null, Requirement.Type.EXISTS);
            }
            if (item instanceof MapNode) {
                MapNode mapNode = (MapNode)item;
                Collection properties = mapNode.getProperties();
                ImporterUtils.checkThat((ValidationContext)mapNode.getValidationContext(), (properties.size() == 1 ? 1 : 0) != 0, (String)"Requirement must have its name defined as the only YAML property", (Object[])new Object[0]);
                String requirementName = (String)properties.iterator().next();
                Node requirementValue = mapNode.getNode(requirementName);
                if (requirementValue instanceof StringNode) {
                    return new Requirement(requirementName, ((StringNode)requirementValue).get(), Requirement.Type.MATCHES);
                }
                throw new PropertiesValidationException(requirementValue.getValidationContext(), "Can't parse requirement definition");
            }
            throw new PropertiesValidationException(item.getValidationContext(), "Unknown requirement type format " + item);
        }).collect(Collectors.toList());
    }

    @NotNull
    private Task parseTask(@NotNull Node taskStructure, TaskValidationContext validationContext) {
        if (taskStructure instanceof StringNode) {
            StringNode taskStructureString = (StringNode)taskStructure;
            String taskTypeName = taskStructureString.get();
            Task task = this.findPluginAwareTask((Node)taskStructureString, validationContext);
            if (task != null) {
                return task;
            }
            throw new PropertiesValidationException(taskStructure.getValidationContext(), "Task of type " + taskTypeName + " requires additional configuration");
        }
        if (taskStructure instanceof MapNode) {
            MapNode taskStructureMap = (MapNode)taskStructure;
            Collection properties = taskStructureMap.getProperties();
            ImporterUtils.checkThat((ValidationContext)taskStructure.getValidationContext(), (properties.size() == 1 ? 1 : 0) != 0, (String)"Task must have its type defined as the only YAML property", (Object[])new Object[0]);
            String taskTypeName = (String)properties.iterator().next();
            Task task = this.findPluginAwareTask((Node)taskStructureMap, validationContext);
            if (task != null) {
                return task;
            }
            throw new PropertiesValidationException(taskStructure.getValidationContext(), "Unknown task type " + taskTypeName);
        }
        throw new PropertiesValidationException(taskStructure.getValidationContext(), "Unknown configuration format of task");
    }

    private Task findPluginAwareTask(final Node node, final TaskValidationContext validationContext) {
        Optional<Task> task = this.taskManager.getAvailableTaskDescriptors().stream().map(TaskModuleDescriptor::getTaskExporter).filter(Objects::nonNull).map(exporter -> (Task)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Callable<Task>("Error parse YAML task"){

            @Nullable
            public Task call() {
                return exporter.fromYaml(node, validationContext);
            }
        })).filter(Objects::nonNull).findFirst();
        Object result = task.isPresent() ? task.get() : new DefaultTaskDefinitionExporter().fromYaml(node, validationContext);
        if (result != null) {
            this.appendConditions((Task)result, node, validationContext);
        }
        return result;
    }

    private Task appendConditions(@NotNull Task task, @NotNull Node node, @NotNull TaskValidationContext validationContext) {
        String taskName;
        Node taskStructure;
        if (node instanceof MapNode && (taskStructure = ((MapNode)node).getNode(taskName = (String)((MapNode)node).getProperties().iterator().next())) instanceof MapNode && ((MapNode)taskStructure).getOptionalNode(Job.Config.TASK_CONDITIONS).isPresent()) {
            Node conditionsNode = ((MapNode)taskStructure).getNode(Job.Config.TASK_CONDITIONS);
            if (conditionsNode instanceof ListNode) {
                Predicate predicate = new ModuleDescriptorOfClassPredicate(TaskConditionModuleDescriptor.class).and((Predicate)new EnabledModulePredicate());
                Collection availableConditions = this.pluginAccessor.getModuleDescriptors(predicate);
                List<com.atlassian.bamboo.specs.api.builders.condition.TaskCondition> conditions = ((ListNode)conditionsNode).stream().map(item -> this.parseCondition((Node)item, availableConditions, validationContext)).filter(Objects::nonNull).collect(Collectors.toList());
                task.conditions(conditions.toArray(new com.atlassian.bamboo.specs.api.builders.condition.TaskCondition[0]));
            } else {
                throw new PropertiesValidationException("Only list format is supported for " + Job.Config.TASK_CONDITIONS + "." + node.getValidationContext());
            }
        }
        return task;
    }

    @Nullable
    private com.atlassian.bamboo.specs.api.builders.condition.TaskCondition parseCondition(final @NotNull Node node, Collection<ModuleDescriptor<TaskCondition>> availableConditions, final @NotNull TaskValidationContext validationContext) {
        return availableConditions.stream().map(descriptor -> (com.atlassian.bamboo.specs.api.builders.condition.TaskCondition)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Callable<com.atlassian.bamboo.specs.api.builders.condition.TaskCondition>("Error importing task condition from YAML"){

            @Nullable
            public com.atlassian.bamboo.specs.api.builders.condition.TaskCondition call() {
                return ((TaskCondition)descriptor.getModule()).fromYaml(node, validationContext);
            }
        })).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @NotNull
    private Artifact parseArtifact(@NotNull MapNode artifactStructure) {
        String name = artifactStructure.getString(Artifact.Config.NAME).get();
        String location = artifactStructure.getOptionalString(Artifact.Config.LOCATION).map(StringNode::get).orElse(null);
        String pattern = artifactStructure.getString(Artifact.Config.PATTERN).get();
        boolean shared = artifactStructure.getOptionalString(Artifact.Config.SHARED).map(stringNode -> Boolean.parseBoolean(stringNode.get())).orElse(true);
        boolean required = artifactStructure.getOptionalString(Artifact.Config.REQUIRED).map(stringNode -> Boolean.parseBoolean(stringNode.get())).orElse(true);
        return new Artifact(name, location, pattern, shared, required);
    }

    @NotNull
    private Other parseJobPluginConfiguration(@NotNull MapNode otherStructure) {
        boolean cleanWorkingDir = otherStructure.getOptionalString(Other.Config.CLEAN_WORKING_DIR).map(stringNode -> Boolean.parseBoolean(stringNode.get())).orElse(false);
        List<PluginConfiguration> pluginConfiguration = this.getPluginSupportedConfigurations(otherStructure);
        return new Other(cleanWorkingDir, pluginConfiguration);
    }

    @NotNull
    private List<PluginConfiguration> getPluginSupportedConfigurations(final @NotNull MapNode otherStructure) {
        ArrayList<PluginConfiguration> pluginConfiguration = new ArrayList<PluginConfiguration>();
        Predicate<ModuleDescriptor> importExportAwareModuleDescriptors = descriptor -> descriptor.getModuleClass() != null && ImportExportAwarePlugin.class.isAssignableFrom(descriptor.getModuleClass());
        Collection exportableModuleDescriptors = this.pluginAccessor.getModuleDescriptors(importExportAwareModuleDescriptors.and((Predicate<ModuleDescriptor>)new EnabledModulePredicate()));
        exportableModuleDescriptors.forEach(descriptor -> {
            PluginConfiguration result = (PluginConfiguration)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Callable<PluginConfiguration>("Error reading YAML plugin config " + descriptor.getModuleClass()){

                @Nullable
                public PluginConfiguration call() {
                    return ((ImportExportAwarePlugin)descriptor.getModule()).fromYaml((Node)otherStructure);
                }
            });
            if (result != null) {
                pluginConfiguration.add(result);
            }
        });
        return pluginConfiguration;
    }

    @NotNull
    private Trigger parseTrigger(final @NotNull Node triggerStructure, final @NotNull TaskValidationContext context) {
        Collection moduleDescriptors = this.pluginAccessor.getModuleDescriptors(TRIGGER_MODULE_DESCRIPTORS_PREDICATE);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            com.atlassian.bamboo.specs.api.builders.trigger.Trigger trigger;
            TriggerDefinitionExporter exporter;
            TriggerModuleDescriptor triggerModuleDescriptor = (TriggerModuleDescriptor)Narrow.downTo((Object)moduleDescriptor, TriggerModuleDescriptor.class);
            if (triggerModuleDescriptor == null || (exporter = triggerModuleDescriptor.getTriggerExporter()) == null || (trigger = (com.atlassian.bamboo.specs.api.builders.trigger.Trigger)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Callable<com.atlassian.bamboo.specs.api.builders.trigger.Trigger>("Error parse YAML trigger"){

                @Nullable
                public com.atlassian.bamboo.specs.api.builders.trigger.Trigger call() throws Exception {
                    return exporter.fromYaml(triggerStructure, context);
                }
            })) == null) continue;
            return new PluginAwareTrigger(trigger);
        }
        if (triggerStructure instanceof StringNode) {
            StringNode triggerStructureString = (StringNode)triggerStructure;
            String triggerTypeName = triggerStructureString.get();
            throw new PropertiesValidationException(triggerStructure.getValidationContext(), "Unknown trigger type " + triggerTypeName);
        }
        if (triggerStructure instanceof MapNode) {
            MapNode triggerStructureMap = (MapNode)triggerStructure;
            Collection properties = triggerStructureMap.getProperties();
            String triggerTypeName = (String)properties.iterator().next();
            throw new YamlSpecsValidationException("Unknown trigger type " + triggerTypeName);
        }
        throw new PropertiesValidationException(triggerStructure.getValidationContext(), "Unknown configuration format of trigger");
    }

    @NotNull
    private Notification parseNotification(@NotNull MapNode notificationStructure, @NotNull Notification.Scope notificationScope) {
        List<NotificationEvent> notificationEvents;
        Node eventsStructure = notificationStructure.getNode(Notification.Config.EVENTS);
        if (eventsStructure instanceof StringNode) {
            notificationEvents = Collections.singletonList(this.parseNotificationEvent(eventsStructure, notificationScope));
        } else if (eventsStructure instanceof ListNode) {
            ListNode listNode = ((ListNode)eventsStructure).asListOf(Node.class);
            notificationEvents = listNode.stream().map(notificationEvent -> this.parseNotificationEvent((Node)notificationEvent, notificationScope)).collect(Collectors.toList());
        } else {
            throw new PropertiesValidationException(eventsStructure.getValidationContext(), "Unknown configuration format of notifications events");
        }
        List<NotificationRecipients> recipients = notificationStructure.getList(Notification.Config.RECIPIENTS, Node.class).stream().map(notificationRecipient -> this.parseNotificationRecipients((Node)notificationRecipient, notificationScope)).collect(Collectors.toList());
        return new Notification(notificationEvents, recipients);
    }

    @NotNull
    private NotificationEvent parseNotificationEvent(@NotNull Node eventStructure, @NotNull Notification.Scope notificationScope) {
        if (eventStructure instanceof StringNode) {
            StringNode eventStructureString = (StringNode)eventStructure;
            NotificationEvent.NotificationEventType eventType = NotificationEvent.NotificationEventType.fromValue(eventStructureString.get()).orElseThrow(() -> new PropertiesValidationException(eventStructureString.getValidationContext(), String.format("Notification event %s is not supported", eventStructureString.get())));
            this.validateNotificationEvent(eventStructure, eventType, notificationScope);
            return new BasicNotificationEvent(eventType);
        }
        if (eventStructure instanceof MapNode) {
            MapNode eventStructureMapNode = (MapNode)eventStructure;
            Collection properties = eventStructureMapNode.getProperties();
            String eventsTypeName = (String)properties.iterator().next();
            NotificationEvent.NotificationEventType eventType = NotificationEvent.NotificationEventType.fromValue(eventsTypeName).orElseThrow(() -> new PropertiesValidationException(eventStructureMapNode.getValidationContext(), String.format("Notification event %s is not supported", eventsTypeName)));
            ImporterUtils.checkThat((ValidationContext)eventStructureMapNode.getValidationContext(), (properties.size() == 1 ? 1 : 0) != 0, (String)"Notification events type must have only one property", (Object[])new Object[0]);
            this.validateNotificationEvent(eventStructure, eventType, notificationScope);
            Node innerEventStructure = eventStructureMapNode.getNode(eventsTypeName);
            switch (eventType) {
                case PLAN_FAILED: {
                    if (innerEventStructure instanceof StringNode) {
                        StringNode failuresNode = (StringNode)innerEventStructure;
                        int failures = this.safeParseInteger(failuresNode, innerEventStructure.getValidationContext(), n -> "Failure count must be an Integer");
                        ImporterUtils.checkThat((ValidationContext)failuresNode.getValidationContext(), (failures > 0 ? 1 : 0) != 0, (String)"Failure count must be a positive integer", (Object[])new Object[0]);
                        return new PlanFailedNotificationEvent(failures);
                    }
                    if (innerEventStructure instanceof MapNode) {
                        StringNode failuresNode = ((MapNode)innerEventStructure).getString(PlanFailedNotificationEvent.Config.FAILURES);
                        int failures = NumberUtils.toInt((String)failuresNode.get(), (int)1);
                        ImporterUtils.checkThat((ValidationContext)failuresNode.getValidationContext(), (failures > 0 ? 1 : 0) != 0, (String)"Failure count must be a positive integer", (Object[])new Object[0]);
                        return new PlanFailedNotificationEvent(failures);
                    }
                    throw new PropertiesValidationException(innerEventStructure.getValidationContext(), "Unknown configuration format of notification event");
                }
                case JOB_ERROR: {
                    if (innerEventStructure instanceof MapNode) {
                        MapNode innerEventStructureMapNode = (MapNode)innerEventStructure;
                        boolean isOnlyFirst = innerEventStructureMapNode.getOptionalString(JobErrorNotificationEvent.Config.FIRST_ONLY).map(stringNode -> Boolean.parseBoolean(stringNode.get())).orElse(true);
                        return new JobErrorNotificationEvent(isOnlyFirst);
                    }
                    throw new PropertiesValidationException(innerEventStructure.getValidationContext(), "Unknown configuration format of notification event");
                }
            }
            throw new PropertiesValidationException(eventStructure.getValidationContext(), "Notification event of type " + (Object)((Object)eventType) + " does not support additional configuration");
        }
        throw new PropertiesValidationException(eventStructure.getValidationContext(), "Unknown configuration format of notification events");
    }

    private int safeParseInteger(StringNode node, ValidationContext validationContext, Function<StringNode, String> errorMessage) {
        int result;
        try {
            result = Integer.parseInt(node.get());
        }
        catch (NumberFormatException e) {
            throw new PropertiesValidationException(validationContext, errorMessage.apply(node));
        }
        return result;
    }

    private void validateNotificationEvent(@NotNull Node eventStructure, @NotNull NotificationEvent.NotificationEventType eventType, @NotNull Notification.Scope notificationScope) {
        if (notificationScope == Notification.Scope.PLAN) {
            ImporterUtils.checkThat((ValidationContext)eventStructure.getValidationContext(), (boolean)eventType.isPlanEventType(), (String)"This event type is not available for Plans", (Object[])new Object[0]);
        } else if (notificationScope == Notification.Scope.DEPLOYMENT) {
            ImporterUtils.checkThat((ValidationContext)eventStructure.getValidationContext(), (boolean)eventType.isDeploymentEventType(), (String)"This event type is not available for Deployments", (Object[])new Object[0]);
        } else {
            throw new PropertiesValidationException(eventStructure.getValidationContext(), "Unknown configuration format of notifications events");
        }
    }

    @NotNull
    private NotificationRecipients parseNotificationRecipients(@NotNull Node recipientsStructure, @NotNull Notification.Scope notificationScope) {
        if (recipientsStructure instanceof MapNode) {
            MapNode recipientsStructureMapNode = (MapNode)recipientsStructure;
            Collection properties = recipientsStructureMapNode.getProperties();
            ImporterUtils.checkThat((ValidationContext)recipientsStructureMapNode.getValidationContext(), (properties.size() == 1 ? 1 : 0) != 0, (String)"Notification recipients type must have only one property", (Object[])new Object[0]);
            String recipientsTypeName = (String)properties.iterator().next();
            NotificationRecipients.NotificationRecipientType recipientType = NotificationRecipients.NotificationRecipientType.fromValue(recipientsTypeName).orElse(NotificationRecipients.NotificationRecipientType.PLUGIN);
            this.validateNotificationRecipient(recipientsStructure, recipientType, notificationScope);
            switch (recipientType) {
                case USERS: {
                    return new UserNotificationRecipients(this.getRecipientsList(recipientsStructureMapNode, recipientsTypeName));
                }
                case GROUPS: {
                    return new GroupNotificationRecipients(this.getRecipientsList(recipientsStructureMapNode, recipientsTypeName));
                }
                case EMAILS: {
                    return new EmailNotificationRecipients(this.getRecipientsList(recipientsStructureMapNode, recipientsTypeName));
                }
                case WEBHOOK: {
                    return this.parseWebhookNotificationRecipients(recipientsStructureMapNode);
                }
                case PLUGIN: {
                    NotificationRecipients found = this.tryToParsePluginAwareNotificationRecipients(recipientsStructureMapNode);
                    if (found == null) {
                        throw new PropertiesValidationException(recipientsStructure.getValidationContext(), "Can't find plugin which supports " + recipientsTypeName);
                    }
                    return found;
                }
            }
            throw new PropertiesValidationException(recipientsStructure.getValidationContext(), "Notification recipient of type " + (Object)((Object)recipientType) + " does not support additional configuration");
        }
        if (recipientsStructure instanceof StringNode) {
            StringNode recipientsStructureString = (StringNode)recipientsStructure;
            String recipientsTypeName = recipientsStructureString.get();
            NotificationRecipients.NotificationRecipientType recipientType = NotificationRecipients.NotificationRecipientType.fromValue(recipientsTypeName).orElseThrow(() -> new PropertiesValidationException(recipientsStructureString.getValidationContext(), String.format("Notification recipients type %s is not supported", recipientsTypeName)));
            this.validateNotificationRecipient(recipientsStructure, recipientType, notificationScope);
            switch (recipientType) {
                case RESPONSIBLE: 
                case COMMITTERS: 
                case WATCHERS: {
                    return new BasicNotificationsRecipients(recipientType);
                }
            }
            throw new PropertiesValidationException(recipientsStructure.getValidationContext(), "Notification recipient of type " + (Object)((Object)recipientType) + " requires additional configuration");
        }
        throw new PropertiesValidationException(recipientsStructure.getValidationContext(), "Unknown configuration format of notification recipients");
    }

    @Nullable
    private NotificationRecipients tryToParsePluginAwareNotificationRecipients(final @NotNull MapNode node) {
        Collection moduleDescriptors = this.pluginAccessor.getModuleDescriptors(new ModuleDescriptorOfClassPredicate(NotificationRecipientModuleDescriptor.class).and((Predicate)new EnabledModulePredicate()));
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            NotificationRecipient recipient;
            final NotificationRecipientExporter exporter = ((NotificationRecipientModuleDescriptor)moduleDescriptor).getExporter();
            if (exporter == null || (recipient = (NotificationRecipient)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Callable<NotificationRecipient<?, ?>>("Error"){

                @Nullable
                public NotificationRecipient<?, ?> call() {
                    return exporter.fromYaml((Node)node);
                }
            })) == null) continue;
            log.debug((Object)("Found plugin aware recipient for " + node));
            return new PluginAwareRecipients(recipient);
        }
        return null;
    }

    private void validateNotificationRecipient(@NotNull Node recipientStructure, @NotNull NotificationRecipients.NotificationRecipientType recipientType, @NotNull Notification.Scope notificationScope) {
        if (notificationScope == Notification.Scope.PLAN) {
            ImporterUtils.checkThat((ValidationContext)recipientStructure.getValidationContext(), (boolean)recipientType.isPlanRecipientType(), (String)"This recipient type is not available for Plans", (Object[])new Object[0]);
        } else if (notificationScope == Notification.Scope.DEPLOYMENT) {
            ImporterUtils.checkThat((ValidationContext)recipientStructure.getValidationContext(), (boolean)recipientType.isDeploymentRecipientType(), (String)"This recipient type is not available for Deployments", (Object[])new Object[0]);
        } else {
            throw new PropertiesValidationException(recipientStructure.getValidationContext(), "Unknown configuration format of notifications recipients");
        }
    }

    private List<String> getRecipientsList(@NotNull MapNode recipientsStructure, @NotNull String recipientsTypeName) {
        return recipientsStructure.getList(recipientsTypeName, StringNode.class).stream().map(StringNode::get).collect(Collectors.toList());
    }

    private WebhookNotificationRecipients parseWebhookNotificationRecipients(@NotNull MapNode recipientsStructure) {
        MapNode webhookNode = recipientsStructure.getMap(NotificationRecipients.NotificationRecipientType.WEBHOOK.getValue());
        String name = webhookNode.getString(WebhookNotificationRecipients.Config.NAME).get();
        String url = webhookNode.getString(WebhookNotificationRecipients.Config.URL).get();
        return new WebhookNotificationRecipients(name, url);
    }
}

