/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.util;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.util.BambooObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class PropertiesValidator {
    public static void validate(EntityProperties properties) throws PropertiesValidationException {
        if (properties == null) {
            return;
        }
        properties.validate();
        Class<?> clazz = properties.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                if (EntityProperties.class.isAssignableFrom(field.getType())) {
                    PropertiesValidator.validate((EntityProperties)field.get(properties));
                    continue;
                }
                if (!Iterable.class.isAssignableFrom(field.getType())) continue;
                PropertiesValidator.validate((Iterable)field.get(properties));
            }
            catch (IllegalAccessException e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
        }
    }

    public static void validate(Iterable collection) {
        if (collection == null) {
            return;
        }
        for (Object o : collection) {
            if (o instanceof EntityProperties) {
                PropertiesValidator.validate((EntityProperties)o);
                continue;
            }
            if (!(o instanceof Iterable)) continue;
            PropertiesValidator.validate((Iterable)o);
        }
    }
}

