/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.util;

import com.atlassian.bamboo.configuration.external.yaml.BambooYamlSpecsService;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.yaml.MapNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class BambooYamlTestUtils {
    @NotNull
    public static MapNode readYamlFile(String fileName, Class<?> clazz, BambooYamlSpecsService bambooYamlSpecsService) throws IOException {
        String yaml = BambooYamlTestUtils.readFileFromResource(clazz, clazz.getSimpleName() + File.separator + fileName);
        Map<String, Object> yamlStructure = bambooYamlSpecsService.splitDocuments(yaml, null).iterator().next();
        return new MapNode(yamlStructure, ValidationContext.empty());
    }

    private static String readFileFromResource(Class<?> clazz, String fileName) throws IOException {
        try (InputStream is = BambooYamlTestUtils.getInputStream(fileName, clazz);){
            if (is == null) {
                Assert.fail((String)("Unable to open file " + fileName));
            }
            String string = IOUtils.toString((InputStream)new BOMInputStream(is));
            return string;
        }
    }

    private static InputStream getInputStream(String resourceName, Class<?> clazz) {
        URL url = BambooYamlTestUtils.getResourceUrl(clazz, resourceName);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static URL getResourceUrl(Class<?> ref, String resourceName) {
        ClassLoader classLoader = ref.getClassLoader();
        return Stream.of(ref.getResource(resourceName), ref.getResource(ref.getSimpleName() + "/" + resourceName), classLoader != null ? classLoader.getResource(resourceName) : null, classLoader != null ? classLoader.getResource(ref.getSimpleName() + "/" + resourceName) : null).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

