/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss.importers;

import com.atlassian.bamboo.configuration.external.PlanPermissionService;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.configuration.external.rss.EntityImporter;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.specs.api.model.permission.PlanPermissionsProperties;
import com.google.common.base.Throwables;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PlanPermissionImporter
implements EntityImporter {
    private static final Logger log = Logger.getLogger(PlanPermissionImporter.class);
    private final PlanPermissionService planPermissionService;

    @Inject
    public PlanPermissionImporter(PlanPermissionService planPermissionService) {
        this.planPermissionService = planPermissionService;
    }

    @Override
    public void importEntity(@NotNull String yamlString, @NotNull SpecsConsumer specsConsumer, @NotNull RssPermissions rssPermissions, boolean noChangesInProperties) {
        PlanPermissionsProperties planPermissions;
        if (noChangesInProperties) {
            log.debug((Object)"No changes in plan permission properties. Skipping");
            return;
        }
        try {
            planPermissions = this.planPermissionService.convertYamlToPlanPermission(yamlString);
        }
        catch (YamlValidationException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
        specsConsumer.importPlanPermissions(rssPermissions, planPermissions);
    }
}

