/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss.importers;

import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.configuration.external.PlanConfigImportService;
import com.atlassian.bamboo.configuration.external.RssExecutionOutputHandler;
import com.atlassian.bamboo.configuration.external.SpecsType;
import com.atlassian.bamboo.configuration.external.rss.EntityImporter;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.rsbs.RepositoryStoredSpecsData;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.utils.process.OutputHandler;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class PlanImporterProvider {
    private final PlanConfigImportService planConfigImportService;

    @Inject
    public PlanImporterProvider(PlanConfigImportService planConfigImportService) {
        this.planConfigImportService = planConfigImportService;
    }

    public EntityImporter getEntityProvider(@NotNull VcsRepositoryData vcsRepositoryData, @NotNull List<CommitContext> commits, @NotNull RssExecutionOutputHandler outputHandler, @NotNull SpecsType specsType, @NotNull Optional<VcsBambooSpecsSource> specsSource) {
        return (yaml, specsConsumer, rssPermissions, noChangesInProperties) -> specsConsumer.importPlanProperties(() -> {
            PlanProperties planProperties = this.planConfigImportService.convertYamlToPlan(yaml);
            if (specsType == SpecsType.YAML && specsSource.isPresent()) {
                planProperties = this.appendRepositoryStoredSpecsData(planProperties, (VcsBambooSpecsSource)specsSource.get());
            }
            return planProperties;
        }, rssPermissions, vcsRepositoryData, commits, (OutputHandler)outputHandler, specsType, noChangesInProperties);
    }

    @NotNull
    private PlanProperties appendRepositoryStoredSpecsData(@NotNull PlanProperties planProperties, @NotNull VcsBambooSpecsSource specsSource) {
        return new PlanProperties(planProperties.getOid(), planProperties.getKey(), planProperties.getName(), planProperties.getDescription(), planProperties.getProject(), planProperties.getStages(), planProperties.getRepositories(), planProperties.getTriggers(), planProperties.getVariables(), planProperties.isEnabled(), (Collection)planProperties.getPluginConfigurations(), planProperties.getPlanBranchManagementProperties(), planProperties.getDependenciesProperties(), new RepositoryStoredSpecsData(specsSource.getId() == null ? 0L : specsSource.getId()), planProperties.getNotifications(), planProperties.getForceStopHungBuilds(), planProperties.getRepositoryBranches(), planProperties.getLabels(), planProperties.getPlanBranchConfiguration());
    }
}

