/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss.importers;

import com.atlassian.bamboo.configuration.external.DeploymentImportService;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.configuration.external.rss.EntityImporter;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.specs.api.model.permission.EnvironmentPermissionsProperties;
import com.google.common.base.Throwables;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class EnvironmentPermissionsImporter
implements EntityImporter {
    private static final Logger log = Logger.getLogger(EnvironmentPermissionsImporter.class);
    private final DeploymentImportService deploymentImportService;

    @Inject
    public EnvironmentPermissionsImporter(DeploymentImportService deploymentImportService) {
        this.deploymentImportService = deploymentImportService;
    }

    @Override
    public void importEntity(String yaml, SpecsConsumer specsConsumer, RssPermissions rssPermissions, boolean noChangesInProperties) {
        EnvironmentPermissionsProperties environmentPermissions;
        if (noChangesInProperties) {
            log.debug((Object)"No changes in environments permissions properties. Skipping");
            return;
        }
        try {
            environmentPermissions = this.deploymentImportService.convertYamlToEnvironmentPermissions(yaml);
        }
        catch (YamlValidationException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
        specsConsumer.importEnvironmentPermissions(environmentPermissions, rssPermissions);
    }
}

