/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss.importers;

import com.atlassian.bamboo.configuration.external.DeploymentImportService;
import com.atlassian.bamboo.configuration.external.rss.EntityImporter;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.specs.api.model.deployment.DeploymentProperties;
import com.atlassian.bamboo.specs.api.rsbs.RepositoryStoredSpecsData;
import com.google.common.base.Throwables;
import java.util.Optional;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class DeploymentProjectImporterProvider {
    private final DeploymentImportService deploymentImportService;

    @Inject
    public DeploymentProjectImporterProvider(DeploymentImportService deploymentImportService) {
        this.deploymentImportService = deploymentImportService;
    }

    public EntityImporter getEntityImporter(Optional<VcsBambooSpecsSource> specsSource) {
        return (yaml, specsConsumer, rssPermissions, noChangesInProperties) -> {
            DeploymentProperties deploymentProperties;
            try {
                deploymentProperties = this.deploymentImportService.convertYamlToDeployment(yaml, rssPermissions);
                if (specsSource.isPresent()) {
                    deploymentProperties = this.appendRepositoryStoredSpecsData(deploymentProperties, (VcsBambooSpecsSource)specsSource.get());
                }
            }
            catch (YamlValidationException ex) {
                throw Throwables.propagate((Throwable)ex);
            }
            specsConsumer.importDeploymentProperties(deploymentProperties, rssPermissions, noChangesInProperties);
        };
    }

    @NotNull
    private DeploymentProperties appendRepositoryStoredSpecsData(@NotNull DeploymentProperties deploymentProperties, @NotNull VcsBambooSpecsSource specsSource) {
        return new DeploymentProperties(deploymentProperties.getOid(), deploymentProperties.getPlan(), deploymentProperties.getName(), deploymentProperties.getDescription(), deploymentProperties.getReleaseNaming(), deploymentProperties.getEnvironments(), new RepositoryStoredSpecsData(specsSource.getId() == null ? 0L : specsSource.getId()));
    }
}

