/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss.importers;

import com.atlassian.bamboo.configuration.external.DeploymentImportService;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.configuration.external.rss.EntityImporter;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.specs.api.model.permission.DeploymentPermissionsProperties;
import com.google.common.base.Throwables;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class DeploymentPermissionsImporter
implements EntityImporter {
    private static final Logger log = Logger.getLogger(DeploymentPermissionsImporter.class);
    private final DeploymentImportService deploymentImportService;

    @Inject
    public DeploymentPermissionsImporter(DeploymentImportService deploymentImportService) {
        this.deploymentImportService = deploymentImportService;
    }

    @Override
    public void importEntity(String yaml, SpecsConsumer specsConsumer, RssPermissions rssPermissions, boolean noChangesInProperties) {
        DeploymentPermissionsProperties deploymentPermissions;
        if (noChangesInProperties) {
            log.debug((Object)"No changes in deployment permission properties. Skipping");
            return;
        }
        try {
            deploymentPermissions = this.deploymentImportService.convertYamlToDeploymentPermissions(yaml);
        }
        catch (YamlValidationException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
        specsConsumer.importDeploymentPermissions(deploymentPermissions, rssPermissions);
    }
}

