/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss.importers;

import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.configuration.external.rss.EntityImporter;
import com.atlassian.bamboo.configuration.external.yaml.BambooYamlToSpecsConverter;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.model.permission.DeploymentPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.google.gson.Gson;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class CombinedDeploymentPermissionsImporter
implements EntityImporter {
    private static final Logger log = Logger.getLogger(CombinedDeploymentPermissionsImporter.class);

    @Override
    public void importEntity(String yaml, SpecsConsumer specsConsumer, RssPermissions rssPermissions, boolean noChangesInProperties) {
        BambooYamlToSpecsConverter.CombinedDeploymentPermissions combinedDeploymentPermissions = (BambooYamlToSpecsConverter.CombinedDeploymentPermissions)new Gson().fromJson(yaml, BambooYamlToSpecsConverter.CombinedDeploymentPermissions.class);
        DeploymentPermissionsProperties deploymentPermissionsProperties = (DeploymentPermissionsProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)combinedDeploymentPermissions.getDeploymentPermissions());
        if (noChangesInProperties) {
            log.debug((Object)"No changes in deployment permissions properties. Skipping deployment permissions update.");
        } else {
            specsConsumer.importDeploymentPermissions(deploymentPermissionsProperties, rssPermissions);
        }
        PermissionsProperties defaultEnvironmentPermissions = (PermissionsProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)combinedDeploymentPermissions.getDefaultEnvironmentPermissions());
        List environmentPermissions = combinedDeploymentPermissions.getEnvironmentPermissions().stream().map(EntityPropertiesBuilders::build).collect(Collectors.toList());
        specsConsumer.importEnvironmentPermissions(deploymentPermissionsProperties.getDeploymentName(), deploymentPermissionsProperties.getDeploymentOid(), environmentPermissions, defaultEnvironmentPermissions, rssPermissions);
    }
}

