/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss;

import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.external.RssExecutionOutputHandler;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.configuration.external.SpecsType;
import com.atlassian.bamboo.configuration.external.helpers.YamlHelper;
import com.atlassian.bamboo.configuration.external.rss.AllTypesSpecsImporter;
import com.atlassian.bamboo.configuration.external.rss.EntityImporter;
import com.atlassian.bamboo.configuration.external.rss.SpecsOptimizeProcessor;
import com.atlassian.bamboo.configuration.external.rss.YamlSpecsImportService;
import com.atlassian.bamboo.configuration.external.rss.importers.CombinedDeploymentPermissionsImporter;
import com.atlassian.bamboo.configuration.external.rss.importers.DeploymentProjectImporterProvider;
import com.atlassian.bamboo.configuration.external.rss.importers.PlanImporterProvider;
import com.atlassian.bamboo.configuration.external.rss.importers.PlanPermissionImporter;
import com.atlassian.bamboo.configuration.external.util.RssExecutionLogUtils;
import com.atlassian.bamboo.configuration.external.yaml.BambooYamlEntityType;
import com.atlassian.bamboo.configuration.external.yaml.BambooYamlParser;
import com.atlassian.bamboo.configuration.external.yaml.BambooYamlSpecsService;
import com.atlassian.bamboo.configuration.external.yaml.BambooYamlToSpecsConverter;
import com.atlassian.bamboo.configuration.external.yaml.BambooYamlValidator;
import com.atlassian.bamboo.configuration.external.yaml.BambooYamlVersion;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlDeploymentDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlDeploymentPermissionsDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlPlanDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlPlanPermissionsDefinition;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.deployment.Deployment;
import com.atlassian.bamboo.specs.api.builders.permission.PlanPermissions;
import com.atlassian.bamboo.specs.api.builders.plan.Plan;
import com.atlassian.bamboo.specs.util.BambooSpecSerializer;
import com.atlassian.bamboo.specs.util.YamlFile;
import com.atlassian.bamboo.specs.yaml.BambooYamlParserUtils;
import com.atlassian.bamboo.specs.yaml.YamlSpecsValidationException;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.utils.process.OutputHandler;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class YamlSpecsImportServiceImpl
implements YamlSpecsImportService {
    static final String COMBINED_DEPLOYMENT_PERMISSIONS = "combined-deployment-permissions";
    private static final Logger log = Logger.getLogger(YamlSpecsImportServiceImpl.class);
    @Inject
    private AllTypesSpecsImporter allTypesSpecsImporter;
    @Inject
    private BambooYamlParser bambooYamlParser;
    @Inject
    private BambooYamlSpecsService bambooYamlSpecsService;
    @Inject
    private BambooYamlToSpecsConverter bambooYamlToSpecsConverter;
    @Inject
    private BambooYamlValidator bambooYamlValidator;
    @Inject
    private DeploymentProjectImporterProvider deploymentProjectImporterProvider;
    @Inject
    private PlanImporterProvider planImporterProvider;
    @Inject
    private PlanPermissionImporter planPermissionImporter;
    @Inject
    private CombinedDeploymentPermissionsImporter combinedDeploymentPermissionsImporter;
    @Inject
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;

    private static Path dumpToYmlFile(RootEntityPropertiesBuilder<?> builder, Path exportSubDir, AtomicLong fileCounter, String type) {
        String yamlContent = BambooSpecSerializer.dump(builder);
        String fileName = YamlFile.generateFileName(builder, (String)yamlContent, (AtomicLong)fileCounter);
        return YamlHelper.dumpToFile(BambooSpecSerializer.dump(builder), exportSubDir.resolve(type.replaceAll("\\W", "-")).toFile(), fileName);
    }

    private static Path dumpToYmlFile(BambooYamlToSpecsConverter.CombinedDeploymentPermissions yaml, Path exportSubDir, AtomicLong fileCounter) {
        String yamlContent = new Gson().toJson((Object)yaml);
        String humanReadeableId = String.format("Deployment permissions for %s", yaml.getDeploymentPermissions().humanReadableId());
        String fileName = YamlFile.generateFileName((String)humanReadeableId, (String)yamlContent, (AtomicLong)fileCounter);
        return YamlHelper.dumpToFile(yamlContent, exportSubDir.resolve(COMBINED_DEPLOYMENT_PERMISSIONS).toFile(), fileName);
    }

    @Override
    public boolean processSimplifiedYaml(@NotNull SpecsConsumer specsConsumer, @NotNull VcsRepositoryData repository, @NotNull VcsBambooSpecsSource specsSource, @NotNull Path yamlFile, @NotNull Path workingDir, @NotNull RssPermissions rssPermissions, @NotNull List<CommitContext> commits, @NotNull RssExecutionOutputHandler stdout, @NotNull String logFilename) throws IOException {
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            String bambooYaml = FileUtils.readFileToString((File)yamlFile.toFile(), (Charset)StandardCharsets.UTF_8);
            List<Map<String, Object>> bambooYamlDocs = this.bambooYamlSpecsService.splitDocuments(bambooYaml, yamlFile.getParent());
            YamlBuilderReferences yamlBuilderReferences = this.parseYaml(bambooYamlDocs, repository, stdout);
            SpecsOptimizeProcessor.processSpecs(workingDir, internalYamlsDir -> this.generateInternalYamls((Path)internalYamlsDir, yamlBuilderReferences), (internalYamlsDir, yamlsWithUnchangedContent) -> {
                Supplier<Map<String, EntityImporter>> importers = () -> this.getAllImporters(specsSource, repository, commits, stdout);
                this.allTypesSpecsImporter.importBambooYamlsOfAllTypes(stopwatch, specsConsumer, repository, (Path)internalYamlsDir, commits, specsSource, rssPermissions, stdout, (Set<Path>)yamlsWithUnchangedContent, importers, logFilename);
            });
            RssExecutionLogUtils.appendMessageToLog((OutputHandler)stdout, "Bamboo YAML import was successful.");
            return true;
        }
        catch (YamlSpecsValidationException e) {
            log.info((Object)"Bamboo YAML import failed on incorrect YAML", (Throwable)e);
            specsConsumer.onYamlValidationError(repository, commits, specsSource, rssPermissions, (OutputHandler)stdout, (Exception)((Object)e), logFilename);
            throw e;
        }
        catch (IOException e) {
            log.info((Object)"Bamboo YAML import failed", (Throwable)e);
            specsConsumer.onError(repository, commits, specsSource, rssPermissions, (OutputHandler)stdout, (Throwable)e, logFilename);
            throw e;
        }
        catch (Throwable e) {
            log.info((Object)"Bamboo YAML import failed", e);
            RssExecutionLogUtils.appendMessageToLog((OutputHandler)stdout, String.format("There was an error when processing yaml file \"%s\". File structure is correct, contact Atlassian Support for assistance on resolving this issue.\n\n", yamlFile.getFileName()));
            specsConsumer.onError(repository, commits, specsSource, rssPermissions, (OutputHandler)stdout, e, logFilename);
            Throwables.propagate((Throwable)e);
            return true;
        }
    }

    private YamlBuilderReferences parseYaml(List<Map<String, Object>> bambooYamlDocs, VcsRepositoryData repository, RssExecutionOutputHandler stdout) {
        YamlBuilderReferences yamlBuilderReferences = new YamlBuilderReferences();
        block6: for (Map<String, Object> bambooYamlDoc : bambooYamlDocs) {
            BambooYamlVersion yamlVersion = this.bambooYamlSpecsService.determineVersion(bambooYamlDoc);
            BambooYamlEntityType entityType = this.bambooYamlSpecsService.determineEntityType(bambooYamlDoc);
            if (!this.isServerNameMatches(bambooYamlDoc.get(BambooYamlParserUtils.CFG_SERVER_NAME), entityType, stdout)) continue;
            switch (entityType) {
                case PLAN: {
                    BambooYamlPlanDefinition planDefinition = this.bambooYamlParser.parsePlan(bambooYamlDoc, yamlVersion, repository, stdout);
                    this.bambooYamlValidator.validatePlan(planDefinition, repository);
                    Plan plan = this.bambooYamlToSpecsConverter.createPlan(planDefinition, repository);
                    yamlBuilderReferences.addPlan(plan);
                    continue block6;
                }
                case DEPLOYMENT_PROJECT: {
                    BambooYamlDeploymentDefinition deploymentDefinition = this.bambooYamlParser.parseDeployment(bambooYamlDoc, yamlVersion, repository);
                    this.bambooYamlValidator.validateDeployment(deploymentDefinition, yamlBuilderReferences.plans);
                    Deployment deployment = this.bambooYamlToSpecsConverter.createDeploymentProject(deploymentDefinition, repository);
                    yamlBuilderReferences.addDeployment(deployment);
                    continue block6;
                }
                case DEPLOYMENT_PROJECT_PERMISSIONS: {
                    BambooYamlDeploymentPermissionsDefinition deploymentPermissionsDefinition = this.bambooYamlParser.parseDeploymentPermissions(bambooYamlDoc, yamlVersion);
                    this.bambooYamlValidator.validateDeploymentPermissions(deploymentPermissionsDefinition);
                    BambooYamlToSpecsConverter.CombinedDeploymentPermissions combinedDeploymentPermissions = this.bambooYamlToSpecsConverter.createDeploymentPermissions(deploymentPermissionsDefinition);
                    yamlBuilderReferences.addCombinedDeploymentPermissions(combinedDeploymentPermissions);
                    continue block6;
                }
                case PLAN_PERMISSIONS: {
                    BambooYamlPlanPermissionsDefinition planPermissionsDefinition = this.bambooYamlParser.parsePlanPermissions(bambooYamlDoc, yamlVersion);
                    this.bambooYamlValidator.validatePlanPermissions(planPermissionsDefinition);
                    PlanPermissions planPermissions = this.bambooYamlToSpecsConverter.createPlanPermissions(planPermissionsDefinition);
                    yamlBuilderReferences.addPlanPermissions(planPermissions);
                    continue block6;
                }
            }
            throw new YamlSpecsValidationException("Unsupported entity type: " + entityType.name());
        }
        return yamlBuilderReferences;
    }

    private boolean isServerNameMatches(Object serverNameFieldValue, BambooYamlEntityType entityType, RssExecutionOutputHandler stdout) {
        if (serverNameFieldValue != null) {
            String name = serverNameFieldValue.toString();
            try {
                Pattern serverNamePattern = Pattern.compile(name);
                String instanceName = this.administrationConfigurationAccessor.getAdministrationConfiguration().getInstanceName();
                if (!serverNamePattern.matcher(instanceName).matches()) {
                    stdout.process(String.format("skip %s as '%s=%s' doesn't match instance name '%s'", entityType.name(), BambooYamlParserUtils.CFG_SERVER_NAME, serverNamePattern, instanceName));
                    return false;
                }
            }
            catch (PatternSyntaxException e) {
                stdout.process(String.format("Can't read '%s' regexp, error %s. Skip %s processing", name, e.getMessage(), entityType.name()));
                return false;
            }
        }
        return true;
    }

    private Map<String, EntityImporter> getAllImporters(VcsBambooSpecsSource specsSource, VcsRepositoryData vcsRepositoryData, List<CommitContext> commits, RssExecutionOutputHandler stdout) {
        LinkedHashMap<String, EntityImporter> importers = new LinkedHashMap<String, EntityImporter>();
        importers.put("plan", this.planImporterProvider.getEntityProvider(vcsRepositoryData, commits, stdout, SpecsType.YAML, Optional.of(specsSource)));
        importers.put("plan permission", this.planPermissionImporter);
        importers.put("deployment", this.deploymentProjectImporterProvider.getEntityImporter(Optional.of(specsSource)));
        importers.put(COMBINED_DEPLOYMENT_PERMISSIONS, this.combinedDeploymentPermissionsImporter);
        return importers;
    }

    private void generateInternalYamls(Path internalYamlsDir, YamlBuilderReferences yamlBuilderReferences) {
        AtomicLong counter = new AtomicLong(0L);
        yamlBuilderReferences.plans.forEach(p -> YamlSpecsImportServiceImpl.dumpToYmlFile(p, internalYamlsDir, counter, "plan"));
        yamlBuilderReferences.deployments.forEach(d -> YamlSpecsImportServiceImpl.dumpToYmlFile(d, internalYamlsDir, counter, "deployment"));
        yamlBuilderReferences.planPermissionsList.forEach(pp -> YamlSpecsImportServiceImpl.dumpToYmlFile(pp, internalYamlsDir, counter, "plan permission"));
        yamlBuilderReferences.combinedDeploymentPermissionsList.forEach(cdp -> YamlSpecsImportServiceImpl.dumpToYmlFile(cdp, internalYamlsDir, counter));
    }

    private static class YamlBuilderReferences {
        private List<Plan> plans = new ArrayList<Plan>();
        private List<Deployment> deployments = new ArrayList<Deployment>();
        private List<PlanPermissions> planPermissionsList = new ArrayList<PlanPermissions>();
        private List<BambooYamlToSpecsConverter.CombinedDeploymentPermissions> combinedDeploymentPermissionsList = new ArrayList<BambooYamlToSpecsConverter.CombinedDeploymentPermissions>();

        private YamlBuilderReferences() {
        }

        public void addPlan(Plan plan) {
            this.plans.add(plan);
        }

        public void addDeployment(Deployment deployment) {
            this.deployments.add(deployment);
        }

        public void addPlanPermissions(PlanPermissions planPermissions) {
            this.planPermissionsList.add(planPermissions);
        }

        public void addCombinedDeploymentPermissions(BambooYamlToSpecsConverter.CombinedDeploymentPermissions combinedDeploymentPermissions) {
            this.combinedDeploymentPermissionsList.add(combinedDeploymentPermissions);
        }
    }
}

