/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss;

import com.atlassian.bamboo.specs.util.YamlFile;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

class SpecsProcessingOptimizer {
    private static final Logger log = Logger.getLogger(SpecsProcessingOptimizer.class);

    private SpecsProcessingOptimizer() {
    }

    static Set<Path> findYamlsWithUnchangedContent(Path internalYamlsDir, Path processedYamls) {
        if (!Files.exists(processedYamls, new LinkOption[0])) {
            return Collections.emptySet();
        }
        HashSet<Path> yamlsToSkip = new HashSet<Path>();
        try {
            Multimap<Integer, YamlFile> processedYamlsIndex = SpecsProcessingOptimizer.indexYamlFiles(processedYamls);
            Multimap<Integer, YamlFile> newYamlsIndex = SpecsProcessingOptimizer.indexYamlFiles(internalYamlsDir);
            for (YamlFile newYaml : newYamlsIndex.values()) {
                YamlFile existingYaml = SpecsProcessingOptimizer.findExistingYaml(newYaml, processedYamlsIndex);
                if (existingYaml == null) continue;
                log.debug((Object)("Found " + existingYaml.getLocation() + " that matches content of " + newYaml.getLocation() + ", will not import it"));
                yamlsToSkip.add(newYaml.getLocation().toRealPath(new LinkOption[0]));
            }
        }
        catch (Exception e) {
            log.warn((Object)"An error has occurred when processing yaml files, performing a full Specs reload", (Throwable)e);
        }
        return yamlsToSkip;
    }

    @Nullable
    private static YamlFile findExistingYaml(YamlFile newYaml, Multimap<Integer, YamlFile> processedYamlsIndex) throws IOException {
        Collection potentiallyProcessedYamls = processedYamlsIndex.get((Object)newYaml.getHashCode());
        for (YamlFile potentiallyProcessedYaml : potentiallyProcessedYamls) {
            if (!potentiallyProcessedYaml.contentCanonicallyEquals(newYaml)) continue;
            return potentiallyProcessedYaml;
        }
        return null;
    }

    private static Multimap<Integer, YamlFile> indexYamlFiles(Path processedYamls) throws IOException {
        ArrayListMultimap hashToYamlFile = ArrayListMultimap.create();
        Files.walk(processedYamls, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().toLowerCase().endsWith("yaml") || path.getFileName().toString().toLowerCase().endsWith("yml")).map(YamlFile::parse).forEach(arg_0 -> SpecsProcessingOptimizer.lambda$indexYamlFiles$2((Multimap)hashToYamlFile, arg_0));
        return hashToYamlFile;
    }

    private static /* synthetic */ void lambda$indexYamlFiles$2(Multimap hashToYamlFile, YamlFile yamlFile) {
        hashToYamlFile.put((Object)yamlFile.getHashCode(), (Object)yamlFile);
    }
}

