/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss;

import com.atlassian.bamboo.configuration.external.rss.SpecsProcessingOptimizer;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class SpecsOptimizeProcessor {
    private static final Logger log = Logger.getLogger(SpecsOptimizeProcessor.class);
    private static final String SUBDIR_PROCESSED_INTERNAL_YAMLS = "imported-internal-yamls";
    private static final String SUBDIR_INTERNAL_YAMLS = "internal-yamls";

    SpecsOptimizeProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processSpecs(@NotNull Path workingDir, @NotNull Consumer<Path> internalYamlGenerator, @NotNull BiConsumer<Path, Set<Path>> bambooYamlsOfAllTypesImporter) throws IOException {
        Path internalYamlsDir = SpecsOptimizeProcessor.ensureEmptyDirExists(workingDir.resolve(SUBDIR_INTERNAL_YAMLS));
        Path processedYamls = workingDir.resolve(SUBDIR_PROCESSED_INTERNAL_YAMLS).resolve(BuildUtils.getCurrentBuildNumber());
        try {
            Set yamlsWithUnchangedContent;
            internalYamlGenerator.accept(internalYamlsDir);
            boolean skipOptimisation = SystemProperty.SKIP_RSS_OPTIMISATION.getTypedValue();
            Set<Object> set = yamlsWithUnchangedContent = skipOptimisation ? Collections.emptySet() : SpecsProcessingOptimizer.findYamlsWithUnchangedContent(internalYamlsDir, processedYamls);
            if (log.isDebugEnabled()) {
                log.debug((Object)("The following YAMLs will be skipped: " + yamlsWithUnchangedContent));
            }
            bambooYamlsOfAllTypesImporter.accept(internalYamlsDir, yamlsWithUnchangedContent);
        }
        finally {
            SpecsOptimizeProcessor.ensureEmptyDirExists(processedYamls.getParent());
        }
        Files.move(internalYamlsDir, processedYamls, new CopyOption[0]);
    }

    @NotNull
    private static Path ensureEmptyDirExists(Path dir) throws IOException {
        if (Files.exists(dir, new LinkOption[0])) {
            BambooPathUtils.cleanDirectory((Path)dir);
        } else {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        return dir;
    }
}

