/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss;

import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.chains.ChainResultManager;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.external.DeploymentImportService;
import com.atlassian.bamboo.configuration.external.PlanConfigImportService;
import com.atlassian.bamboo.configuration.external.PlanPermissionService;
import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.configuration.external.SpecsConsumerFactory;
import com.atlassian.bamboo.configuration.external.rss.DefaultSpecsConsumer;
import com.atlassian.bamboo.configuration.external.rss.DivergentBranchDataBean;
import com.atlassian.bamboo.configuration.external.rss.DivergentBranchSpecsConsumer;
import com.atlassian.bamboo.configuration.external.rss.RepositoryStoredSpecsResultHelper;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.specs.BambooSpecsManager;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.Multimap;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class SpecsConsumerFactoryImpl
implements SpecsConsumerFactory {
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final BambooSpecsManager bambooSpecsManager;
    private final BuildNumberGeneratorService buildNumberGenerator;
    private final CachedPlanManager cachedPlanManager;
    private final ChainResultManager chainResultManager;
    private final DeploymentImportService deploymentImportService;
    private final EventPublisher eventPublisher;
    private final I18nBean i18nBean;
    private final PlanConfigImportService planConfigImportService;
    private final PlanManager planManager;
    private final PlanPermissionService planPermissionService;
    private final RepositoryStoredSpecsResultHelper repositoryStoredSpecsResultService;
    private final BuildDefinitionManager buildDefinitionManager;
    private final BuildDefinitionConverter buildDefinitionConverter;

    @Inject
    public SpecsConsumerFactoryImpl(@NotNull AdministrationConfigurationAccessor administrationConfigurationAccessor, @NotNull BambooSpecsManager bambooSpecsManager, @NotNull BuildNumberGeneratorService buildNumberGenerator, @NotNull CachedPlanManager cachedPlanManager, @NotNull ChainResultManager chainResultManager, @NotNull DeploymentImportService deploymentImportService, @NotNull EventPublisher eventPublisher, @NotNull I18nBeanFactory i18nBeanFactory, @NotNull PlanConfigImportService planConfigImportService, @NotNull PlanManager planManager, @NotNull PlanPermissionService planPermissionService, @NotNull RepositoryStoredSpecsResultHelper repositoryStoredSpecsResultService, @NotNull BuildDefinitionManager buildDefinitionManager, @NotNull BuildDefinitionConverter buildDefinitionConverter) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.bambooSpecsManager = bambooSpecsManager;
        this.buildNumberGenerator = buildNumberGenerator;
        this.cachedPlanManager = cachedPlanManager;
        this.chainResultManager = chainResultManager;
        this.deploymentImportService = deploymentImportService;
        this.eventPublisher = eventPublisher;
        this.i18nBean = i18nBeanFactory.getI18nBean();
        this.planConfigImportService = planConfigImportService;
        this.planManager = planManager;
        this.planPermissionService = planPermissionService;
        this.repositoryStoredSpecsResultService = repositoryStoredSpecsResultService;
        this.buildDefinitionManager = buildDefinitionManager;
        this.buildDefinitionConverter = buildDefinitionConverter;
    }

    public SpecsConsumer createDefaultSpecsConsumer() {
        return new DefaultSpecsConsumer(this.administrationConfigurationAccessor, this.bambooSpecsManager, this.buildNumberGenerator, this.chainResultManager, this.deploymentImportService, this.eventPublisher, this.i18nBean, this.planConfigImportService, this.planManager, this.planPermissionService, this.repositoryStoredSpecsResultService);
    }

    public SpecsConsumer createDivergentBranchSpecsUpdateConsumer(@NotNull VcsBranch vcsBranch, @NotNull Multimap<ImmutableChain, PlanKey> chainsAndBranchKeys) {
        Set<DivergentBranchDataBean> branchCreationDataSet = chainsAndBranchKeys.entries().stream().map(entry -> DivergentBranchDataBean.forUpdate((ImmutableChain)entry.getKey(), (PlanKey)entry.getValue())).collect(Collectors.toSet());
        return new DivergentBranchSpecsConsumer(this.buildNumberGenerator, this.planManager, this.cachedPlanManager, this.chainResultManager, this.eventPublisher, this.planConfigImportService, this.repositoryStoredSpecsResultService, this.buildDefinitionManager, this.buildDefinitionConverter, vcsBranch, branchCreationDataSet);
    }

    public SpecsConsumer createDivergentBranchSpecsCreationConsumer(@NotNull VcsBranch vcsBranch, @NotNull PlanBranchWorkflow planBranchWorkflow, @NotNull Multimap<ImmutableChain, PlanKey> chainsAndBranchKeys, @NotNull PlanCreationService.EnablePlan enablePlan) {
        Set<DivergentBranchDataBean> branchCreationDataSet = chainsAndBranchKeys.entries().stream().map(entry -> DivergentBranchDataBean.forCreation((ImmutableChain)entry.getKey(), (PlanKey)entry.getValue(), planBranchWorkflow, enablePlan)).collect(Collectors.toSet());
        return new DivergentBranchSpecsConsumer(this.buildNumberGenerator, this.planManager, this.cachedPlanManager, this.chainResultManager, this.eventPublisher, this.planConfigImportService, this.repositoryStoredSpecsResultService, this.buildDefinitionManager, this.buildDefinitionConverter, vcsBranch, branchCreationDataSet);
    }
}

