/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss;

import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.configuration.external.rss.RssExecutionDirectoryManager;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.BambooThrowables;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RssExecutionDirectoryManagerImpl
implements RssExecutionDirectoryManager {
    private static final Logger log = Logger.getLogger(RssExecutionDirectoryManagerImpl.class);
    private static final int MAX_DIRECTORY_NAME_LENGTH = 255;
    @VisibleForTesting
    public static final String DIRECTORY_FORMAT = "repository-%d-%s";
    @VisibleForTesting
    public static final String HASHED_BRANCH_PREFIX = "bamboo_hashed_branch__";
    @Inject
    private BuildDirectoryManager buildDirectoryManager;

    @Override
    public Path getRssExecutionDirectory(long repositoryId, @NotNull String branch) {
        Path serverSideWorkingDir = this.buildDirectoryManager.getServerSideTaskWorkingDirectory(BuildDirectoryManager.ServerSideTaskType.REPOSITORY_STORED_SPECS);
        return serverSideWorkingDir.resolve(this.getRssExecutionDirectoryName(repositoryId, branch));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void cleanExecutionCacheDirectory(long repositoryId) {
        log.info((Object)String.format("Cleaning all RSS execution cache for repository %d", repositoryId));
        Path serverSideWorkingDir = this.buildDirectoryManager.getServerSideTaskWorkingDirectory(BuildDirectoryManager.ServerSideTaskType.REPOSITORY_STORED_SPECS);
        if (!Files.exists(serverSideWorkingDir, new LinkOption[0])) return;
        Pattern pattern = Pattern.compile(String.format(DIRECTORY_FORMAT, repositoryId, "") + ".*");
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(serverSideWorkingDir, file -> pattern.matcher(file.getFileName().toString()).matches());){
            for (Path internalYamlsDir : stream) {
                try {
                    log.debug((Object)String.format("Removing RSS cache repository %s", internalYamlsDir));
                    BambooPathUtils.forceDelete((Path)internalYamlsDir);
                }
                catch (IOException e) {
                    throw BambooThrowables.propagate((Throwable)e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw BambooThrowables.propagate((Throwable)e);
        }
    }

    @Override
    public void cleanExecutionCacheDirectory(long repositoryId, @NotNull String branch) {
        log.debug((Object)String.format("Cleaning specs cache for repository %d and branch %s", repositoryId, branch));
        Path serverSideWorkingDir = this.buildDirectoryManager.getServerSideTaskWorkingDirectory(BuildDirectoryManager.ServerSideTaskType.REPOSITORY_STORED_SPECS);
        Path rssCacheDir = serverSideWorkingDir.resolve(this.getRssExecutionDirectoryName(repositoryId, branch));
        if (rssCacheDir.toFile().exists()) {
            try {
                BambooPathUtils.forceDelete((Path)rssCacheDir);
            }
            catch (IOException e) {
                log.error((Object)String.format("Failed to clean RSS execution cache for repository %d and branch %s", repositoryId, branch), (Throwable)e);
            }
        } else {
            log.debug((Object)String.format("RSS cache dir %s doesn't exists", rssCacheDir.getFileName()));
        }
    }

    @VisibleForTesting
    String getRssExecutionDirectoryName(long repositoryId, @NotNull String branch) {
        try {
            String sanitizedBranch = URLEncoder.encode(branch, StandardCharsets.UTF_8.name()).replaceAll("%", "_");
            String directoryName = String.format(DIRECTORY_FORMAT, repositoryId, sanitizedBranch);
            log.debug((Object)String.format("Sanitized directory name for repository %s and branch %s is %s", repositoryId, branch, directoryName));
            if (directoryName.length() > 255) {
                log.warn((Object)String.format("Branch's name '%s' is too long for RSS execution directory name. Using hash instead", branch));
                directoryName = String.format(DIRECTORY_FORMAT, repositoryId, HASHED_BRANCH_PREFIX + this.calculateBranchHash(branch));
            }
            return directoryName;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to sanitize branch name for RSS execution dir", e);
        }
    }

    private String calculateBranchHash(@NotNull String branch) {
        try {
            return DigestUtils.sha1Hex((InputStream)IOUtils.toInputStream((String)branch, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to calculate hash for branch " + branch, e);
        }
    }
}

