/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.chains.ChainResultManager;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.rss.RepositoryStoredSpecsResultHelper;
import com.atlassian.bamboo.configuration.external.util.RssExecutionLogUtils;
import com.atlassian.bamboo.event.rss.RssErrorEvent;
import com.atlassian.bamboo.notification.rss.RssAffectedPlan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.i18n.DocumentationLinkProvider;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildChangesImpl;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.utils.process.OutputHandler;
import com.google.common.base.Throwables;
import io.atlassian.fugue.Either;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RepositoryStoredSpecsResultHelperImpl
implements RepositoryStoredSpecsResultHelper {
    private static final Logger log = Logger.getLogger(RepositoryStoredSpecsResultHelperImpl.class);
    @Inject
    private BuildLoggerManager buildLoggerManager;
    @Inject
    private BuildNumberGeneratorService buildNumberGenerator;
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private ChainResultManager chainResultManager;
    @Inject
    private DocumentationLinkProvider documentationLinkProvider;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private PlanManager planManager;

    @Override
    public List<RssAffectedPlan> createSpecResultAndDisablePlans(@NotNull Collection<PlanKey> plans, @NotNull VcsRepositoryData repositoryData, @NotNull List<CommitContext> commits, @NotNull RssPermissions rssPermissions, boolean specsExecutionSuccessful, @NotNull VcsLocationBambooSpecsState bambooSpecsState) {
        BuildChanges buildChanges = this.getBuildChanges(repositoryData, commits);
        List results = plans.stream().map(planKey -> (ImmutableChain)this.cachedPlanManager.getPlanByKey(planKey, ImmutableChain.class)).filter(Objects::nonNull).map(plan -> this.createSpecResultAndDisablePlan(repositoryData, buildChanges, (ImmutableChain)plan, rssPermissions, specsExecutionSuccessful, bambooSpecsState)).collect(Collectors.toList());
        results.stream().filter(Either::isLeft).findAny().map(either -> (RuntimeException)either.left().get()).ifPresent(Throwables::propagate);
        return results.stream().map(either -> (RssAffectedPlan)either.right().get()).collect(Collectors.toList());
    }

    @Override
    public void publishRssErrorEvent(@NotNull VcsRepositoryData vcsRepositoryData, @NotNull List<CommitContext> commits, @NotNull VcsBambooSpecsSource specsSource, @NotNull RssPermissions rssPermissions, @NotNull Throwable throwable, @NotNull Map<String, RssAffectedPlan> affectedPlans, @NotNull Collection<PlanKey> notUpdatedPlans, @NotNull Collection<Long> notUpdatedDeploymentProjects, @NotNull String logFilename) {
        HashSet<PlanKey> affectedPlanKeys = new HashSet<PlanKey>(notUpdatedPlans);
        affectedPlans.keySet().stream().map(PlanKeys::getPlanKey).forEach(affectedPlanKeys::add);
        List<RssAffectedPlan> notUpdatedPlanResults = this.createSpecResultAndDisablePlans(affectedPlanKeys, vcsRepositoryData, commits, rssPermissions, false, specsSource.getVcsLocationBambooSpecsState());
        notUpdatedPlanResults.forEach(rssAffectedPlan -> {
            String planKey = rssAffectedPlan.getPlanKey().getKey();
            if (affectedPlans.containsKey(planKey)) {
                RssAffectedPlan existingPlan = (RssAffectedPlan)affectedPlans.get(planKey);
                existingPlan.setBuildNumber(rssAffectedPlan.getBuildNumber());
                existingPlan.setDisabled(rssAffectedPlan.isDisabled());
            } else {
                affectedPlans.put(planKey, (RssAffectedPlan)rssAffectedPlan);
            }
        });
        RssErrorEvent errorEvent = new RssErrorEvent((Object)this, vcsRepositoryData, throwable.getMessage(), commits, affectedPlans.values(), notUpdatedDeploymentProjects, specsSource.getVcsLocationBambooSpecsState().getId(), logFilename);
        this.eventPublisher.publish((Object)errorEvent);
    }

    @Override
    @NotNull
    public BuildChanges getBuildChanges(@NotNull VcsRepositoryData repositoryData, @NotNull List<CommitContext> commits) {
        VcsBranch vcsBranch = repositoryData.getBranch() == null ? null : repositoryData.getBranch().getVcsBranch();
        BuildRepositoryChangesImpl repositoryChanges = new BuildRepositoryChangesImpl(repositoryData.getRootVcsRepositoryId(), null, commits, vcsBranch);
        BuildChangesImpl buildChanges = new BuildChangesImpl();
        buildChanges.addRepositoryChanges((BuildRepositoryChanges)repositoryChanges);
        return buildChanges;
    }

    @Override
    public void appendHelpMessageToLog(@NotNull OutputHandler stdout) {
        String message = String.format("\n\nDo you need help? Please visit %s\n\n", this.documentationLinkProvider.getUrl("specs.troubleshooting"));
        RssExecutionLogUtils.appendMessageToLog(stdout, message);
    }

    @NotNull
    private Either<RuntimeException, RssAffectedPlan> createSpecResultAndDisablePlan(@NotNull VcsRepositoryData repositoryData, @NotNull BuildChanges buildChanges, @NotNull ImmutableChain plan, @NotNull RssPermissions rssPermissions, boolean specExecutionSuccessful, @NotNull VcsLocationBambooSpecsState specsState) {
        try {
            int buildNumber = this.buildNumberGenerator.generateBuildNumber((PlanIdentifier)plan);
            if (specExecutionSuccessful && rssPermissions.isProjectAllowed(plan.getProject().getKey())) {
                this.chainResultManager.createRepositorySpecSuccessResult(plan, repositoryData, buildChanges, buildNumber);
            } else {
                this.chainResultManager.createRepositorySpecFailedResult(plan, repositoryData, buildChanges, buildNumber, specsState);
            }
            ImmutableChainBranch chainBranch = (ImmutableChainBranch)Narrow.to((Object)plan, ImmutableChainBranch.class);
            if (chainBranch == null || chainBranch.isDivergent()) {
                this.disablePlan(plan.getProject().getKey(), plan.getPlanKey(), rssPermissions);
            }
            return Either.right((Object)new RssAffectedPlan((ImmutablePlan)plan, Integer.valueOf(buildNumber)));
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.buildLoggerManager.getLogger((Key)plan.getPlanKey()).addErrorLogEntry(e.getMessage(), (Throwable)e);
            return Either.left((Object)e);
        }
    }

    private void disablePlan(@NotNull String projectKey, @NotNull PlanKey planKey, @NotNull RssPermissions rssPermissions) {
        if (rssPermissions.isProjectAllowed(projectKey)) {
            this.planManager.setPlanSuspendedState(planKey, true);
        }
    }
}

