/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss;

import com.atlassian.bamboo.build.pipeline.concurrent.SystemAuthorityThreadFactory;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.RssSecurityConfiguration;
import com.atlassian.bamboo.configuration.external.MavenSanitizer;
import com.atlassian.bamboo.configuration.external.PomProcessingException;
import com.atlassian.bamboo.configuration.external.RssExecutionOutputHandler;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.configuration.external.SpecsNotFoundException;
import com.atlassian.bamboo.configuration.external.rss.RepositoryStoredSpecsExecutionService;
import com.atlassian.bamboo.configuration.external.util.RssExecutionLogUtils;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.process.ExternalProcessViaBatchBuilder;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.specs.util.BambooSpecVersion;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.ProcessException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ExecCreation;
import com.spotify.docker.client.messages.ExecState;
import com.spotify.docker.client.messages.HostConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NotNull;

public class RepositoryStoredSpecsExecutionServiceImpl
implements RepositoryStoredSpecsExecutionService {
    private static final Logger log = Logger.getLogger(RepositoryStoredSpecsExecutionServiceImpl.class);
    private static final Path SPECS_DIR_IN_DOCKER = Paths.get("/mnt/input", new String[0]);
    private static final Path YAML_OUTPUT_DIR_IN_DOCKER = Paths.get("/mnt/output", new String[0]);
    private static final Duration RSS_TIMEOUT = Duration.ofSeconds(SystemProperty.REPOSITORY_STORED_SPECS_TIMEOUT_SECONDS.getTypedValue());
    @VisibleForTesting
    static final String ORIGINAL_POM = "pom.xml";
    private ExecutorService executor = Executors.newFixedThreadPool((int)SystemProperty.REPOSITORY_STORED_SPECS_THREADS.getTypedValue(), (ThreadFactory)new SystemAuthorityThreadFactory("repository-stored-specs"));
    @Inject
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Inject
    private MavenSanitizer mavenSanitizer;
    @Inject
    private ServletContext servletContext;
    @Inject
    private CachedRepositoryDefinitionManager repositoryDefinitionManager;

    @Override
    public void generateBambooYamlsFromSpecs(@NotNull SpecsConsumer specsConsumer, @NotNull VcsRepositoryData repository, @NotNull VcsBambooSpecsSource specsSource, @NotNull Path specsDir, @NotNull Path outputDir, @NotNull RssSecurityConfiguration rssSecurityConfiguration, @NotNull RssPermissions rssPermissions, @NotNull List<CommitContext> commits, @NotNull RssExecutionOutputHandler stdout, @NotNull String logFilename) throws SpecsNotFoundException {
        Path specsInputPom;
        try {
            specsInputPom = this.resolveSpecsPom(specsDir, stdout);
        }
        catch (PomProcessingException e) {
            specsConsumer.onError(repository, commits, specsSource, rssPermissions, (OutputHandler)stdout, (Throwable)e, logFilename);
            throw new RuntimeException(e);
        }
        Callable<Optional<Exception>> runSpecs = rssSecurityConfiguration.isExecuteSpecsInDocker() ? this.runSpecsWithDocker(repository, specsSource, rssSecurityConfiguration, specsDir, specsInputPom, outputDir, stdout) : this.runSpecsWithMaven(repository, specsSource, specsDir, specsInputPom, outputDir, stdout);
        Future<Optional<Exception>> specExecutionResult = this.executor.submit(runSpecs);
        try {
            Optional<Exception> result = specExecutionResult.get();
            if (result.isPresent()) {
                Exception exception = result.get();
                specsConsumer.onError(repository, commits, specsSource, rssPermissions, (OutputHandler)stdout, (Throwable)exception, logFilename);
                throw Throwables.propagate((Throwable)exception);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            specsConsumer.onError(repository, commits, specsSource, rssPermissions, (OutputHandler)stdout, (Throwable)e, logFilename);
            throw new RuntimeException(e);
        }
    }

    private Path resolveSpecsPom(@NotNull Path specsDir, @NotNull RssExecutionOutputHandler stdout) throws PomProcessingException, SpecsNotFoundException {
        Path originalPom = specsDir.resolve(ORIGINAL_POM);
        if (!Files.exists(originalPom, new LinkOption[0])) {
            throw new SpecsNotFoundException(String.format("Unable to locate %s file in %s", ORIGINAL_POM, specsDir));
        }
        if (SystemProperty.REPOSITORY_STORED_SPECS_POM_SANITIZATION_ENABLED.getTypedValue()) {
            return this.mavenSanitizer.sanitize(originalPom.toFile(), stdout).toPath();
        }
        return originalPom;
    }

    private Callable<Optional<Exception>> runSpecsWithMaven(VcsRepositoryData repository, VcsBambooSpecsSource specsSource, Path specsDir, Path specsPom, Path yamlOutputDir, RssExecutionOutputHandler stdout) {
        List<String> command = this.buildMavenCommand(repository, specsSource, this.getMvnPath(), specsPom, yamlOutputDir);
        log.debug((Object)("Running command " + String.join((CharSequence)" ", command)));
        ExternalProcess process = new ExternalProcessViaBatchBuilder().wrapCommandInQuotesOnWindows().command(command, specsDir.toFile()).idleTimeout(RSS_TIMEOUT.toMillis()).handlers((OutputHandler)stdout, (OutputHandler)stdout).build();
        return () -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            process.execute();
            log.info((Object)("Bamboo Specs execution took " + stopwatch));
            if (process.getHandler().getExitCode() != 0) {
                RepositoryStoredSpecsExecutionServiceImpl.logIfNotEmpty(Level.WARN, stdout);
                log.info((Object)("exit code: " + process.getHandler().getExitCode()));
                log.info((Object)"process exception:", (Throwable)process.getHandler().getException());
                return Optional.of(new RepositoryException("Unable to scan repository " + repository.getName() + " (" + repository.getRootVcsRepositoryId() + ") for Bamboo Specs", (Throwable)process.getHandler().getException(), null, null, repository.getRootVcsRepositoryId()));
            }
            return Optional.empty();
        };
    }

    private Callable<Optional<Exception>> runSpecsWithDocker(VcsRepositoryData repository, VcsBambooSpecsSource specsSource, RssSecurityConfiguration rssSecurityConfiguration, Path specsInputDir, Path specsPom, Path yamlOutputDir, RssExecutionOutputHandler stdout) {
        return () -> {
            RssExecutionLogUtils.appendMessageToLog((OutputHandler)stdout, "Processing Specs within Docker container");
            try (DefaultDockerClient docker = DefaultDockerClient.fromEnv().build();){
                log.debug((Object)"Checking if Docker daemon is running");
                try {
                    docker.ping();
                }
                catch (DockerException e) {
                    String message = "Bamboo is configured to process Bamboo Specs in Docker, but it failed to connect to the Docker daemon. Make sure that Docker is running or disable processing Bamboo Specs in Docker in Bamboo Security Settings.";
                    log.error((Object)"Bamboo is configured to process Bamboo Specs in Docker, but it failed to connect to the Docker daemon. Make sure that Docker is running or disable processing Bamboo Specs in Docker in Bamboo Security Settings.", (Throwable)e);
                    Optional<Exception> optional2 = Optional.of(new Exception("Bamboo is configured to process Bamboo Specs in Docker, but it failed to connect to the Docker daemon. Make sure that Docker is running or disable processing Bamboo Specs in Docker in Bamboo Security Settings."));
                    if (docker == null) return optional2;
                    if (throwable == null) {
                        docker.close();
                        return optional2;
                    }
                    try {
                        docker.close();
                        return optional2;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return optional2;
                    }
                }
                log.debug((Object)("Pulling docker image " + rssSecurityConfiguration.getDockerImage()));
                docker.pull(rssSecurityConfiguration.getDockerImage());
                ContainerConfig.Builder containerConfigBuilder = ContainerConfig.builder().image(rssSecurityConfiguration.getDockerImage()).workingDir(SPECS_DIR_IN_DOCKER.toString()).cmd(new String[]{"sh", "-c", "while :; do sleep 1; done"});
                if (rssSecurityConfiguration.isMountLocalMavenDirectory()) {
                    HostConfig hostConfig = HostConfig.builder().binds(new String[]{rssSecurityConfiguration.getLocalMavenDirectory() + ":/root/.m2"}).build();
                    containerConfigBuilder.hostConfig(hostConfig);
                }
                ContainerConfig containerConfig = containerConfigBuilder.build();
                String containerName = "bamboo-specs-" + UUID.randomUUID().toString();
                log.debug((Object)"Creating docker container");
                ContainerCreation creation = docker.createContainer(containerConfig, containerName);
                String containerId = creation.id();
                try {
                    log.debug((Object)("Starting docker container " + containerId));
                    docker.startContainer(containerId);
                    try {
                        log.debug((Object)String.format("Copying Specs files from host [%s] to container [%s]", specsInputDir.toString(), SPECS_DIR_IN_DOCKER.toString()));
                        docker.copyToContainer(specsInputDir, containerId, SPECS_DIR_IN_DOCKER.toString());
                        CharSequence[] mavenCommand = this.buildMavenCommand(repository, specsSource, Paths.get("mvn", new String[0]), specsInputDir.relativize(specsPom), YAML_OUTPUT_DIR_IN_DOCKER).toArray(new String[0]);
                        ExecCreation execCreation = docker.execCreate(containerId, (String[])mavenCommand, new DockerClient.ExecCreateParam[]{DockerClient.ExecCreateParam.attachStdin(), DockerClient.ExecCreateParam.attachStdout(), DockerClient.ExecCreateParam.attachStderr()});
                        log.info((Object)("Starting Specs processing in container: " + String.join((CharSequence)" ", mavenCommand)));
                        this.runSpecsProcessingInDocker((DockerClient)docker, execCreation, stdout);
                        ExecState execInspect = docker.execInspect(execCreation.id());
                        if (!Objects.equals(execInspect.exitCode(), 0L)) {
                            throw new RepositoryException("Error during Specs processing in Docker container, exit code " + execInspect.exitCode(), repository.getRootVcsRepositoryId());
                        }
                        log.debug((Object)String.format("Copying YAML output files from container [%s] to host [%s]", YAML_OUTPUT_DIR_IN_DOCKER.toString(), yamlOutputDir.toString()));
                        this.copyYamlFilesFromDockerContainer((DockerClient)docker, containerId, yamlOutputDir);
                    }
                    finally {
                        log.debug((Object)("Killing docker container " + containerId));
                        docker.killContainer(containerId);
                    }
                }
                finally {
                    log.debug((Object)("Removing docker container " + containerId));
                    docker.removeContainer(containerId);
                }
                Optional optional = Optional.empty();
                return optional;
            }
            catch (RepositoryException | DockerCertificateException | DockerException | IOException | InterruptedException e) {
                return Optional.of(new RepositoryException("Unable to scan repository " + repository.getName() + " (" + repository.getRootVcsRepositoryId() + ") for Bamboo Specs", e, null, null, repository.getRootVcsRepositoryId()));
            }
        };
    }

    @NotNull
    private List<String> buildMavenCommand(VcsRepositoryData vcsRepositoryData, VcsBambooSpecsSource specsSource, Path mvnPath, Path specsPom, Path yamlOutputDir) {
        boolean useSecurityManager = SystemProperty.REPOSITORY_STORED_SPECS_SECURITY_MANAGER_ENABLED.getTypedValue();
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(mvnPath.toString(), "--batch-mode", "--errors", "--file", specsPom.toString(), "-Ppublish-specs", "-Dspecs.yamlDir=" + yamlOutputDir.toString(), "-Dspecs.useRest=false", "-Dspecs.useSecurityManager=" + useSecurityManager, "-Dspecs.rs.specsSourceId=" + specsSource.getId(), "-Dspecs.bamboo.instanceName=" + this.encodeCommandLineArgument(this.administrationConfigurationAccessor.getAdministrationConfiguration().getInstanceName()), "-Dmaven.test.skip=true", "-Dmaven.compiler.fork=false", "-Dbamboo.specs.version=" + BambooSpecVersion.getModelVersion(), "-Dbamboo.specs.log.hideDate=true"));
        VcsBranch specsSourceBranch = vcsRepositoryData.getBranch() != null ? vcsRepositoryData.getBranch().getVcsBranch() : null;
        VcsRepositoryData rootVcsRepositoryData = this.repositoryDefinitionManager.getVcsRepositoryData(vcsRepositoryData.getRootVcsRepositoryId());
        VcsBranch defaultBranch = Optional.ofNullable(rootVcsRepositoryData).map(VcsRepositoryData::getBranch).map(VcsBranchDefinition::getVcsBranch).orElse(null);
        if (defaultBranch != null) {
            boolean isDefaultBranch = specsSourceBranch == null || defaultBranch.equals(specsSourceBranch);
            String currentBranch = specsSourceBranch == null ? defaultBranch.getName() : specsSourceBranch.getName();
            args.add("-Drss.default.branch=" + isDefaultBranch);
            args.add("-Drss.current.branch=" + this.encodeCommandLineArgument(currentBranch));
        } else {
            args.add("-Drss.default.branch=true");
        }
        return args;
    }

    private String encodeCommandLineArgument(String commandLineParameter) {
        return Base64.getEncoder().encodeToString(commandLineParameter.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Path getMvnPath() {
        String m2Home = System.getProperty("M2_HOME", System.getenv("M2_HOME"));
        Path fallbackMvn = StringUtils.isNotBlank((CharSequence)m2Home) ? Paths.get(m2Home, new String[0]).resolve("bin").resolve(SystemUtils.IS_OS_WINDOWS ? "mvn.cmd" : "mvn") : Paths.get(SystemUtils.IS_OS_WINDOWS ? "mvn.cmd" : "mvn", new String[0]);
        String webAppRoot = this.servletContext.getRealPath("/");
        Path webAppRootPath = Paths.get(webAppRoot, new String[0]);
        try (Stream<Path> fileList = Files.list(webAppRootPath.resolveSibling("tools"));){
            Optional<Path> mvnExecutable = fileList.filter(path -> path.getFileName().toString().startsWith("apache-maven-")).map(path -> path.resolve("bin").resolve(SystemUtils.IS_OS_WINDOWS ? "mvn.cmd" : "mvn")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findAny();
            if (!mvnExecutable.isPresent() && !BuildUtils.isDevMode()) {
                log.warn((Object)"Can't find Maven executable bundled with Bamboo. Use system 'mvn' executable");
            }
            Path path2 = mvnExecutable.orElse(fallbackMvn);
            return path2;
        }
        catch (IOException e) {
            return fallbackMvn;
        }
    }

    private void runSpecsProcessingInDocker(DockerClient docker, ExecCreation execCreation, RssExecutionOutputHandler stdout) throws DockerException, InterruptedException {
        try (LogStream output = docker.execStart(execCreation.id(), new DockerClient.ExecStartParameter[0]);){
            try {
                stdout.process((InputStream)new ReaderInputStream((Reader)new StringReader(output.readFully()), Charset.defaultCharset()));
            }
            catch (ProcessException e) {
                log.info((Object)"Error while fetching logs from Docker container, ignoring", (Throwable)e);
            }
        }
    }

    private void copyYamlFilesFromDockerContainer(DockerClient docker, String containerId, Path yamlOutputDir) throws IOException, DockerException, InterruptedException {
        Files.createDirectories(yamlOutputDir, new FileAttribute[0]);
        TarArchiveInputStream archiveInputStream = new TarArchiveInputStream(docker.archiveContainer(containerId, YAML_OUTPUT_DIR_IN_DOCKER.toString()));
        this.storeDockerArchive((ArchiveInputStream)archiveInputStream, yamlOutputDir);
    }

    private void storeDockerArchive(ArchiveInputStream archive, Path destination) throws IOException {
        ArchiveEntry entry;
        Path sourceRoot = YAML_OUTPUT_DIR_IN_DOCKER.getFileName();
        while ((entry = archive.getNextEntry()) != null) {
            Path path = destination.resolve(sourceRoot.relativize(Paths.get(entry.getName(), new String[0])));
            if (entry.isDirectory()) {
                Files.createDirectories(path, new FileAttribute[0]);
                continue;
            }
            OutputStream fileOutputStream = BambooPathUtils.openOutputStream((Path)path);
            Throwable throwable = null;
            try {
                IOUtils.copy((InputStream)archive, (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileOutputStream == null) continue;
                if (throwable != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fileOutputStream.close();
            }
        }
    }

    private static void logIfNotEmpty(Level level, RssExecutionOutputHandler handler) {
        String output = handler.getOutput();
        if (StringUtils.isNotBlank((CharSequence)output)) {
            log.log((Priority)level, (Object)output);
        }
    }
}

