/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss;

import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.configuration.RssSecurityConfiguration;
import com.atlassian.bamboo.configuration.external.RssExecutionOutputHandler;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.configuration.external.SpecsType;
import com.atlassian.bamboo.configuration.external.rss.AllTypesSpecsImporter;
import com.atlassian.bamboo.configuration.external.rss.EntityImporter;
import com.atlassian.bamboo.configuration.external.rss.JavaSpecsImportService;
import com.atlassian.bamboo.configuration.external.rss.RepositoryStoredSpecsExecutionService;
import com.atlassian.bamboo.configuration.external.rss.SpecsOptimizeProcessor;
import com.atlassian.bamboo.configuration.external.rss.importers.DeploymentPermissionsImporter;
import com.atlassian.bamboo.configuration.external.rss.importers.DeploymentProjectImporterProvider;
import com.atlassian.bamboo.configuration.external.rss.importers.EnvironmentPermissionsImporter;
import com.atlassian.bamboo.configuration.external.rss.importers.PlanImporterProvider;
import com.atlassian.bamboo.configuration.external.rss.importers.PlanPermissionImporter;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class JavaSpecsImportServiceImpl
implements JavaSpecsImportService {
    private static final Logger log = Logger.getLogger(JavaSpecsImportServiceImpl.class);
    @Inject
    private RepositoryStoredSpecsExecutionService repositoryStoredSpecsExecutionService;
    @Inject
    private DeploymentProjectImporterProvider deploymentProjectImporterProvider;
    @Inject
    private PlanImporterProvider planImporterProvider;
    @Inject
    private PlanPermissionImporter planPermissionImporter;
    @Inject
    private DeploymentPermissionsImporter deploymentPermissionsImporter;
    @Inject
    private EnvironmentPermissionsImporter environmentPermissionsImporter;
    @Inject
    private AllTypesSpecsImporter allTypesSpecsImporter;

    @Override
    public boolean processSpecs(@NotNull SpecsConsumer specsConsumer, @NotNull VcsRepositoryData repository, @NotNull VcsBambooSpecsSource specsSource, @NotNull Path workingDir, @NotNull Path specsDir, @NotNull RssSecurityConfiguration rssSecurityConfiguration, @NotNull RssPermissions rssPermissions, @NotNull List<CommitContext> commits, @NotNull RssExecutionOutputHandler stdout, @NotNull String logFilename) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Consumer<Path> internalYamlGenerator = internalYamlsDir -> this.repositoryStoredSpecsExecutionService.generateBambooYamlsFromSpecs(specsConsumer, repository, specsSource, specsDir, (Path)internalYamlsDir, rssSecurityConfiguration, rssPermissions, commits, stdout, logFilename);
        BiConsumer<Path, Set<Path>> bambooYamlsOfAllTypesImporter = (internalYamlsDir, yamlsWithUnchangedContent) -> {
            Supplier<Map<String, EntityImporter>> importers = () -> this.getAllImporters(repository, commits, stdout);
            this.allTypesSpecsImporter.importBambooYamlsOfAllTypes(stopwatch, specsConsumer, repository, (Path)internalYamlsDir, commits, specsSource, rssPermissions, stdout, (Set<Path>)yamlsWithUnchangedContent, importers, logFilename);
        };
        SpecsOptimizeProcessor.processSpecs(workingDir, internalYamlGenerator, bambooYamlsOfAllTypesImporter);
        return true;
    }

    private Map<String, EntityImporter> getAllImporters(VcsRepositoryData repository, List<CommitContext> commits, RssExecutionOutputHandler stdout) {
        LinkedHashMap<String, EntityImporter> importers = new LinkedHashMap<String, EntityImporter>();
        importers.put("plan", this.planImporterProvider.getEntityProvider(repository, commits, stdout, SpecsType.JAVA, Optional.empty()));
        importers.put("plan permission", this.planPermissionImporter);
        importers.put("deployment", this.deploymentProjectImporterProvider.getEntityImporter(Optional.empty()));
        importers.put("deployment permission", this.deploymentPermissionsImporter);
        importers.put("environment permission", this.environmentPermissionsImporter);
        return importers;
    }
}

