/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.PartialBuildDefinition;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.chains.ChainResultManager;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.configuration.external.PlanConfigImportService;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.configuration.external.SpecsType;
import com.atlassian.bamboo.configuration.external.rss.DivergentBranchDataBean;
import com.atlassian.bamboo.configuration.external.rss.RepositoryStoredSpecsResultHelper;
import com.atlassian.bamboo.configuration.external.util.RssExecutionLogUtils;
import com.atlassian.bamboo.event.analytics.RssPlanSavedEvent;
import com.atlassian.bamboo.event.rss.RssSuccessfulEvent;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.notification.rss.RssAffectedPlan;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.deployment.DeploymentProperties;
import com.atlassian.bamboo.specs.api.model.permission.DeploymentPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.EnvironmentPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.PlanPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.utils.process.OutputHandler;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class DivergentBranchSpecsConsumer
implements SpecsConsumer {
    private static final Logger log = Logger.getLogger(DivergentBranchSpecsConsumer.class);
    private final BuildNumberGeneratorService buildNumberGenerator;
    private final PlanManager planManager;
    private final CachedPlanManager cachedPlanManager;
    private final ChainResultManager chainResultManager;
    private final EventPublisher eventPublisher;
    private final PlanConfigImportService planConfigImportService;
    private final RepositoryStoredSpecsResultHelper repositoryStoredSpecsResultService;
    private final BuildDefinitionManager buildDefinitionManager;
    private final BuildDefinitionConverter buildDefinitionConverter;
    private final VcsBranch newBranch;
    private Set<DivergentBranchDataBean> branchUpdateDataSet;
    private final List<RssAffectedPlan> affectedPlanResults = new ArrayList<RssAffectedPlan>();

    public DivergentBranchSpecsConsumer(@NotNull BuildNumberGeneratorService buildNumberGenerator, @NotNull PlanManager planManager, @NotNull CachedPlanManager cachedPlanManager, @NotNull ChainResultManager chainResultManager, @NotNull EventPublisher eventPublisher, @NotNull PlanConfigImportService planConfigImportService, @NotNull RepositoryStoredSpecsResultHelper repositoryStoredSpecsResultService, @NotNull BuildDefinitionManager buildDefinitionManager, @NotNull BuildDefinitionConverter buildDefinitionConverter, @NotNull VcsBranch newBranch, @NotNull Set<DivergentBranchDataBean> branchCreationDataSet) {
        this.buildNumberGenerator = buildNumberGenerator;
        this.planManager = planManager;
        this.cachedPlanManager = cachedPlanManager;
        this.chainResultManager = chainResultManager;
        this.eventPublisher = eventPublisher;
        this.planConfigImportService = planConfigImportService;
        this.repositoryStoredSpecsResultService = repositoryStoredSpecsResultService;
        this.buildDefinitionManager = buildDefinitionManager;
        this.buildDefinitionConverter = buildDefinitionConverter;
        this.newBranch = newBranch;
        this.branchUpdateDataSet = branchCreationDataSet;
    }

    public void importPlanProperties(@NotNull SpecsConsumer.PlanPropertiesSupplier topLevelPlanPropertiesSupplier, @NotNull RssPermissions rssPermissions, @NotNull VcsRepositoryData vcsRepositoryData, @NotNull List<CommitContext> commits, @NotNull OutputHandler stdout, @NotNull SpecsType specsType, boolean noChangesInPlanProperties) {
        try {
            PlanProperties topLevelPlanProperties = topLevelPlanPropertiesSupplier.get();
            PlanKey topLevelPlanKey = PlanKeys.getPlanKey((String)topLevelPlanProperties.getProject().getKey().getKey(), (String)topLevelPlanProperties.getKey().getKey());
            List<DivergentBranchDataBean> affectedBranches = this.branchUpdateDataSet.stream().filter(db -> db.getImmutableChain().getPlanKey().equals((Object)topLevelPlanKey)).collect(Collectors.toList());
            if (!affectedBranches.isEmpty()) {
                log.info((Object)("Updating divergent branch(es) for plan " + topLevelPlanKey.getKey() + " and branch " + this.newBranch));
                this.planConfigImportService.validatePlanBranchProperties(topLevelPlanProperties, rssPermissions, this.newBranch);
                affectedBranches.forEach(branchData -> {
                    ImmutableChainBranch chainBranch = (ImmutableChainBranch)this.cachedPlanManager.getPlanByKeyIfOfType(branchData.getPlanBranchKey(), ImmutableChainBranch.class);
                    if (chainBranch != null && chainBranch.getBuildDefinition().getBranchSpecificConfiguration().isIgnoreSpecs()) {
                        String msg = "Plan branch " + branchData.getPlanBranchKey() + " has been excluded from specs updates";
                        RssExecutionLogUtils.appendMessageToLog(stdout, msg);
                        log.info((Object)msg);
                        return;
                    }
                    log.info((Object)("Updating plan branch " + branchData.getPlanBranchKey() + " as divergent branch for plan " + topLevelPlanKey.getKey() + " and branch " + this.newBranch));
                    PlanConfigImportService.ImportResult importResult = this.planConfigImportService.updatePlanBranch(topLevelPlanProperties, this.newBranch, null, rssPermissions, (DivergentBranchDataBean)branchData, true, noChangesInPlanProperties && chainBranch.isDivergent());
                    this.branchUpdateDataSet.remove(branchData);
                    ImmutableChain plan = importResult.getPlan();
                    int buildNumber = this.buildNumberGenerator.generateBuildNumber((PlanIdentifier)plan);
                    this.chainResultManager.createRepositorySpecSuccessResult(plan, vcsRepositoryData, this.repositoryStoredSpecsResultService.getBuildChanges(vcsRepositoryData, commits), buildNumber);
                    this.affectedPlanResults.add(new RssAffectedPlan((ImmutablePlan)plan, Integer.valueOf(buildNumber), importResult.isNoChangesInProperties()));
                    this.planConfigImportService.sendEventsAndScheduleTriggersForBranchIfRequired(importResult, null);
                    PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)plan.getPlanKey(), (int)buildNumber);
                    this.eventPublisher.publish((Object)new RssPlanSavedEvent(planResultKey, specsType));
                });
            } else {
                log.debug((Object)("Plan " + topLevelPlanKey.getKey() + " is not in . Skipping branch update."));
            }
        }
        catch (YamlValidationException | RuntimeException exception) {
            log.error((Object)"Exception when importing divergent branch", exception);
            throw Throwables.propagate((Throwable)exception);
        }
    }

    public void importPlanPermissions(@NotNull RssPermissions rssPermissions, @NotNull PlanPermissionsProperties planPermissions) {
        log.debug((Object)"Skipping plan permissions import");
    }

    public void importDeploymentProperties(@NotNull DeploymentProperties deploymentProperties, @NotNull RssPermissions rssPermissions, boolean noChangesInProperties) {
        log.debug((Object)"Skipping deployment import");
    }

    public void importDeploymentPermissions(@NotNull DeploymentPermissionsProperties deploymentPermissions, @NotNull RssPermissions rssPermissions) {
        log.debug((Object)"Skipping deployment permissions import");
    }

    public void importEnvironmentPermissions(@NotNull EnvironmentPermissionsProperties environmentPermissions, @NotNull RssPermissions rssPermissions) {
        log.debug((Object)"Skipping environment permission import");
    }

    public void importEnvironmentPermissions(@NotNull String deploymentName, @NotNull BambooOidProperties deploymentOid, @NotNull List<EnvironmentPermissionsProperties> environmentsPermissions, @NotNull PermissionsProperties defaultEnvironmentPermissions, @NotNull RssPermissions rssPermissions) {
        log.debug((Object)"Skipping bulk environment permission import");
    }

    public boolean processSpecsDirectoryRemoval(@NotNull VcsRepositoryData repository, @NotNull VcsLocationBambooSpecsState specsState, @NotNull List<CommitContext> commits, @NotNull RssPermissions rssPermissions, @NotNull OutputHandler stdout, @NotNull String logFilename) {
        RssExecutionLogUtils.appendMessageToLog(stdout, "Bamboo Specs haven't been found on branch " + this.newBranch.getName() + ". Plan branches will inherit definition from master plan.");
        this.enableLightweightBranchesForRemainingChains();
        return true;
    }

    public void onSpecsRevisionNotFound() {
        log.info((Object)("Bamboo Specs haven't been found on branch " + this.newBranch.getName() + ". Plan branches will inherit definition from master plan."));
        this.enableLightweightBranchesForRemainingChains();
    }

    public void onError(@NotNull VcsRepositoryData vcsRepositoryData, @NotNull List<CommitContext> commits, @NotNull VcsBambooSpecsSource specsSource, @NotNull RssPermissions rssPermissions, @NotNull OutputHandler stdout, @NotNull Throwable throwable, @NotNull String logFilename) {
        RssExecutionLogUtils.appendErrorMessageToLog(stdout, throwable);
        this.repositoryStoredSpecsResultService.appendHelpMessageToLog(stdout);
        List<PlanKey> createdLightWeightBranches = this.collectBranchesThatWereNotUpdated();
        this.repositoryStoredSpecsResultService.publishRssErrorEvent(vcsRepositoryData, commits, specsSource, rssPermissions, throwable, new HashMap<String, RssAffectedPlan>(), createdLightWeightBranches, Collections.emptyList(), logFilename);
    }

    public void onYamlValidationError(@NotNull VcsRepositoryData vcsRepositoryData, @NotNull List<CommitContext> commits, @NotNull VcsBambooSpecsSource specsSource, @NotNull RssPermissions rssPermissions, @NotNull OutputHandler stdout, @NotNull Exception throwable, @NotNull String logFilename) {
        RssExecutionLogUtils.appendMessageToLog(stdout, "Bamboo YAML import failed: " + throwable.getMessage());
        this.repositoryStoredSpecsResultService.appendHelpMessageToLog(stdout);
        List<PlanKey> createdLightWeightBranches = this.collectBranchesThatWereNotUpdated();
        this.repositoryStoredSpecsResultService.publishRssErrorEvent(vcsRepositoryData, commits, specsSource, rssPermissions, throwable, new HashMap<String, RssAffectedPlan>(), createdLightWeightBranches, Collections.emptyList(), logFilename);
    }

    public void onSuccess(@NotNull VcsRepositoryData vcsRepositoryData, @NotNull List<CommitContext> commits, @NotNull VcsLocationBambooSpecsState specsState, @NotNull RssPermissions rssPermissions, @NotNull VcsLocationBambooSpecsState bambooSpecsState, @NotNull OutputHandler stdout, @NotNull String logFilename) {
        if (!this.branchUpdateDataSet.isEmpty()) {
            String missingChainsList = this.branchUpdateDataSet.stream().map(DivergentBranchDataBean::getImmutableChain).map(ImmutablePlan::getKey).collect(Collectors.joining(","));
            RssExecutionLogUtils.appendMessageToLog(stdout, "Plan definitions are missing from Bamboo Specs on branch " + this.newBranch.getName() + ". Branches for following plans will inherit the definition from the master plan: " + missingChainsList);
            this.enableLightweightBranchesForRemainingChains();
        }
        RssSuccessfulEvent event = new RssSuccessfulEvent((Object)this, vcsRepositoryData, commits, this.affectedPlanResults, Collections.emptyList(), specsState.getId(), logFilename);
        this.eventPublisher.publish((Object)event);
    }

    public SpecsConsumer mergeConsumers(@NotNull SpecsConsumer other) {
        HashSet<DivergentBranchDataBean> newBranchUpdateDataSet = new HashSet<DivergentBranchDataBean>();
        DivergentBranchSpecsConsumer dbsc = (DivergentBranchSpecsConsumer)Narrow.downTo((Object)other, DivergentBranchSpecsConsumer.class);
        Preconditions.checkState((dbsc != null ? 1 : 0) != 0, (Object)"Cannot merge divergent branch RSS request with regular RSS request");
        Stream.concat(this.branchUpdateDataSet.stream(), dbsc.branchUpdateDataSet.stream()).filter(db -> db.getCreationData().isPresent()).forEach(newBranchUpdateDataSet::add);
        newBranchUpdateDataSet.addAll(this.branchUpdateDataSet);
        newBranchUpdateDataSet.addAll(dbsc.branchUpdateDataSet);
        this.branchUpdateDataSet = newBranchUpdateDataSet;
        return this;
    }

    private List<PlanKey> collectBranchesThatWereNotUpdated() {
        List<PlanKey> createdBranches = this.branchUpdateDataSet.stream().map(DivergentBranchDataBean::getPlanBranchKey).collect(Collectors.toList());
        this.branchUpdateDataSet.clear();
        return createdBranches;
    }

    private List<PlanKey> enableLightweightBranchesForRemainingChains() {
        ArrayList<PlanKey> createdBranches = new ArrayList<PlanKey>();
        Iterator<DivergentBranchDataBean> iterator = this.branchUpdateDataSet.iterator();
        while (iterator.hasNext()) {
            DivergentBranchDataBean branchCreationData = iterator.next();
            iterator.remove();
            try {
                if (branchCreationData.getCreationData().isPresent()) {
                    ChainBranch plan = (ChainBranch)this.planManager.getPlanByKey(branchCreationData.getPlanBranchKey(), ChainBranch.class);
                    if (plan != null) {
                        plan.setDivergent(false);
                        BuildDefinition buildDefinition = this.buildDefinitionManager.getUnmergedBuildDefinition(plan.getPlanKey());
                        BuildDefinitionForBuild buildDefinitionForBuild = plan.getBuildDefinitionXml();
                        BuildConfiguration hierarchicalConfiguration = new BuildConfiguration((HierarchicalConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)buildDefinition));
                        hierarchicalConfiguration.setProperty("branchConfiguration.awating.specs.execution", (Object)false);
                        buildDefinitionForBuild.setXmlData(hierarchicalConfiguration.asXml());
                        plan.setBuildDefinitionXml(buildDefinitionForBuild);
                        plan.setSuspendedFromBuilding(branchCreationData.getCreationData().get().getEnablePlan() == PlanCreationService.EnablePlan.DISABLED);
                        this.planManager.savePlan((Plan)plan);
                    }
                    if (branchCreationData.getCreationData().get().getEnablePlan() == PlanCreationService.EnablePlan.ENABLED) {
                        log.debug((Object)("Enabling lightweight branch " + branchCreationData.getPlanBranchKey() + " (" + this.newBranch.getName() + ") for chain " + branchCreationData.getImmutableChain().getKey()));
                        ImmutableChain planBranch = (ImmutableChain)this.cachedPlanManager.getPlanByKey(branchCreationData.getPlanBranchKey(), ImmutableChain.class);
                        this.planConfigImportService.sendEventsAndScheduleTriggersForBranchIfRequired(new PlanConfigImportService.ImportResult(planBranch, true, true), null);
                    }
                } else {
                    PlanConfigImportService.ImportResult importResult = this.planConfigImportService.switchToLightweightBranch(branchCreationData.getPlanBranchKey());
                    this.planConfigImportService.sendEventsAndScheduleTriggersForBranchIfRequired(importResult, null);
                }
                createdBranches.add(branchCreationData.getPlanBranchKey());
            }
            catch (RuntimeException e) {
                log.error((Object)("Exception when enabling lightweight branch for plan " + branchCreationData.getImmutableChain().getKey()), (Throwable)e);
            }
        }
        return createdBranches;
    }
}

