/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss;

import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DivergentBranchDataBean {
    private final ImmutableChain immutableChain;
    private final PlanKey planBranchKey;
    private final CreationData creationData;

    public static DivergentBranchDataBean forCreation(@NotNull ImmutableChain immutableChain, @NotNull PlanKey planBranchKey, @NotNull PlanBranchWorkflow planBranchWorkflow, @NotNull PlanCreationService.EnablePlan enablePlan) {
        return new DivergentBranchDataBean(immutableChain, planBranchKey, new CreationData(planBranchWorkflow, enablePlan));
    }

    public static DivergentBranchDataBean forUpdate(@NotNull ImmutableChain immutableChain, @NotNull PlanKey planBranchKey) {
        return new DivergentBranchDataBean(immutableChain, planBranchKey, null);
    }

    private DivergentBranchDataBean(@NotNull ImmutableChain immutableChain, @NotNull PlanKey planBranchKey, @Nullable CreationData creationData) {
        this.immutableChain = immutableChain;
        this.planBranchKey = planBranchKey;
        this.creationData = creationData;
    }

    public boolean isCreation() {
        return this.creationData != null;
    }

    @NotNull
    public Optional<CreationData> getCreationData() {
        return Optional.ofNullable(this.creationData);
    }

    @NotNull
    public ImmutableChain getImmutableChain() {
        return this.immutableChain;
    }

    @NotNull
    public PlanKey getPlanBranchKey() {
        return this.planBranchKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DivergentBranchDataBean that = (DivergentBranchDataBean)o;
        return this.immutableChain.equals(that.immutableChain) && Objects.equals(this.planBranchKey, that.planBranchKey);
    }

    public int hashCode() {
        return Objects.hash(this.immutableChain, this.planBranchKey);
    }

    public static class CreationData {
        private final PlanBranchWorkflow planBranchWorkflow;
        private final PlanCreationService.EnablePlan enablePlan;

        public CreationData(@NotNull PlanBranchWorkflow planBranchWorkflow, @NotNull PlanCreationService.EnablePlan enablePlan) {
            this.planBranchWorkflow = planBranchWorkflow;
            this.enablePlan = enablePlan;
        }

        @NotNull
        public PlanBranchWorkflow getPlanBranchWorkflow() {
            return this.planBranchWorkflow;
        }

        @NotNull
        public PlanCreationService.EnablePlan getEnablePlan() {
            return this.enablePlan;
        }
    }
}

