/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss;

import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.chains.ChainResultManager;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.external.DeploymentImportService;
import com.atlassian.bamboo.configuration.external.PlanConfigImportService;
import com.atlassian.bamboo.configuration.external.PlanPermissionService;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.configuration.external.SpecsType;
import com.atlassian.bamboo.configuration.external.helpers.PlanImportHelper;
import com.atlassian.bamboo.configuration.external.rss.RepositoryStoredSpecsResultHelper;
import com.atlassian.bamboo.configuration.external.util.RssExecutionLogUtils;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.event.analytics.RssPlanSavedEvent;
import com.atlassian.bamboo.event.rss.RssSuccessfulEvent;
import com.atlassian.bamboo.exception.RssPermissionException;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.notification.rss.RssAffectedPlan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.specs.BambooSpecsManager;
import com.atlassian.bamboo.specs.api.builders.permission.PermissionType;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.deployment.DeploymentProperties;
import com.atlassian.bamboo.specs.api.model.permission.DeploymentPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.EnvironmentPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.GroupPermissionProperties;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.PlanPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.UserPermissionProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.utils.process.OutputHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class DefaultSpecsConsumer
implements SpecsConsumer {
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final BambooSpecsManager bambooSpecsManager;
    private final BuildNumberGeneratorService buildNumberGenerator;
    private final ChainResultManager chainResultManager;
    private final DeploymentImportService deploymentImportService;
    private final EventPublisher eventPublisher;
    private final I18nBean i18nBean;
    private final PlanConfigImportService planConfigImportService;
    private final PlanManager planManager;
    private final PlanPermissionService planPermissionService;
    private final RepositoryStoredSpecsResultHelper repositoryStoredSpecsResultService;
    @VisibleForTesting
    final Map<String, RssAffectedPlan> affectedPlans = new HashMap<String, RssAffectedPlan>();
    @VisibleForTesting
    final List<RssAffectedPlan> affectedPlanResults = new ArrayList<RssAffectedPlan>();
    @VisibleForTesting
    final List<Long> affectedDeploymentProjects = new ArrayList<Long>();

    public DefaultSpecsConsumer(@NotNull AdministrationConfigurationAccessor administrationConfigurationAccessor, @NotNull BambooSpecsManager bambooSpecsManager, @NotNull BuildNumberGeneratorService buildNumberGenerator, @NotNull ChainResultManager chainResultManager, @NotNull DeploymentImportService deploymentImportService, @NotNull EventPublisher eventPublisher, @NotNull I18nBean i18nBean, @NotNull PlanConfigImportService planConfigImportService, @NotNull PlanManager planManager, @NotNull PlanPermissionService planPermissionService, @NotNull RepositoryStoredSpecsResultHelper repositoryStoredSpecsResultService) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.bambooSpecsManager = bambooSpecsManager;
        this.buildNumberGenerator = buildNumberGenerator;
        this.chainResultManager = chainResultManager;
        this.deploymentImportService = deploymentImportService;
        this.eventPublisher = eventPublisher;
        this.i18nBean = i18nBean;
        this.planConfigImportService = planConfigImportService;
        this.planManager = planManager;
        this.planPermissionService = planPermissionService;
        this.repositoryStoredSpecsResultService = repositoryStoredSpecsResultService;
    }

    public void importPlanProperties(@NotNull SpecsConsumer.PlanPropertiesSupplier topLevelPlanPropertiesSupplier, @NotNull RssPermissions rssPermissions, @NotNull VcsRepositoryData vcsRepositoryData, @NotNull List<CommitContext> commits, @NotNull OutputHandler stdout, @NotNull SpecsType specsType, boolean noChangesInPlanProperties) {
        PlanProperties topLevelPlanProperties = null;
        try {
            topLevelPlanProperties = topLevelPlanPropertiesSupplier.get();
            this.planConfigImportService.validatePlanProperties(topLevelPlanProperties, rssPermissions);
            PlanConfigImportService.ImportResult importResult = this.planConfigImportService.importPlan(topLevelPlanProperties, null, rssPermissions, true, noChangesInPlanProperties);
            ImmutableChain plan = importResult.getPlan();
            int buildNumber = this.buildNumberGenerator.generateBuildNumber((PlanIdentifier)plan);
            this.chainResultManager.createRepositorySpecSuccessResult(plan, vcsRepositoryData, this.repositoryStoredSpecsResultService.getBuildChanges(vcsRepositoryData, commits), buildNumber);
            this.affectedPlanResults.add(new RssAffectedPlan((ImmutablePlan)plan, Integer.valueOf(buildNumber), importResult.isNoChangesInProperties()));
            this.planConfigImportService.sendEventsAndScheduleTriggersIfRequired(importResult);
            PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)plan.getPlanKey(), (int)buildNumber);
            this.eventPublisher.publish((Object)new RssPlanSavedEvent(planResultKey, specsType));
        }
        catch (RssPermissionException exception) {
            if (topLevelPlanProperties != null) {
                RssAffectedPlan affectedPlan = new RssAffectedPlan(topLevelPlanProperties, exception.getProjectKeys(), exception.getRepositoriesNames());
                this.affectedPlans.put(affectedPlan.getPlanKey().getKey(), affectedPlan);
            }
            throw Throwables.propagate((Throwable)exception);
        }
        catch (YamlValidationException | RuntimeException exception) {
            if (topLevelPlanProperties != null) {
                RssAffectedPlan affectedPlan = new RssAffectedPlan(topLevelPlanProperties);
                this.affectedPlans.put(affectedPlan.getPlanKey().getKey(), affectedPlan);
            }
            throw Throwables.propagate((Throwable)exception);
        }
    }

    public void importPlanPermissions(@NotNull RssPermissions rssPermissions, @NotNull PlanPermissionsProperties planPermissions) {
        this.assertSoxRestrictions(planPermissions.getPermissions());
        try {
            this.planPermissionService.importPlanPermission(planPermissions, rssPermissions);
        }
        catch (PropertiesValidationException ex) {
            PlanImportHelper.findExistingPlanByOidOrKey(planPermissions.getPlanIdentifier(), this.planManager, TopLevelPlan.class).ifPresent(existingPlan -> this.affectedPlans.put(existingPlan.getPlanKey().getKey(), new RssAffectedPlan(existingPlan.getProject().getName(), existingPlan.getPlanKey(), existingPlan.getName(), true)));
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public void importDeploymentProperties(@NotNull DeploymentProperties deploymentProperties, @NotNull RssPermissions rssPermissions, boolean noChangesInProperties) {
        DeploymentProject deploymentProject = this.deploymentImportService.importDeployment(deploymentProperties, null, rssPermissions, noChangesInProperties);
        this.affectedDeploymentProjects.add(deploymentProject.getId());
    }

    public void importDeploymentPermissions(@NotNull DeploymentPermissionsProperties deploymentPermissions, @NotNull RssPermissions rssPermissions) {
        this.assertSoxRestrictions(deploymentPermissions.getPermissions());
        this.deploymentImportService.importDeploymentPermissions(deploymentPermissions, rssPermissions);
    }

    public void importEnvironmentPermissions(@NotNull EnvironmentPermissionsProperties environmentPermissions, @NotNull RssPermissions rssPermissions) {
        this.assertSoxRestrictions(environmentPermissions.getPermissions());
        this.deploymentImportService.importDeploymentEnvironmentPermissions(environmentPermissions, rssPermissions);
    }

    public void importEnvironmentPermissions(@NotNull String deploymentName, @NotNull BambooOidProperties deploymentOid, @NotNull List<EnvironmentPermissionsProperties> environmentsPermissions, @NotNull PermissionsProperties defaultEnvironmentPermissions, @NotNull RssPermissions rssPermissions) {
        this.assertSoxRestrictions(defaultEnvironmentPermissions);
        environmentsPermissions.stream().map(EnvironmentPermissionsProperties::getPermissions).forEach(this::assertSoxRestrictions);
        this.deploymentImportService.importDeploymentPermissions(deploymentName, deploymentOid, defaultEnvironmentPermissions, environmentsPermissions, rssPermissions);
    }

    public boolean processSpecsDirectoryRemoval(@NotNull VcsRepositoryData vcsRepositoryData, @NotNull VcsLocationBambooSpecsState specsState, @NotNull List<CommitContext> commits, @NotNull RssPermissions rssPermissions, @NotNull OutputHandler stdout, @NotNull String logFilename) {
        RssExecutionLogUtils.appendMessageToLog(stdout, this.i18nBean.getText("rss.import.deleted.specs", Collections.singletonList(vcsRepositoryData.getName())));
        this.affectedDeploymentProjects.addAll(this.bambooSpecsManager.findDeploymentProjectsInOtherStates(specsState));
        this.affectedPlanResults.addAll(this.repositoryStoredSpecsResultService.createSpecResultAndDisablePlans(this.bambooSpecsManager.findPlansInOtherStates(specsState), vcsRepositoryData, commits, rssPermissions, true, specsState));
        this.publishRssSuccessfulEvent(vcsRepositoryData, commits, specsState, logFilename);
        return true;
    }

    public void onSpecsRevisionNotFound() {
    }

    public void onError(@NotNull VcsRepositoryData vcsRepositoryData, @NotNull List<CommitContext> commits, @NotNull VcsBambooSpecsSource specsSource, @NotNull RssPermissions rssPermissions, @NotNull OutputHandler stdout, @NotNull Throwable throwable, @NotNull String logFilename) {
        RssExecutionLogUtils.appendErrorMessageToLog(stdout, throwable);
        this.repositoryStoredSpecsResultService.appendHelpMessageToLog(stdout);
        this.publishRssErrorEvent(vcsRepositoryData, commits, specsSource, rssPermissions, throwable, this.affectedPlans, logFilename);
    }

    public void onYamlValidationError(@NotNull VcsRepositoryData vcsRepositoryData, @NotNull List<CommitContext> commits, @NotNull VcsBambooSpecsSource specsSource, @NotNull RssPermissions rssPermissions, @NotNull OutputHandler stdout, @NotNull Exception throwable, @NotNull String logFilename) {
        RssExecutionLogUtils.appendMessageToLog(stdout, "Bamboo YAML import failed: " + throwable.getMessage());
        this.repositoryStoredSpecsResultService.appendHelpMessageToLog(stdout);
        this.publishRssErrorEvent(vcsRepositoryData, commits, specsSource, rssPermissions, throwable, this.affectedPlans, logFilename);
    }

    public void onSuccess(@NotNull VcsRepositoryData vcsRepositoryData, @NotNull List<CommitContext> commits, @NotNull VcsLocationBambooSpecsState specsState, @NotNull RssPermissions rssPermissions, @NotNull VcsLocationBambooSpecsState bambooSpecsState, @NotNull OutputHandler stdout, @NotNull String logFilename) {
        this.repositoryStoredSpecsResultService.createSpecResultAndDisablePlans(this.bambooSpecsManager.findPlansInOtherStates(specsState), vcsRepositoryData, commits, rssPermissions, true, specsState);
        this.publishRssSuccessfulEvent(vcsRepositoryData, commits, specsState, logFilename);
    }

    public SpecsConsumer mergeConsumers(@NotNull SpecsConsumer other) {
        DefaultSpecsConsumer dsc = (DefaultSpecsConsumer)Narrow.downTo((Object)other, DefaultSpecsConsumer.class);
        Preconditions.checkState((dsc != null ? 1 : 0) != 0, (Object)"Cannot merge divergent branch RSS request with regular RSS request");
        return this;
    }

    private void publishRssSuccessfulEvent(@NotNull VcsRepositoryData vcsRepositoryData, @NotNull List<CommitContext> commits, @NotNull VcsLocationBambooSpecsState vcsLocationBambooSpecsState, @NotNull String logFilename) {
        RssSuccessfulEvent event = new RssSuccessfulEvent((Object)this, vcsRepositoryData, commits, this.affectedPlanResults, this.affectedDeploymentProjects, vcsLocationBambooSpecsState.getId(), logFilename);
        this.eventPublisher.publish((Object)event);
    }

    private void assertSoxRestrictions(@NotNull PermissionsProperties permissions) {
        if (this.administrationConfigurationAccessor.getAdministrationConfiguration().isSoxComplianceModeEnabled() && this.hasNonSoxPermission(permissions)) {
            throw new UnauthorisedException("Sox mode only allows view/build permissions to be added via rss specs");
        }
    }

    private boolean hasNonSoxPermission(@NotNull PermissionsProperties permissionsProperties) {
        HashSet<PermissionType> whitelistPermission = new HashSet<PermissionType>(Arrays.asList(PermissionType.VIEW, PermissionType.BUILD));
        HashSet requestedPermission = new HashSet();
        if (permissionsProperties.getGroupPermissions() != null) {
            permissionsProperties.getGroupPermissions().stream().map(GroupPermissionProperties::getPermissionTypes).forEach(requestedPermission::addAll);
        }
        if (permissionsProperties.getUserPermissions() != null) {
            permissionsProperties.getUserPermissions().stream().map(UserPermissionProperties::getPermissionTypes).forEach(requestedPermission::addAll);
        }
        if (permissionsProperties.getLoggedInUserPermissions() != null) {
            requestedPermission.addAll(permissionsProperties.getLoggedInUserPermissions().getPermissionTypes());
        }
        if (permissionsProperties.getAnonymousUserPermissions() != null) {
            requestedPermission.addAll(permissionsProperties.getAnonymousUserPermissions().getPermissionTypes());
        }
        return !whitelistPermission.containsAll(requestedPermission);
    }

    private void publishRssErrorEvent(@NotNull VcsRepositoryData vcsRepositoryData, @NotNull List<CommitContext> commits, @NotNull VcsBambooSpecsSource specsSource, @NotNull RssPermissions rssPermissions, @NotNull Throwable throwable, @NotNull Map<String, RssAffectedPlan> affectedPlans, @NotNull String logFilename) {
        Collection notUpdatedPlans = this.bambooSpecsManager.findPlansInOtherStates(specsSource.getVcsLocationBambooSpecsState());
        Collection notUpdatedDeploymentProjects = this.bambooSpecsManager.findDeploymentProjectsInOtherStates(specsSource.getVcsLocationBambooSpecsState());
        this.repositoryStoredSpecsResultService.publishRssErrorEvent(vcsRepositoryData, commits, specsSource, rssPermissions, throwable, affectedPlans, notUpdatedPlans, notUpdatedDeploymentProjects, logFilename);
    }
}

