/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.rss;

import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.configuration.external.RssExecutionOutputHandler;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.configuration.external.rss.EntityImporter;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.BambooThrowables;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.utils.process.OutputHandler;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class AllTypesSpecsImporter {
    private static final Logger log = Logger.getLogger(AllTypesSpecsImporter.class);

    AllTypesSpecsImporter() {
    }

    public void importBambooYamlsOfAllTypes(@NotNull Stopwatch stopwatch, @NotNull SpecsConsumer specsConsumer, @NotNull VcsRepositoryData vcsRepositoryData, @NotNull Path yamlDir, @NotNull List<CommitContext> commits, @NotNull VcsBambooSpecsSource specsSource, @NotNull RssPermissions rssPermissions, @NotNull RssExecutionOutputHandler stdout, @NotNull Set<Path> yamlsWithUnchangedContent, @NotNull Supplier<Map<String, EntityImporter>> entityProvidersSupplier, @NotNull String logFilename) {
        try {
            AtomicReference<IOException> firstException = new AtomicReference<IOException>();
            AtomicReference<RuntimeException> firstRuntimeException = new AtomicReference<RuntimeException>();
            LinkedHashMap<String, EntityImporter> importers = new LinkedHashMap<String, EntityImporter>();
            importers.putAll(entityProvidersSupplier.get());
            for (Map.Entry entry : importers.entrySet()) {
                this.importBambooYamlsWithImporter(this.yamlDirFor(yamlDir, (String)entry.getKey()), yamlsWithUnchangedContent, specsConsumer, rssPermissions, firstException, firstRuntimeException, (EntityImporter)entry.getValue());
            }
            if (firstRuntimeException.get() != null) {
                specsConsumer.onError(vcsRepositoryData, commits, specsSource, rssPermissions, (OutputHandler)stdout, (Throwable)firstRuntimeException.get(), logFilename);
                throw (RuntimeException)firstRuntimeException.get();
            }
            if (firstException.get() != null) {
                specsConsumer.onError(vcsRepositoryData, commits, specsSource, rssPermissions, (OutputHandler)stdout, (Throwable)firstException.get(), logFilename);
                throw (IOException)firstException.get();
            }
            specsConsumer.onSuccess(vcsRepositoryData, commits, specsSource.getVcsLocationBambooSpecsState(), rssPermissions, specsSource.getVcsLocationBambooSpecsState(), (OutputHandler)stdout, logFilename);
            log.info((Object)("Bamboo Specs import took " + stopwatch));
        }
        catch (IOException ex) {
            BambooThrowables.propagate((Throwable)ex);
        }
    }

    private void importBambooYamlsWithImporter(@NotNull Path yamlDir, @NotNull Set<Path> yamlsWithUnchangedContent, @NotNull SpecsConsumer specsConsumer, @NotNull RssPermissions rssPermissions, @NotNull AtomicReference<IOException> firstException, @NotNull AtomicReference<RuntimeException> firstRuntimeException, @NotNull EntityImporter yamlImporter) throws IOException {
        if (!Files.isDirectory(yamlDir, new LinkOption[0])) {
            log.debug((Object)("The " + yamlDir + " does not exist or is not a directory. Not searching for YAML files."));
            return;
        }
        try (Stream<Path> fileList = Files.list(yamlDir);){
            for (Path path : fileList.collect(Collectors.toList())) {
                try {
                    Path realPath = path.toRealPath(new LinkOption[0]);
                    log.debug((Object)("Processing " + realPath));
                    yamlImporter.importEntity(BambooPathUtils.readFileToString((Path)path, (Charset)StandardCharsets.UTF_8), specsConsumer, rssPermissions, yamlsWithUnchangedContent.contains(realPath));
                }
                catch (RuntimeException e) {
                    BambooPathUtils.deleteQuietly((Path)path);
                    log.warn((Object)"", (Throwable)e);
                    if (firstException.get() != null) continue;
                    firstRuntimeException.compareAndSet(null, e);
                }
                catch (IOException e) {
                    BambooPathUtils.deleteQuietly((Path)path);
                    log.warn((Object)"", (Throwable)e);
                    if (firstRuntimeException.get() != null) continue;
                    firstException.compareAndSet(null, e);
                }
            }
        }
    }

    private Path yamlDirFor(@NotNull Path baseYamlDir, @NotNull String entityType) {
        return baseYamlDir.resolve(entityType.replaceAll("\\W", "-"));
    }
}

