/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.polling;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.RssDetectionConfiguration;
import com.atlassian.bamboo.configuration.external.polling.RepositoryStoredSpecsPollingJob;
import com.atlassian.bamboo.configuration.external.polling.RepositoryStoredSpecsPollingScheduler;
import com.atlassian.bamboo.quartz.PreventJobExecutionUntilCompletedTriggerListener;
import com.atlassian.bamboo.schedule.BambooScheduler;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.utils.Key;

public class RepositoryStoredSpecsPollingSchedulerImpl
implements BambooScheduler,
RepositoryStoredSpecsPollingScheduler {
    private static final Logger log = Logger.getLogger(RepositoryStoredSpecsPollingSchedulerImpl.class);
    private static final String JOB_NAME = "Rss polling";
    private static final String JOB_GROUP = "Rss polling";
    private static final TriggerKey TRIGGER_KEY = new TriggerKey("Rss polling", "Rss polling");
    private static final JobKey JOB_KEY = new JobKey("Rss polling", "Rss polling");
    private final Scheduler quartzScheduler;
    private final FeatureManager featureManager;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public RepositoryStoredSpecsPollingSchedulerImpl(Scheduler quartzScheduler, FeatureManager featureManager, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.quartzScheduler = quartzScheduler;
        this.featureManager = featureManager;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public void initialiseSchedule() {
        if (!this.featureManager.isRssPollingEnabled()) {
            return;
        }
        RssDetectionConfiguration rssDetectionConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration().getRssDetectionConfiguration();
        if (!rssDetectionConfiguration.isPollingEnabled()) {
            return;
        }
        try {
            Trigger trigger = this.quartzScheduler.getTrigger(TRIGGER_KEY);
            if (trigger != null && trigger.mayFireAgain()) {
                return;
            }
            JobDetail jobDetail = JobBuilder.newJob(RepositoryStoredSpecsPollingJob.class).withIdentity(JOB_KEY).build();
            Trigger trigger2 = TriggerBuilder.newTrigger().withIdentity(TRIGGER_KEY).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)new CronExpression(rssDetectionConfiguration.getPollingCronExpression()))).build();
            this.quartzScheduler.getListenerManager().addTriggerListener(PreventJobExecutionUntilCompletedTriggerListener.INSTANCE, (Matcher)KeyMatcher.keyEquals((Key)trigger2.getKey()));
            this.quartzScheduler.scheduleJob(jobDetail, trigger2);
            log.info((Object)String.format("Rss polling running according to cron: %s", new CronExpression(rssDetectionConfiguration.getPollingCronExpression())));
        }
        catch (ParseException | SchedulerException e) {
            log.error((Object)"Unable to schedule Rss polling", e);
        }
    }

    public void destroySchedule() {
        try {
            this.quartzScheduler.deleteJob(JOB_KEY);
        }
        catch (SchedulerException e) {
            log.info((Object)"Unable to remove job Rss polling", (Throwable)e);
        }
    }

    public void rescheduleRssPolling() {
        this.destroySchedule();
        this.initialiseSchedule();
    }
}

