/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.polling;

import com.atlassian.bamboo.configuration.external.RssDetectionService;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;

public class RepositoryStoredSpecsPollingJob
implements Job {
    private static final Logger log = Logger.getLogger(RepositoryStoredSpecsPollingJob.class);
    @Inject
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Inject
    private RssDetectionService rssDetectionService;

    public void execute(JobExecutionContext jobExecutionContext) {
        this.repositoryDefinitionManager.getLinkedRepositories().stream().filter(vcs -> vcs.getBambooSpecsDetectionOptions() != null && vcs.getBambooSpecsDetectionOptions().isBambooSpecsDetectionEnabled()).filter(vcsRepositoryData -> !this.rssDetectionService.canEnqueue(vcsRepositoryData).hasAnyErrors()).forEach(vcs -> {
            log.debug((Object)("Queueing specs detections for " + vcs.getName()));
            this.rssDetectionService.enqueue(vcs.getId(), vcs.getBranch().getVcsBranch());
        });
    }
}

