/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.helpers;

import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.util.BambooSpecProperties;
import com.atlassian.bamboo.specs.util.BambooSpecSerializer;
import com.atlassian.bamboo.specs.util.Yamlizator;
import com.atlassian.bamboo.utils.concurrent.BambooLocks;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlHelper {
    private static Logger log = Logger.getLogger(YamlHelper.class);
    private static LoadingCache<Object, ReentrantLock> locks = BambooLocks.weakReentrantLockFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Path dumpToYml(Object data, File exportSubDir, String fileName) {
        Path path = new File(exportSubDir, fileName + ".yml").toPath();
        try {
            ReentrantLock lock = (ReentrantLock)locks.get((Object)path.toAbsolutePath());
            lock.lock();
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                Yamlizator.getYaml().dump(data, (Writer)writer);
            }
            finally {
                lock.unlock();
            }
            return path;
        }
        catch (IOException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path dumpToYmlFile(EntityPropertiesBuilder builder, File exportSubDir, String fileName) {
        Path path = new File(exportSubDir, fileName + ".yml").toPath();
        try {
            ReentrantLock lock = (ReentrantLock)locks.get((Object)path.toAbsolutePath());
            lock.lock();
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                BambooSpecSerializer.dump((EntityPropertiesBuilder)builder, (Writer)writer);
            }
            finally {
                lock.unlock();
            }
            return path;
        }
        catch (IOException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path dumpToFile(String yaml, File exportSubDir, String fileName) {
        Path path = new File(exportSubDir, fileName).toPath();
        try {
            ReentrantLock lock = (ReentrantLock)locks.get((Object)path.toAbsolutePath());
            lock.lock();
            try {
                if (!Files.exists(path.getParent(), new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                Files.write(path, yaml.getBytes("UTF-8"), new OpenOption[0]);
            }
            finally {
                lock.unlock();
            }
            return path;
        }
        catch (IOException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String dumpToYmlString(EntityPropertiesBuilder builder) {
        return BambooSpecSerializer.dump((EntityPropertiesBuilder)builder);
    }

    private static BambooSpecProperties parseSpecProperties(@NotNull String yamlString) throws YamlValidationException {
        try {
            return (BambooSpecProperties)Yamlizator.getYaml().loadAs(yamlString, BambooSpecProperties.class);
        }
        catch (Exception e) {
            String errorMessage = "Could not parse yaml input: " + e.getMessage();
            log.error((Object)errorMessage);
            throw new YamlValidationException(errorMessage);
        }
    }

    private static void checkEntity(@Nullable EntityProperties entity, Class<?> entityClass) throws YamlValidationException {
        if (entity == null) {
            String errorMessage = "Invalid yaml content (no entity found)";
            log.error((Object)"Invalid yaml content (no entity found)");
            throw new YamlValidationException("Invalid yaml content (no entity found)");
        }
        if (!entityClass.isInstance(entity)) {
            String errorMessage = String.format("Invalid yaml content (entity class = %s)", entity.getClass().getName());
            log.error((Object)errorMessage);
            throw new YamlValidationException(errorMessage);
        }
    }

    @NotNull
    public static <T extends EntityProperties> T parse(@NotNull String yamlString, Class<T> entityClass) throws YamlValidationException {
        BambooSpecProperties specProperties = YamlHelper.parseSpecProperties(yamlString);
        EntityProperties entity = specProperties.getRootEntity();
        YamlHelper.checkEntity(entity, entityClass);
        return (T)entity;
    }

    @NotNull
    public static <T extends EntityProperties> T parseAndNarrow(@NotNull String yamlString, Class<T> entityClass) throws YamlValidationException {
        BambooSpecProperties specProperties = YamlHelper.parseSpecProperties(yamlString);
        EntityProperties entity = specProperties.getRootEntity();
        YamlHelper.checkEntity(entity, entityClass);
        return (T)((EntityProperties)entityClass.cast(entity));
    }
}

