/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.helpers;

import com.atlassian.bamboo.build.BuildTriggerConditionExporter;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryIdentifier;
import com.atlassian.bamboo.specs.api.builders.trigger.AnyTriggerCondition;
import com.atlassian.bamboo.specs.api.builders.trigger.RepositoryBasedTrigger;
import com.atlassian.bamboo.specs.api.builders.trigger.Trigger;
import com.atlassian.bamboo.specs.api.builders.trigger.TriggerCondition;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.deployment.DeploymentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.EnvironmentProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.trigger.AnyTriggerProperties;
import com.atlassian.bamboo.specs.api.model.trigger.RepositoryBasedTriggerProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerConditionProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.codegen.BuilderClassProvider;
import com.atlassian.bamboo.trigger.BuildTriggerConditionModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerActivator;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerDefinitionImpl;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.trigger.export.DefaultTriggerConditionExporter;
import com.atlassian.bamboo.trigger.export.DefaultTriggerDefinitionExporter;
import com.atlassian.bamboo.trigger.export.TriggerDefinitionExporter;
import com.atlassian.bamboo.trigger.export.TriggerValidationContext;
import com.atlassian.bamboo.trigger.export.TriggerValidationContextImpl;
import com.atlassian.bamboo.trigger.export.TriggeringRepositoriesHelper;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooPreconditions;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class TriggerDefinitionExportHelper {
    private static final Logger log = Logger.getLogger(TriggerDefinitionExportHelper.class);
    private static final String NULL_TRIGGERING_REPOSITORY_MESSAGE = "Can't export trigger by id: %d. Can't find proper triggering repositories: %s";
    @Autowired
    private TriggerTypeManager triggerTypeManager;
    @Autowired
    private RepositoryDefinitionManager repositoryDefinitionManager;

    @NotNull
    public Trigger<?, ?> toSpecsEntity(@Nullable Set<Long> availableRepositories, @NotNull TriggerDefinition triggerDefinition, @NotNull Triggerable triggerable) {
        TriggerDefinitionExporter triggerDefinitionExporter = this.getExporter(triggerDefinition.getPluginKey());
        Trigger trigger = triggerDefinitionExporter.toSpecsEntity(triggerDefinition, triggerable).name(triggerDefinition.getName()).description(triggerDefinition.getUserDescription()).conditions(this.mapTriggerConditions(triggerDefinition.getTriggerConditionsConfiguration())).enabled(triggerDefinition.isEnabled());
        RepositoryBasedTrigger repositoryBasedTrigger = (RepositoryBasedTrigger)Narrow.downTo((Object)trigger, RepositoryBasedTrigger.class);
        if (repositoryBasedTrigger != null) {
            if (availableRepositories != null && triggerDefinition.getTriggeringRepositories().containsAll(availableRepositories)) {
                repositoryBasedTrigger.allAvailableTriggeringRepositories();
            } else {
                triggerDefinition.getTriggeringRepositories().stream().map(arg_0 -> ((RepositoryDefinitionManager)this.repositoryDefinitionManager).getRepositoryDataEntity(arg_0)).peek(data -> {
                    if (data == null) {
                        throw new IllegalStateException(String.format(NULL_TRIGGERING_REPOSITORY_MESSAGE, triggerDefinition.getId(), triggerDefinition.getTriggeringRepositories()));
                    }
                }).map(this::repositoryEntityToVcsIdentifier).forEach(xva$0 -> repositoryBasedTrigger.selectedTriggeringRepositories(new VcsRepositoryIdentifier[]{xva$0}));
            }
        }
        return trigger;
    }

    @NotNull
    public TriggerDefinition importTriggerDefinition(long id, @NotNull Triggerable triggerable, @NotNull TriggerProperties triggerProperties) throws PropertiesValidationException {
        TriggerDefinitionExporter exporter = this.getExporter(triggerProperties);
        Map cfg = exporter.toTriggerConfiguration(triggerProperties, triggerable);
        TriggerDefinitionImpl.Builder builder = new TriggerDefinitionImpl.Builder().id(id).pluginKey(triggerProperties.getAtlassianPlugin().getCompleteModuleKey()).name(triggerProperties.getName()).triggerConditionsConfiguration(this.mapTriggerConditionConfigurations(triggerProperties.getConditions())).configuration(cfg).enabled(triggerProperties.isEnabled());
        builder.userDescription(StringUtils.defaultString((String)triggerProperties.getDescription()));
        RepositoryBasedTriggerProperties repositoryBasedTriggerProperties = (RepositoryBasedTriggerProperties)Narrow.downTo((Object)triggerProperties, RepositoryBasedTriggerProperties.class);
        if (repositoryBasedTriggerProperties != null) {
            ImmutablePlan immutablePlan = (ImmutablePlan)Narrow.downTo((Object)triggerable, ImmutablePlan.class);
            if (immutablePlan != null) {
                builder.triggeringRepositories(this.getTriggeringPlanRepositoryIDs(immutablePlan, repositoryBasedTriggerProperties));
            } else {
                if (repositoryBasedTriggerProperties.getTriggeringRepositoriesType() == RepositoryBasedTrigger.TriggeringRepositoriesType.ALL) {
                    throw new IllegalStateException(String.format("This entity type: %s must have the list of triggering repositories specified", triggerable));
                }
                builder.triggeringRepositories(this.getTriggeringRepositoriesIds(repositoryBasedTriggerProperties));
            }
        }
        return builder.build();
    }

    public void validateTriggerProperties(@NotNull PlanProperties topLevelPlanProperties, @NotNull RssPermissions rssPermissions) throws PropertiesValidationException {
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        for (TriggerProperties triggerProperties : topLevelPlanProperties.getTriggers()) {
            if (this.canTriggerBeUsedInContextOf((EntityProperties)topLevelPlanProperties, triggerProperties)) {
                TriggerValidationContextImpl validationContext = new TriggerValidationContextImpl(topLevelPlanProperties, rssPermissions);
                TriggerDefinitionExporter triggerDefinitionExporter = this.getExporter(triggerProperties);
                Optional.ofNullable(triggerDefinitionExporter.validate((TriggerValidationContext)validationContext, triggerProperties)).ifPresent(problems::addAll);
                for (TriggerConditionProperties condition : triggerProperties.getConditions()) {
                    BuildTriggerConditionExporter conditionExporter = this.getExporter(condition);
                    Optional.ofNullable(conditionExporter.validate((TriggerValidationContext)validationContext, condition)).ifPresent(problems::addAll);
                }
                continue;
            }
            problems.add(new ValidationProblem("Trigger type " + this.specClassNameForTriggerProperties(triggerProperties) + " cannot be used in plans"));
        }
        if (!problems.isEmpty()) {
            throw new PropertiesValidationException(problems);
        }
    }

    public void validateTriggerProperties(@NotNull DeploymentProperties deploymentProperties, @NotNull RssPermissions rssPermissions) throws PropertiesValidationException, YamlValidationException {
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        for (EnvironmentProperties environmentProperties : deploymentProperties.getEnvironments()) {
            for (TriggerProperties triggerProperties : environmentProperties.getTriggers()) {
                if (this.canTriggerBeUsedInContextOf((EntityProperties)deploymentProperties, triggerProperties)) {
                    TriggerValidationContextImpl validationContext = new TriggerValidationContextImpl(deploymentProperties, environmentProperties, rssPermissions);
                    TriggerDefinitionExporter triggerDefinitionExporter = this.getExporter(triggerProperties);
                    List validationProblems = triggerDefinitionExporter.validate((TriggerValidationContext)validationContext, triggerProperties);
                    if (validationProblems == null) continue;
                    problems.addAll(validationProblems);
                    continue;
                }
                problems.add(new ValidationProblem("Trigger type " + this.specClassNameForTriggerProperties(triggerProperties) + " cannot be used in plans"));
            }
        }
        if (!problems.isEmpty()) {
            throw new PropertiesValidationException(problems);
        }
    }

    public void deactivate(@NotNull Triggerable environment, @NotNull TriggerDefinition triggerDefinition) {
        TriggerActivator activator = this.getActivator(triggerDefinition.getPluginKey());
        if (activator != null) {
            activator.deactivate(environment, triggerDefinition);
        }
    }

    public void activateIfEnabled(@NotNull Triggerable environment, @NotNull TriggerDefinition triggerDefinition) {
        if (!triggerDefinition.isEnabled()) {
            return;
        }
        TriggerActivator activator = this.getActivator(triggerDefinition.getPluginKey());
        if (activator != null) {
            activator.activate(environment, triggerDefinition);
        }
    }

    public TriggerDefinitionExporter getExporter(@NotNull TriggerProperties properties) {
        if (properties instanceof AnyTriggerProperties) {
            return new DefaultTriggerDefinitionExporter();
        }
        return this.getExporter(properties.getAtlassianPlugin().getCompleteModuleKey());
    }

    private TriggerCondition[] mapTriggerConditions(Map<String, String> triggerConditionsConfiguration) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        LinkedHashMap<String, String> localCopy = new LinkedHashMap<String, String>(triggerConditionsConfiguration);
        for (BuildTriggerConditionModuleDescriptor triggerConditionDescriptor : this.triggerTypeManager.getAvailableBuildTriggerConditionModuleDescriptors()) {
            BuildTriggerConditionExporter exporter = triggerConditionDescriptor.getExporter();
            if (exporter == null) continue;
            TriggerCondition entity = exporter.toSpecsEntity(localCopy);
            if (entity != null) {
                result.add(entity);
            }
            for (Object configurationKey : exporter.getConfigurationKeys()) {
                localCopy.remove(configurationKey.toString());
            }
        }
        if (!localCopy.isEmpty()) {
            result.add(new AnyTriggerCondition().config(localCopy));
        }
        return result.toArray(new TriggerCondition[0]);
    }

    private Map<String, String> mapTriggerConditionConfigurations(Collection<? extends TriggerConditionProperties> conditions) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (TriggerConditionProperties triggerConditionProperties : conditions) {
            BuildTriggerConditionExporter exporter = this.getExporter(triggerConditionProperties);
            Map map = exporter.toConfigurationMap(triggerConditionProperties);
            if (map == null) continue;
            result.putAll(map);
        }
        return result;
    }

    private Set<Long> getTriggeringRepositoriesIds(RepositoryBasedTriggerProperties repositoryBasedTriggerProperties) {
        HashSet<Long> ids = new HashSet<Long>();
        for (VcsRepositoryIdentifierProperties vcsIdentifier : repositoryBasedTriggerProperties.getSelectedTriggeringRepositories()) {
            if (vcsIdentifier.getOid() != null) {
                BambooEntityOid oid = BambooEntityOid.createFromExternalValue((String)vcsIdentifier.getOid().getOid());
                VcsRepositoryData vcsRepositoryData = this.repositoryDefinitionManager.getVcsRepositoryDataByOid(oid);
                BambooPreconditions.checkThat((vcsRepositoryData != null ? 1 : 0) != 0, PropertiesValidationException::new, (String)"Couldn't find repository with oid: %s", (Object[])new Object[]{vcsIdentifier.getOid().getOid()});
                ids.add(vcsRepositoryData.getId());
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)vcsIdentifier.getName())) continue;
            VcsRepositoryData vcsRepositoryData = this.repositoryDefinitionManager.getLinkedRepositoryByName(vcsIdentifier.getName());
            BambooPreconditions.checkThat((vcsRepositoryData != null ? 1 : 0) != 0, PropertiesValidationException::new, (String)"Couldn't find repository with name: %s", (Object[])new Object[]{vcsIdentifier.getName()});
            ids.add(vcsRepositoryData.getId());
        }
        return ids;
    }

    private Set<Long> getTriggeringPlanRepositoryIDs(ImmutablePlan immutablePlan, RepositoryBasedTriggerProperties repositoryBasedTriggerProperties) {
        HashSet<Long> ids = new HashSet<Long>();
        List planRepositoryLinks = this.repositoryDefinitionManager.getPlanRepositoryLinks(immutablePlan);
        TriggeringRepositoriesHelper triggeringRepositoriesHelper = new TriggeringRepositoriesHelper(planRepositoryLinks);
        if (repositoryBasedTriggerProperties.getTriggeringRepositoriesType() == RepositoryBasedTrigger.TriggeringRepositoriesType.ALL) {
            return planRepositoryLinks.stream().map(planRepositoryLink -> planRepositoryLink.getRepositoryDataEntity().getId()).collect(Collectors.toSet());
        }
        for (VcsRepositoryIdentifierProperties vcsIdentifier : repositoryBasedTriggerProperties.getSelectedTriggeringRepositories()) {
            if (vcsIdentifier.getOid() != null) {
                BambooEntityOid oid = BambooEntityOid.createFromExternalValue((String)vcsIdentifier.getOid().getOid());
                Long repositoryId = triggeringRepositoriesHelper.getTriggeringRepositoryIdByOid(oid.toExternalValue());
                BambooPreconditions.checkThat((repositoryId != null ? 1 : 0) != 0, PropertiesValidationException::new, (String)"Couldn't find repository with oid: %s", (Object[])new Object[]{oid.toExternalValue()});
                ids.add(repositoryId);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)vcsIdentifier.getName())) continue;
            Long repositoryId = triggeringRepositoriesHelper.getTriggeringRepositoryIdByName(vcsIdentifier.getName());
            BambooPreconditions.checkThat((repositoryId != null ? 1 : 0) != 0, PropertiesValidationException::new, (String)"Couldn't find repository with name: %s", (Object[])new Object[]{vcsIdentifier.getName()});
            ids.add(repositoryId);
        }
        return ids;
    }

    private VcsRepositoryIdentifier repositoryEntityToVcsIdentifier(RepositoryDataEntity dataEntity) {
        return new VcsRepositoryIdentifier(new BambooOid(dataEntity.getOid().toExternalValue())).name(dataEntity.getName());
    }

    private boolean canTriggerBeUsedInContextOf(EntityProperties owner, @NotNull TriggerProperties triggerProperties) {
        String pluginKey = triggerProperties.getAtlassianPlugin().getCompleteModuleKey();
        TriggerModuleDescriptor triggerModuleDescriptor = this.triggerTypeManager.getTriggerDescriptor(pluginKey);
        if (triggerModuleDescriptor != null) {
            return owner instanceof PlanProperties && triggerModuleDescriptor.canTriggerType(ImmutableChain.class) || owner instanceof DeploymentProperties && triggerModuleDescriptor.canTriggerType(Environment.class);
        }
        log.warn((Object)("Plugin " + pluginKey + " not installed or disabled. Falling back on generic export."));
        return true;
    }

    private TriggerDefinitionExporter getExporter(String pluginKey) {
        TriggerModuleDescriptor triggerDescriptor = this.triggerTypeManager.getTriggerDescriptor(pluginKey);
        if (triggerDescriptor == null) {
            log.warn((Object)("Plugin " + pluginKey + " not installed or disabled. Falling back on generic export."));
        } else if (triggerDescriptor.getTriggerExporter() != null) {
            return triggerDescriptor.getTriggerExporter();
        }
        return new DefaultTriggerDefinitionExporter();
    }

    private BuildTriggerConditionExporter getExporter(@NotNull TriggerConditionProperties properties) {
        return Optional.ofNullable(properties.getAtlassianPlugin()).map(AtlassianModuleProperties::getCompleteModuleKey).map(pluginKey -> this.triggerTypeManager.getBuildTriggerConditionDescriptor(pluginKey)).map(BuildTriggerConditionModuleDescriptor::getExporter).orElse(new DefaultTriggerConditionExporter());
    }

    @Nullable
    private TriggerActivator getActivator(String pluginKey) {
        TriggerModuleDescriptor triggerDescriptor = this.triggerTypeManager.getTriggerDescriptor(pluginKey);
        if (triggerDescriptor == null) {
            log.warn((Object)("Plugin " + pluginKey + " not installed or disabled."));
            return null;
        }
        return (TriggerActivator)triggerDescriptor.getModule();
    }

    private String specClassNameForTriggerProperties(@NotNull TriggerProperties properties) {
        try {
            return BuilderClassProvider.findBuilderClass(properties.getClass()).getCanonicalName();
        }
        catch (CodeGenerationException e) {
            return properties.getAtlassianPlugin().getCompleteModuleKey();
        }
    }
}

