/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.helpers;

import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskType;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.condition.AnyTaskCondition;
import com.atlassian.bamboo.specs.api.builders.condition.TaskCondition;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.deployment.DeploymentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.EnvironmentProperties;
import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.model.plan.StageProperties;
import com.atlassian.bamboo.specs.api.model.plan.condition.AnyConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.task.AnyTaskProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.codegen.BuilderClassProvider;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskConditionConfig;
import com.atlassian.bamboo.task.TaskConditionConfigImpl;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskDefinitionImpl;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.task.export.DefaultTaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.task.export.TaskValidationContextImpl;
import com.atlassian.bamboo.util.Narrow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class TaskDefinitionExportHelper {
    private static final Logger log = Logger.getLogger(TaskDefinitionExportHelper.class);
    private final TaskManager taskManager;

    @Autowired
    public TaskDefinitionExportHelper(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @NotNull
    public Task toSpecsEntity(TaskContainer taskContainer, TaskDefinition taskDefinition) {
        TaskDefinitionExporter taskDefinitionExporter = this.getExporter(taskDefinition);
        return taskDefinitionExporter.toSpecsEntity(taskContainer, taskDefinition).description(taskDefinition.getUserDescription()).conditions(this.getConditions(taskDefinition.getConditions())).enabled(taskDefinition.isEnabled());
    }

    private TaskDefinitionExporter getExporter(@NotNull TaskDefinition taskDefinition) {
        return this.getExporter(taskDefinition.getPluginKey());
    }

    public TaskDefinitionExporter getExporter(@NotNull TaskProperties properties) {
        if (properties instanceof AnyTaskProperties) {
            return new DefaultTaskDefinitionExporter();
        }
        return this.getExporter(properties.getAtlassianPlugin().getCompleteModuleKey());
    }

    @NotNull
    public TaskDefinitionExporter getExporter(@NotNull String pluginKey) {
        TaskModuleDescriptor taskModuleDescriptor = this.taskManager.getTaskDescriptor(pluginKey);
        if (taskModuleDescriptor == null) {
            log.warn((Object)("Plugin " + pluginKey + " not installed or disabled. Falling back on generic export."));
        } else if (taskModuleDescriptor.getTaskExporter() != null) {
            return taskModuleDescriptor.getTaskExporter();
        }
        return new DefaultTaskDefinitionExporter();
    }

    private boolean canTaskBeUsedInContextOf(EntityProperties owner, @NotNull TaskProperties taskProperties) {
        String pluginKey = taskProperties.getAtlassianPlugin().getCompleteModuleKey();
        TaskModuleDescriptor taskModuleDescriptor = this.taskManager.getTaskDescriptor(pluginKey);
        if (taskModuleDescriptor != null) {
            return CommonTaskType.class.isAssignableFrom(taskModuleDescriptor.getModuleClass()) || owner instanceof PlanProperties && TaskType.class.isAssignableFrom(taskModuleDescriptor.getModuleClass()) || owner instanceof DeploymentProperties && DeploymentTaskType.class.isAssignableFrom(taskModuleDescriptor.getModuleClass());
        }
        log.warn((Object)("Plugin " + pluginKey + " not installed or disabled. Falling back on generic export."));
        return true;
    }

    @NotNull
    public TaskDefinition importTaskDefinition(long id, @NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties, boolean finalTask) throws PropertiesValidationException {
        return this.importTaskDefinition(id, taskContainer, Collections.emptyList(), taskProperties, null, finalTask);
    }

    @NotNull
    public TaskDefinition importTaskDefinition(long id, @NotNull TaskContainer taskContainer, @NotNull List<TaskDefinition> precedingTasks, @NotNull TaskProperties taskProperties, @Nullable VcsBranch importedBranch, boolean finalTask) throws PropertiesValidationException {
        TaskDefinitionExporter exporter = this.getExporter(taskProperties);
        Map cfg = exporter.toTaskConfiguration(taskContainer, precedingTasks, taskProperties, importedBranch);
        return new TaskDefinitionImpl(id, taskProperties.getAtlassianPlugin().getCompleteModuleKey(), taskProperties.getDescription(), taskProperties.isEnabled(), this.getConditions(taskProperties.getConditions()), cfg, finalTask);
    }

    public void validateTaskProperties(@NotNull PlanProperties topLevelPlanProperties, @NotNull RssPermissions rssPermissions, @Nullable VcsBranch importedBranch) throws PropertiesValidationException {
        ArrayList problems = new ArrayList();
        for (StageProperties stageProperties : topLevelPlanProperties.getStages()) {
            for (JobProperties jobProperties : stageProperties.getJobs()) {
                Stream.concat(jobProperties.getTasks().stream(), jobProperties.getFinalTasks().stream()).forEach(taskProperties -> {
                    if (this.canTaskBeUsedInContextOf((EntityProperties)topLevelPlanProperties, (TaskProperties)taskProperties)) {
                        TaskValidationContext validationContext = new TaskValidationContextImpl.Builder().withPlan(topLevelPlanProperties).withJob(jobProperties).withRssPermissions(rssPermissions).withBranch(importedBranch).build();
                        this.validateTask(problems, (TaskProperties)taskProperties, validationContext);
                    } else {
                        problems.add(new ValidationProblem("Task type " + this.specClassNameForTaskProperties((TaskProperties)taskProperties) + " cannot be used in plans"));
                    }
                });
            }
        }
        if (!problems.isEmpty()) {
            throw new PropertiesValidationException(problems);
        }
    }

    public void validateTaskProperties(@NotNull DeploymentProperties deploymentProperties, @NotNull RssPermissions rssPermissions) throws PropertiesValidationException {
        ArrayList problems = new ArrayList();
        for (EnvironmentProperties environmentProperties : deploymentProperties.getEnvironments()) {
            Stream.concat(environmentProperties.getTasks().stream(), environmentProperties.getFinalTasks().stream()).forEach(taskProperties -> {
                if (this.canTaskBeUsedInContextOf((EntityProperties)deploymentProperties, (TaskProperties)taskProperties)) {
                    TaskValidationContext validationContext = new TaskValidationContextImpl.Builder().withDeployment(deploymentProperties).withEnvironment(environmentProperties).withRssPermissions(rssPermissions).build();
                    this.validateTask(problems, (TaskProperties)taskProperties, validationContext);
                } else {
                    problems.add(new ValidationProblem("Task type " + this.specClassNameForTaskProperties((TaskProperties)taskProperties) + " cannot be used in deployments"));
                }
            });
        }
        if (!problems.isEmpty()) {
            throw new PropertiesValidationException(problems);
        }
    }

    private void validateTask(List<ValidationProblem> problems, TaskProperties taskProperties, TaskValidationContext validationContext) {
        TaskDefinitionExporter taskDefinitionExporter = this.getExporter(taskProperties);
        problems.addAll(taskDefinitionExporter.validate(validationContext, taskProperties));
        if (taskProperties.getConditions().size() > 1) {
            problems.add(new ValidationProblem("Only one condition per task is supported"));
        }
    }

    private String specClassNameForTaskProperties(@NotNull TaskProperties properties) {
        try {
            return BuilderClassProvider.findBuilderClass(properties.getClass()).getCanonicalName();
        }
        catch (CodeGenerationException e) {
            return properties.getAtlassianPlugin().getCompleteModuleKey();
        }
    }

    @NotNull
    private List<TaskConditionConfig> getConditions(@NotNull Collection<? extends ConditionProperties> conditions) {
        return conditions.stream().map(this::getTaskConditionConfig).collect(Collectors.toList());
    }

    @NotNull
    private TaskConditionConfig getTaskConditionConfig(ConditionProperties condition) {
        AnyConditionProperties anyConditionProperties = (AnyConditionProperties)Narrow.downTo((Object)condition, AnyConditionProperties.class);
        if (anyConditionProperties != null) {
            return new TaskConditionConfigImpl(condition.getAtlassianPlugin().getCompleteModuleKey(), anyConditionProperties.getConfiguration());
        }
        throw new IllegalStateException("Doesn't support " + condition + " condition type");
    }

    @NotNull
    private TaskCondition[] getConditions(@NotNull List<TaskConditionConfig> conditions) {
        return (TaskCondition[])conditions.stream().map(condition -> new AnyTaskCondition(new AtlassianModule(condition.getConditionPluginKey())).configuration(condition.getConfiguration())).toArray(TaskCondition[]::new);
    }
}

