/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.helpers;

import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.model.repository.PlanRepositoryLinkProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class RepositoryReferenceHelper {
    @NotNull
    public static Optional<VcsRepositoryProperties> getDefaultRepositoryInPlan(@NotNull PlanProperties planProperties) {
        return planProperties.getRepositories().stream().findFirst().map(PlanRepositoryLinkProperties::getRepositoryDefinition);
    }

    @NotNull
    public static Optional<VcsRepositoryProperties> findReferencedRepositoryInPlan(@NotNull VcsRepositoryIdentifierProperties repository, @NotNull PlanProperties planProperties) {
        return planProperties.getRepositories().stream().filter(r -> {
            VcsRepositoryIdentifierProperties other = r.getRepositoryDefinition().toIdentifier();
            if (repository.isOidDefined() && Objects.equals(repository.getOid(), other.getOid())) {
                return true;
            }
            String parent = r.getRepositoryDefinition().getParent();
            if (parent != null && parent.equals(repository.getName())) {
                return true;
            }
            return repository.isNameDefined() && (Objects.equals(repository.getName(), other.getName()) || Objects.equals(repository.getName(), r.getRepositoryDefinition().getParent()));
        }).map(PlanRepositoryLinkProperties::getRepositoryDefinition).findFirst();
    }
}

