/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.helpers;

import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.PlanBranchGist;
import com.opensymphony.xwork2.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PlanRepositoryValidator {
    private static final Logger log = Logger.getLogger(PlanRepositoryValidator.class);
    private final CachedPlanManager cachedPlanManager;

    @Inject
    public PlanRepositoryValidator(@NotNull CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public boolean canChangeDefaultRepository(@NotNull ImmutablePlan plan) {
        PlanBranchWorkflow planBranchWorkflow = plan.getBuildDefinition().getBranchMonitoringConfiguration().getPlanBranchWorkflow();
        if (planBranchWorkflow != PlanBranchWorkflow.PULL_REQUEST_WORKFLOW) {
            return true;
        }
        for (PlanBranchGist gist : this.cachedPlanManager.getBranchGistsOfChain(plan.getPlanKey())) {
            if (gist.getPlanBranchWorkflow() != PlanBranchWorkflow.PULL_REQUEST_WORKFLOW) continue;
            log.debug((Object)("Found existing PR branch: " + gist.getKey() + " - change of default repo is not allowed"));
            return false;
        }
        return true;
    }
}

