/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.helpers;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class PlanImportHelper {
    public static Optional<TopLevelPlan> findExistingPlanByOidOrKey(@NotNull PlanIdentifierProperties planProperties, PlanManager planManager) {
        return PlanImportHelper.findExistingPlanByOidOrKey(planProperties, planManager, TopLevelPlan.class);
    }

    public static <T extends Chain> Optional<T> findExistingPlanByOidOrKey(@NotNull PlanIdentifierProperties planProperties, PlanManager planManager, @NotNull Class<T> clazz) {
        if (planProperties.getOid() != null) {
            return Optional.ofNullable(planManager.getPlanByOid(BambooEntityOid.createFromExternalValue((String)planProperties.getOid().getOid()), clazz));
        }
        PlanKey planKey = PlanKeys.getPlanKey((String)planProperties.getProjectKey().getKey(), (String)planProperties.getKey().getKey());
        return Optional.ofNullable(planManager.getPlanByKey(planKey, clazz));
    }

    public static <T extends Chain> Optional<T> findExistingPlanByOidOrKey(@NotNull PlanProperties planProperties, PlanManager planManager, @NotNull Class<T> clazz) {
        if (planProperties.getOid() != null) {
            return Optional.ofNullable(planManager.getPlanByOid(BambooEntityOid.createFromExternalValue((String)planProperties.getOid().getOid()), clazz));
        }
        PlanKey planKey = PlanKeys.getPlanKey((String)planProperties.getProject().getKey().getKey(), (String)planProperties.getKey().getKey());
        return Optional.ofNullable(planManager.getPlanByKey(planKey, clazz));
    }
}

