/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.helpers;

import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.PermissionsServiceUtils;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.GroupPrincipalSid;
import com.atlassian.bamboo.specs.api.builders.permission.PermissionType;
import com.atlassian.bamboo.specs.api.builders.permission.Permissions;
import com.atlassian.bamboo.specs.api.model.permission.AnonymousUserPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.GroupPermissionProperties;
import com.atlassian.bamboo.specs.api.model.permission.LoggedInUserPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.UserPermissionProperties;
import com.atlassian.bamboo.user.Authority;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.jetbrains.annotations.NotNull;

public class PermissionHelper {
    private static final BiMap<BambooPermission, PermissionType> BAMBOO_PERMISSION_TO_PERMISSION_TYPE = ImmutableBiMap.builder().put((Object)BambooPermission.READ, (Object)PermissionType.VIEW).put((Object)BambooPermission.WRITE, (Object)PermissionType.EDIT).put((Object)BambooPermission.CREATE, (Object)PermissionType.CREATE).put((Object)BambooPermission.DELETE, (Object)PermissionType.DELETE).put((Object)BambooPermission.BUILD, (Object)PermissionType.BUILD).put((Object)BambooPermission.CLONE, (Object)PermissionType.CLONE).put((Object)BambooPermission.ADMINISTRATION, (Object)PermissionType.ADMIN).build();

    public static List<String> createPermissionsForUsers(Function<BambooPermission, Collection<BambooPermission>> permissionDependenciesSupplier, List<UserPermissionProperties> userPermissionsList) {
        ArrayList<String> permissions = new ArrayList<String>();
        for (UserPermissionProperties userPermissions : userPermissionsList) {
            Collection<BambooPermission> effectivePermissions = PermissionHelper.toEffectiveBambooPermissions(permissionDependenciesSupplier, userPermissions.getPermissionTypes());
            effectivePermissions.stream().map(BambooPermission::getName).map(permission -> BambooAclUpdateHelper.createUserPermissionKey((String)userPermissions.getUsername(), (String)permission)).forEach(permissions::add);
        }
        return permissions;
    }

    public static List<String> createPermissionsForGroups(Function<BambooPermission, Collection<BambooPermission>> permissionDependenciesSupplier, List<GroupPermissionProperties> groupPermissionsList) {
        ArrayList<String> permissions = new ArrayList<String>();
        for (GroupPermissionProperties groupPermissions : groupPermissionsList) {
            Collection<BambooPermission> effectivePermissions = PermissionHelper.toEffectiveBambooPermissions(permissionDependenciesSupplier, groupPermissions.getPermissionTypes());
            effectivePermissions.stream().map(BambooPermission::getName).map(permission -> BambooAclUpdateHelper.createGroupPermissionKey((String)groupPermissions.getGroup(), (String)permission)).forEach(permissions::add);
        }
        return permissions;
    }

    public static List<String> createPermissionsForLoggedInUser(Function<BambooPermission, Collection<BambooPermission>> permissionDependenciesSupplier, LoggedInUserPermissionsProperties loggedInUserPermissionProperties) {
        Collection<BambooPermission> effectivePermissions = PermissionHelper.toEffectiveBambooPermissions(permissionDependenciesSupplier, loggedInUserPermissionProperties.getPermissionTypes());
        return effectivePermissions.stream().map(BambooPermission::getName).map(permission -> BambooAclUpdateHelper.createRolePermissionKey((String)Authority.USER.getAuthority(), (String)permission)).collect(Collectors.toList());
    }

    public static List<String> createPermissionsForAnonymousUser(Function<BambooPermission, Collection<BambooPermission>> permissionDependenciesSupplier, AnonymousUserPermissionsProperties anonymousUserPermissionProperties) {
        Collection<BambooPermission> effectivePermissions = PermissionHelper.toEffectiveBambooPermissions(permissionDependenciesSupplier, anonymousUserPermissionProperties.getPermissionTypes());
        return effectivePermissions.stream().map(BambooPermission::getName).map(permission -> BambooAclUpdateHelper.createRolePermissionKey((String)Authority.ANONYMOUS.getAuthority(), (String)permission)).collect(Collectors.toList());
    }

    private static Collection<BambooPermission> toEffectiveBambooPermissions(@NotNull Function<BambooPermission, Collection<BambooPermission>> permissionDependenciesSupplier, @NotNull Collection<PermissionType> permissionTypes) {
        return PermissionsServiceUtils.getPermissionsAndDependencies((Collection)permissionTypes.stream().map(PermissionHelper::toBambooPermission).collect(Collectors.toList()), permissionDependenciesSupplier);
    }

    public static BambooPermission toBambooPermission(PermissionType permissionType) {
        BiMap permissionTypeToBambooPermission = BAMBOO_PERMISSION_TO_PERMISSION_TYPE.inverse();
        Preconditions.checkState((boolean)permissionTypeToBambooPermission.containsKey((Object)permissionType), (String)"Unknown permission type value: %s", (Object)permissionType);
        return (BambooPermission)permissionTypeToBambooPermission.get((Object)permissionType);
    }

    public static PermissionType fromBambooPermission(BambooPermission bambooPermission) {
        Preconditions.checkState((boolean)BAMBOO_PERMISSION_TO_PERMISSION_TYPE.containsKey((Object)bambooPermission), (String)"Unknown permission type value: %s", (Object)bambooPermission);
        return (PermissionType)BAMBOO_PERMISSION_TO_PERMISSION_TYPE.get((Object)bambooPermission);
    }

    public static Permissions createFromAcl(Acl acl) {
        Permissions permission = new Permissions();
        for (AccessControlEntry accessControlEntry : acl.getEntries()) {
            Sid sid = accessControlEntry.getSid();
            BambooPermission bambooPermission = (BambooPermission)accessControlEntry.getPermission();
            if (sid instanceof PrincipalSid && !((PrincipalSid)sid).getPrincipal().equals(BambooPermissionManager.SYSTEM_AUTHORITY.getName())) {
                PermissionHelper.updateUserPermissions(permission, bambooPermission, (PrincipalSid)sid);
            }
            if (sid instanceof GroupPrincipalSid) {
                PermissionHelper.updateGroupPermissions(permission, bambooPermission, (GroupPrincipalSid)sid);
            }
            if (!(sid instanceof GrantedAuthoritySid)) continue;
            PermissionHelper.updateRolePermissions(permission, bambooPermission, (GrantedAuthoritySid)sid);
        }
        return permission;
    }

    private static void updateUserPermissions(Permissions permission, BambooPermission bambooPermission, PrincipalSid principalSid) {
        String userName = principalSid.getPrincipal();
        permission.userPermissions(userName, new PermissionType[]{PermissionHelper.fromBambooPermission(bambooPermission)});
    }

    private static void updateGroupPermissions(Permissions permission, BambooPermission bambooPermission, GroupPrincipalSid groupPrincipalSid) {
        String groupName = groupPrincipalSid.getPrincipal();
        permission.groupPermissions(groupName, new PermissionType[]{PermissionHelper.fromBambooPermission(bambooPermission)});
    }

    private static void updateRolePermissions(Permissions permission, BambooPermission bambooPermission, GrantedAuthoritySid grantedAuthoritySid) {
        if (grantedAuthoritySid.getGrantedAuthority().equals(Authority.ANONYMOUS.getAuthority())) {
            PermissionType permissionType = PermissionHelper.fromBambooPermission(bambooPermission);
            if (permissionType != PermissionType.VIEW) {
                throw new IllegalArgumentException(String.format("Anonymous permission can only be set to %s. Currently set to: %s", PermissionType.VIEW, permissionType));
            }
            permission.anonymousUserPermissionView();
        }
        if (grantedAuthoritySid.getGrantedAuthority().equals(Authority.USER.getAuthority())) {
            permission.loggedInUserPermissions(new PermissionType[]{PermissionHelper.fromBambooPermission(bambooPermission)});
        }
    }
}

