/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.helpers;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.configuration.external.helpers.JobImportHelper;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LicenseValidator {
    public static void validateJobsLimit(@Nullable TopLevelPlan plan, PlanProperties planProperties, int allowedNumberOfJobs, int jobsCount) throws IllegalArgumentException {
        LicenseValidator validator = new LicenseValidator();
        validator.validate(plan, planProperties, allowedNumberOfJobs, jobsCount);
    }

    private void validate(@Nullable TopLevelPlan existingPlan, PlanProperties planProperties, int allowedNumberOfJobs, int currentJobsCount) {
        long jobsIncrement;
        if (allowedNumberOfJobs != -1 && (long)currentJobsCount + (jobsIncrement = this.calculateJobsIncrement(existingPlan, planProperties)) > (long)allowedNumberOfJobs) {
            String errorMessage = String.format("You cannot add %s new jobs to already existing %s jobs because it will exceed the number of allowed jobs (%s)", Math.max(0L, jobsIncrement), currentJobsCount, allowedNumberOfJobs);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private long calculateJobsIncrement(@Nullable TopLevelPlan existingPlan, PlanProperties planProperties) {
        ArrayList<Job> existingJobs = existingPlan == null ? new ArrayList() : existingPlan.getAllJobs();
        long addedJobsCount = this.countAddedJobs(planProperties, existingJobs);
        long removedJobsCount = this.countRemovedJobs(existingPlan, this.collectExistingJobs(planProperties, existingJobs));
        return addedJobsCount - removedJobsCount;
    }

    private Set<JobProperties> collectExistingJobs(PlanProperties planProperties, List<Job> jobs) {
        return planProperties.getStages().stream().flatMap(stageProperties -> stageProperties.getJobs().stream()).filter(job -> !this.isNewJob(jobs, (JobProperties)job)).collect(Collectors.toSet());
    }

    private long countAddedJobs(PlanProperties planProperties, List<Job> jobs) {
        return planProperties.getStages().stream().flatMap(stageProperties -> stageProperties.getJobs().stream()).filter(jobProperties -> this.isNewJob(jobs, (JobProperties)jobProperties)).count();
    }

    private long countRemovedJobs(@Nullable TopLevelPlan existingPlan, Set<JobProperties> importedJobs) {
        if (existingPlan != null) {
            return existingPlan.getAllJobs().stream().filter(this.notImportedJob(importedJobs)).count();
        }
        return 0L;
    }

    @NotNull
    private Predicate<Job> notImportedJob(Set<JobProperties> importedJobs) {
        return job -> importedJobs.stream().noneMatch(this.jobExistsInImport((Job)job));
    }

    @NotNull
    private Predicate<JobProperties> jobExistsInImport(@NotNull Job job) {
        return jobProperties -> {
            if (jobProperties.getOid() == null) {
                return jobProperties.getKey() != null && Objects.equals(job.getKey(), jobProperties.getKey().getKey());
            }
            return Objects.equals(job.getOid(), BambooEntityOid.createFromExternalValue((String)jobProperties.getOid().getOid()));
        };
    }

    private boolean isNewJob(List<Job> jobs, JobProperties jobProperties) {
        return !JobImportHelper.findPlanByKey(jobs, jobProperties.toPlanIdentifier()).isPresent();
    }
}

