/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.helpers;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.plan.AbstractChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.plan.AbstractPlanIdentifierProperties;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class JobImportHelper {
    public static Job findJobByKeyExpectingSuccess(AbstractChain defaultChain, BambooKeyProperties jobReference) {
        return (Job)JobImportHelper.findPlanByKey(defaultChain.getAllJobs(), jobReference).get();
    }

    public static <T extends ImmutablePlan> Optional<T> findPlanByKey(List<T> jobs, BambooKeyProperties jobReference) {
        return jobs.stream().filter(j -> j.getBuildKey().equals(jobReference.getKey())).findFirst();
    }

    public static <T extends ImmutablePlan> Optional<T> findPlanByOidOrKey(List<T> jobs, AbstractPlanIdentifierProperties jobReference) {
        return JobImportHelper.findPlanByOidOrKey(jobs.stream(), jobReference);
    }

    public static <T extends ImmutablePlan> Optional<T> findPlanByOidOrKey(Stream<T> jobs, AbstractPlanIdentifierProperties jobReference) {
        return jobs.filter(j -> {
            if (jobReference.isOidDefined()) {
                return j.getOid().equals((Object)BambooEntityOid.createFromExternalValue((String)jobReference.getOid().getOid()));
            }
            return jobReference.getKey() != null && j.getBuildKey().equals(jobReference.getKey().getKey());
        }).findFirst();
    }
}

