/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.helpers;

import com.atlassian.bamboo.util.Narrow;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExportDataMapDiffCalculator {
    private ExportDataMapDiffCalculator() {
    }

    public static Map<String, Object> subtract(Map<String, Object> left, Map<String, Object> right) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : left.entrySet()) {
            Object rightValue = right.get(e.getKey());
            if (e.getValue() == null) {
                if (rightValue == null) continue;
                result.put(e.getKey(), null);
                continue;
            }
            Map leftMap = (Map)Narrow.downTo((Object)e.getValue(), Map.class);
            Map rightMap = (Map)Narrow.downTo((Object)rightValue, Map.class);
            if (leftMap != null && rightMap != null) {
                Map<String, Object> diff = ExportDataMapDiffCalculator.subtract(leftMap, rightMap);
                if (diff.isEmpty()) continue;
                if (diff.size() > 1) {
                    result.put(e.getKey(), diff);
                    continue;
                }
                Map.Entry onlyElement = (Map.Entry)Iterables.getOnlyElement(diff.entrySet());
                result.put(e.getKey() + '.' + (String)onlyElement.getKey(), onlyElement.getValue());
                continue;
            }
            if (e.getValue().equals(rightValue)) continue;
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }
}

