/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.helpers;

import com.atlassian.bamboo.build.docker.DockerPipelineConfiguration;
import com.atlassian.bamboo.build.docker.DockerPipelineConfigurationImpl;
import com.atlassian.bamboo.docker.DataVolume;
import com.atlassian.bamboo.specs.api.builders.docker.DockerConfiguration;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.deployment.DeploymentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.EnvironmentProperties;
import com.atlassian.bamboo.specs.api.model.docker.DockerConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.model.plan.StageProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.utils.SystemProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DockerPipelineExportHelper {
    private DockerPipelineExportHelper() {
    }

    @NotNull
    public static DockerPipelineConfiguration fromSpecsEntity(@NotNull DockerConfigurationProperties dockerPipelineProperties) {
        List dataVolumeList = dockerPipelineProperties.getVolumes().entrySet().stream().map(e -> new DataVolume((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        DockerPipelineConfigurationImpl dockerPipelineConfiguration = new DockerPipelineConfigurationImpl();
        dockerPipelineConfiguration.setEnabled(dockerPipelineProperties.isEnabled());
        dockerPipelineConfiguration.setImage(dockerPipelineProperties.getImage());
        dockerPipelineConfiguration.setDataVolumes(dataVolumeList);
        dockerPipelineConfiguration.setAdditionalArgs((Iterable)dockerPipelineProperties.getDockerRunArguments());
        return dockerPipelineConfiguration;
    }

    @NotNull
    public static DockerConfiguration toSpecsEntity(@NotNull DockerPipelineConfiguration dockerPipelineConfiguration) {
        DockerConfiguration dockerPipeline = new DockerConfiguration().enabled(dockerPipelineConfiguration.isEnabled());
        Optional.ofNullable(dockerPipelineConfiguration.getImage()).ifPresent(arg_0 -> ((DockerConfiguration)dockerPipeline).image(arg_0));
        dockerPipeline.withoutDefaultVolumes();
        dockerPipelineConfiguration.getDataVolumes().forEach(dataVolume -> dockerPipeline.volume(StringUtils.defaultString((String)dataVolume.getHostDirectory()), dataVolume.getContainerDirectory()));
        dockerPipelineConfiguration.getAdditionalArgs().forEach(xva$0 -> dockerPipeline.dockerRunArguments(new String[]{xva$0}));
        return dockerPipeline;
    }

    public static void validateDockerConfiguration(@NotNull PlanProperties planProperties) {
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        for (StageProperties stageProperties : planProperties.getStages()) {
            for (JobProperties jobProperties : stageProperties.getJobs()) {
                DockerConfigurationProperties dcp = jobProperties.getDockerConfiguration();
                if (!SystemProperty.DOCKER_PIPELINES_DISABLED.getTypedValue() || !dcp.isEnabled()) continue;
                problems.add(new ValidationProblem(String.format("Docker enabled in job %s-%s-%s but docker pipelines disabled on this server", planProperties.getProject().getKey(), planProperties.getKey(), jobProperties.getKey())));
            }
        }
        if (!problems.isEmpty()) {
            throw new PropertiesValidationException(problems);
        }
    }

    public static void validateDockerConfiguration(@NotNull DeploymentProperties deploymentProperties) {
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        for (EnvironmentProperties environmentProperties : deploymentProperties.getEnvironments()) {
            DockerConfigurationProperties dcp = environmentProperties.getDockerConfiguration();
            if (!SystemProperty.DOCKER_PIPELINES_DISABLED.getTypedValue() || !dcp.isEnabled()) continue;
            problems.add(new ValidationProblem(String.format("Docker enabled in environment %s %s but docker pipelines disabled on this server", deploymentProperties.getName(), environmentProperties.getName())));
        }
        if (!problems.isEmpty()) {
            throw new PropertiesValidationException(problems);
        }
    }
}

