/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.helpers;

import com.atlassian.bamboo.builder.JdkManager;
import com.atlassian.bamboo.configuration.external.helpers.ExecutableLabelValidator;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.task.TaskManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class DefaultExecutableLabelValidator
implements ExecutableLabelValidator {
    private final TaskManager taskManager;
    private final JdkManager jdkManager;

    @Inject
    public DefaultExecutableLabelValidator(TaskManager taskManager, JdkManager jdkManager) {
        this.taskManager = taskManager;
        this.jdkManager = jdkManager;
    }

    @Override
    public Optional<ValidationProblem> validateExecutableLabelExists(ValidationContext context, String executableLabel, String key) {
        List executableLabels = this.taskManager.getExecutableLabelTypeMap().entrySet().stream().filter(entry -> ((String)entry.getValue()).contains(key)).map(Map.Entry::getKey).collect(Collectors.toList());
        if (executableLabels.stream().noneMatch(label -> label.equals(executableLabel))) {
            return Optional.of(new ValidationProblem(context, "Can't find executable by label: '" + executableLabel + "'. Available values: " + executableLabels));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ValidationProblem> validateJDKLabels(ValidationContext context, String jdkLabel) {
        List jdkLabels = this.jdkManager.getJdkLabels();
        if (jdkLabels.stream().noneMatch(label -> label.equals(jdkLabel))) {
            return Optional.of(new ValidationProblem(context, "Can't find JDK by label: '" + jdkLabel + "'. Available values: " + jdkLabels));
        }
        return Optional.empty();
    }
}

