/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.helpers;

import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.deployments.configuration.CustomEnvironmentConfigPluginExporter;
import com.atlassian.bamboo.deployments.configuration.CustomEnvironmentConfigPluginManager;
import com.atlassian.bamboo.deployments.configuration.CustomEnvironmentConfigPluginModuleDescriptor;
import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.deployment.configuration.AnyPluginConfiguration;
import com.atlassian.bamboo.specs.api.builders.deployment.configuration.EnvironmentPluginConfiguration;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.deployment.DeploymentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.EnvironmentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.configuration.AnyPluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.deployment.configuration.EnvironmentPluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.task.export.TaskValidationContextImpl;
import com.atlassian.bamboo.util.Narrow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CustomEnvironmentPluginExportHelper {
    private static final Logger log = Logger.getLogger(CustomEnvironmentPluginExportHelper.class);
    private final CustomEnvironmentConfigPluginManager customEnvironmentConfigPluginManager;

    @Inject
    public CustomEnvironmentPluginExportHelper(CustomEnvironmentConfigPluginManager customEnvironmentConfigPluginManager) {
        this.customEnvironmentConfigPluginManager = customEnvironmentConfigPluginManager;
    }

    @NotNull
    public EnvironmentPluginConfiguration toSpecsEntity(String pluginKey, Map<String, String> configuration) {
        CustomEnvironmentConfigPluginExporter exporter = this.getExporter(pluginKey);
        return exporter.toSpecsEntity(configuration);
    }

    @NotNull
    public Map<String, String> importConfiguration(String pluginKey, EnvironmentPluginConfigurationProperties properties) {
        CustomEnvironmentConfigPluginExporter exporter = this.getExporter(pluginKey);
        return exporter.toConfiguration(properties);
    }

    private CustomEnvironmentConfigPluginExporter getExporter(@NotNull String pluginKey) {
        return Optional.ofNullable(this.customEnvironmentConfigPluginManager.getCustomEnvironmentConfigPlugin(pluginKey)).map(CustomEnvironmentConfigPluginModuleDescriptor::getExporter).orElseGet(() -> new DefaultEnvironmentPluginExporter(pluginKey));
    }

    public void validatePluginConfigurations(DeploymentProperties deploymentProperties, RssPermissions rssPermissions) {
        ArrayList problems = new ArrayList();
        for (EnvironmentProperties environmentProperties : deploymentProperties.getEnvironments()) {
            environmentProperties.getPluginConfigurations().forEach(pluginConfigurations -> {
                TaskValidationContext validationContext = new TaskValidationContextImpl.Builder().withDeployment(deploymentProperties).withEnvironment(environmentProperties).withRssPermissions(rssPermissions).build();
                CustomEnvironmentConfigPluginExporter taskDefinitionExporter = this.getExporter(pluginConfigurations.getAtlassianPlugin().getCompleteModuleKey());
                problems.addAll(taskDefinitionExporter.validate(validationContext, pluginConfigurations));
            });
        }
        if (!problems.isEmpty()) {
            throw new PropertiesValidationException(problems);
        }
    }

    private static class DefaultEnvironmentPluginExporter
    implements CustomEnvironmentConfigPluginExporter {
        private final String pluginKey;

        public DefaultEnvironmentPluginExporter(String pluginKey) {
            this.pluginKey = pluginKey;
        }

        @NotNull
        public EnvironmentPluginConfiguration toSpecsEntity(@NotNull Map<String, String> configuration) {
            return new AnyPluginConfiguration(new AtlassianModule(this.pluginKey)).configuration(configuration);
        }

        @NotNull
        public Map<String, String> toConfiguration(@NotNull EnvironmentPluginConfigurationProperties configurationProperties) {
            AnyPluginConfigurationProperties anyPluginConfProperties = (AnyPluginConfigurationProperties)Narrow.downTo((Object)configurationProperties, AnyPluginConfigurationProperties.class);
            if (anyPluginConfProperties != null) {
                return anyPluginConfProperties.getConfiguration();
            }
            throw new IllegalStateException("Don't know how to import configuration of type: " + configurationProperties.getClass().getName());
        }

        @NotNull
        public List<ValidationProblem> validate(@NotNull TaskValidationContext validationContext, @NotNull EnvironmentPluginConfigurationProperties configurationProperties) {
            return Collections.emptyList();
        }
    }
}

