/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.helpers;

import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.CustomBuildCompleteAction;
import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.build.CustomBuildProcessorServer;
import com.atlassian.bamboo.build.CustomPostBuildCompletedAction;
import com.atlassian.bamboo.build.CustomPreBuildAction;
import com.atlassian.bamboo.buildqueue.manager.CustomPreBuildQueuedAction;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.configuration.DependenciesPlanConfigurationPlugin;
import com.atlassian.bamboo.v2.build.BuildConfigurationAwarePlugin;
import com.atlassian.bamboo.v2.build.configuration.MiscellaneousBuildConfigurationPlugin;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.plugin.PluginAccessor;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.jetbrains.annotations.NotNull;

public class BuildConfigurationPluginsExportHelper {
    private static final Class[] MODULES_ON_JOB_PAGE = new Class[]{CustomPreBuildQueuedAction.class, CustomPreBuildAction.class, CustomBuildProcessorServer.class, CustomBuildProcessor.class, CustomBuildCompleteAction.class, CustomPostBuildCompletedAction.class};

    public static void addDefaultValues(@NotNull PluginAccessor pluginAccessor, @NotNull Plan plan, @NotNull BuildConfiguration hierarchicalConfiguration) {
        pluginAccessor.getEnabledModulesByClass(MiscellaneousBuildConfigurationPlugin.class).stream().filter(m -> m.isApplicableTo(plan)).filter(m -> m.isConfigurationMissing(hierarchicalConfiguration)).forEach(m -> m.addDefaultValues(hierarchicalConfiguration));
        if (plan instanceof Chain) {
            pluginAccessor.getEnabledModulesByClass(DependenciesPlanConfigurationPlugin.class).stream().filter(m -> m.isApplicableTo(plan)).filter(m -> m.isConfigurationMissing(hierarchicalConfiguration)).forEach(m -> m.addDefaultValues(hierarchicalConfiguration));
        } else if (plan instanceof Buildable) {
            for (Class moduleClass : MODULES_ON_JOB_PAGE) {
                pluginAccessor.getEnabledModulesByClass(moduleClass).stream().filter(BuildConfigurationAwarePlugin.class::isInstance).map(BuildConfigurationAwarePlugin.class::cast).filter(m -> m.isConfigurationMissing((HierarchicalConfiguration)hierarchicalConfiguration)).forEach(m -> m.addDefaultValues(hierarchicalConfiguration));
            }
        }
    }
}

