/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.exporters;

import com.atlassian.bamboo.configuration.external.exporters.VariableExporter;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.specs.api.builders.Variable;
import com.atlassian.bamboo.variable.VariableDefinition;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class VariableExporterImpl
implements VariableExporter {
    @Inject
    private DeploymentProjectService deploymentProjectService;

    @Override
    public Variable toSpecsEntity(@NotNull VariableDefinition variable) {
        return new Variable(variable.getKey(), variable.getValue());
    }

    @Override
    public List<Variable> toSpecsEntities(@NotNull ImmutablePlan plan, @NotNull List<VariableDefinition> variables) {
        Set autoIncrementedVariables = this.deploymentProjectService.getDeploymentProjectsRelatedToPlan(plan.getPlanKey()).stream().flatMap(d -> this.deploymentProjectService.getVersionNamingScheme(d.getId()).getVariablesToAutoIncrement().stream()).collect(Collectors.toSet());
        return variables.stream().map(variable -> {
            Variable var = this.toSpecsEntity((VariableDefinition)variable);
            if (autoIncrementedVariables.contains(variable.getKey())) {
                var.createOnly();
            }
            return var;
        }).collect(Collectors.toList());
    }
}

