/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.exporters;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.external.DeploymentExportService;
import com.atlassian.bamboo.configuration.external.PlanConfigExportService;
import com.atlassian.bamboo.configuration.external.PlanPermissionService;
import com.atlassian.bamboo.configuration.external.exporters.SpecsExporter;
import com.atlassian.bamboo.configuration.external.yaml.export.YamlEmitter;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.plan.Plan;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.permission.PlanPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.codegen.BambooSpecsGenerator;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpecsExporterImpl
implements SpecsExporter {
    private final PlanConfigExportService planConfigExportService;
    private final PlanPermissionService planPermissionService;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final DeploymentExportService deploymentExportService;
    private final YamlEmitter yamlEmitter;

    @Autowired
    public SpecsExporterImpl(PlanConfigExportService planConfigExportService, PlanPermissionService planPermissionService, AdministrationConfigurationAccessor administrationConfigurationAccessor, DeploymentExportService deploymentExportService, YamlEmitter yamlEmitter) {
        this.planConfigExportService = planConfigExportService;
        this.planPermissionService = planPermissionService;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.deploymentExportService = deploymentExportService;
        this.yamlEmitter = yamlEmitter;
    }

    @Override
    public String getCodeFromPlan(ImmutableTopLevelPlan immutableTopLevelPlan) throws CodeGenerationException {
        return this.getCodeFromPlan(immutableTopLevelPlan, SpecsExporter.ExportFormat.JAVA, "", "PlanSpec");
    }

    @Override
    public String getCodeFromPlan(ImmutableTopLevelPlan immutableTopLevelPlan, SpecsExporter.ExportFormat format, String packageName, String className) throws CodeGenerationException {
        Preconditions.checkNotNull((Object)immutableTopLevelPlan);
        Plan plan = this.planConfigExportService.exportPlanToSpecs(immutableTopLevelPlan);
        PlanProperties planProperties = (PlanProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)plan);
        PlanIdentifierProperties planIdentifierProperties = (PlanIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)plan.getIdentifier());
        if (format == SpecsExporter.ExportFormat.JAVA) {
            BambooSpecsGenerator specGenerator = new BambooSpecsGenerator();
            specGenerator.addEntity("plan", (EntityProperties)planProperties);
            try {
                PlanPermissionsProperties planPermissionProperties = this.planPermissionService.exportPlanPermission(planIdentifierProperties);
                specGenerator.addEntity("planPermission", (EntityProperties)planPermissionProperties);
            }
            catch (UnauthorisedException e) {
                this.handleUnauthorisedException(immutableTopLevelPlan, specGenerator);
            }
            return specGenerator.emitCode(this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl(), packageName, className);
        }
        if (format == SpecsExporter.ExportFormat.YAML) {
            ArrayList<Object> entitiesToEmit = new ArrayList<Object>();
            entitiesToEmit.add(planProperties);
            try {
                entitiesToEmit.add(this.planPermissionService.exportPlanPermission(planIdentifierProperties));
            }
            catch (UnauthorisedException e) {
                entitiesToEmit.add(new BambooSpecsGenerator.Comment(String.format("Note: You are not authorized to view plan %s permissions. ", immutableTopLevelPlan.getKey()), true, false));
                entitiesToEmit.add(new BambooSpecsGenerator.Comment(String.format("Bamboo YAML Specs for %s plan permissions are not generated. ", immutableTopLevelPlan.getKey()), false, true));
            }
            return this.yamlEmitter.emitYamlDocuments(entitiesToEmit);
        }
        throw new CodeGenerationException("Unknown export format " + (Object)((Object)format));
    }

    @Override
    public String getCodeFromDeploymentProject(DeploymentProject deploymentProject, SpecsExporter.ExportFormat format, String packageName, String className) throws CodeGenerationException {
        EntityProperties e = EntityPropertiesBuilders.build((EntityPropertiesBuilder)this.deploymentExportService.exportDeploymentToSpecs(deploymentProject));
        if (format == SpecsExporter.ExportFormat.JAVA) {
            BambooSpecsGenerator specGenerator = new BambooSpecsGenerator(e);
            specGenerator.addEntity("deploymentPermission", EntityPropertiesBuilders.build((EntityPropertiesBuilder)this.deploymentExportService.exportDeploymentPermissions(deploymentProject)));
            int index = 1;
            for (Environment environment : deploymentProject.getEnvironments()) {
                specGenerator.addEntity("environmentPermission" + index, EntityPropertiesBuilders.build((EntityPropertiesBuilder)this.deploymentExportService.exportEnvironmentPermissions(deploymentProject, environment)));
                ++index;
            }
            return specGenerator.emitCode(this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl());
        }
        if (format == SpecsExporter.ExportFormat.YAML) {
            ArrayList<EntityProperties> entitiesToEmit = new ArrayList<EntityProperties>();
            entitiesToEmit.add(e);
            entitiesToEmit.add(EntityPropertiesBuilders.build((EntityPropertiesBuilder)this.deploymentExportService.exportDeploymentPermissions(deploymentProject)));
            for (Environment environment : deploymentProject.getEnvironments()) {
                entitiesToEmit.add(EntityPropertiesBuilders.build((EntityPropertiesBuilder)this.deploymentExportService.exportEnvironmentPermissions(deploymentProject, environment)));
            }
            return this.yamlEmitter.emitYamlDocuments(entitiesToEmit);
        }
        throw new CodeGenerationException("Unknown export format " + (Object)((Object)format));
    }

    private void handleUnauthorisedException(ImmutableTopLevelPlan immutableTopLevelPlan, BambooSpecsGenerator specGenerator) {
        specGenerator.addEntity("planPermissionUnauthorisedComment1", (EntityProperties)new BambooSpecsGenerator.Comment(String.format("Note: You are not authorized to view plan %s permissions. ", immutableTopLevelPlan.getKey()), true, false));
        specGenerator.addEntity("planPermissionUnauthorisedComment2", (EntityProperties)new BambooSpecsGenerator.Comment(String.format("Bamboo Java Specs for %s plan permissions are not generated. ", immutableTopLevelPlan.getKey()), false, true));
    }
}

