/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.exporters;

import com.atlassian.bamboo.configuration.external.exporters.HierarchicalConfigurationExporter;
import com.atlassian.bamboo.configuration.external.exporters.RepositoryExporter;
import com.atlassian.bamboo.configuration.external.helpers.YamlHelper;
import com.atlassian.bamboo.configuration.external.util.PropertiesValidator;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.PluginKeyProvider;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepository;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryBranch;
import com.atlassian.bamboo.specs.api.builders.repository.viewer.AnyVcsRepositoryViewer;
import com.atlassian.bamboo.specs.api.builders.repository.viewer.VcsRepositoryViewer;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.repository.AnyVcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.repository.PlanRepositoryLinkProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryBranchProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.repository.viewer.AnyVcsRepositoryViewerProperties;
import com.atlassian.bamboo.specs.api.model.repository.viewer.VcsRepositoryViewerProperties;
import com.atlassian.bamboo.utils.BambooPreconditions;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataBuilder;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.configuration.legacy.configurator.LegacyRepositoryConfigurationExporter;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.bamboo.vcs.export.DefaultVcsRepositoryDataExporter;
import com.atlassian.bamboo.vcs.export.DefaultVcsRepositoryViewerExporter;
import com.atlassian.bamboo.vcs.export.NoConfigVcsRepositoryViewerExporter;
import com.atlassian.bamboo.vcs.export.NoOverridesVcsRepositoryDataExporter;
import com.atlassian.bamboo.vcs.export.VcsRepositoryContext;
import com.atlassian.bamboo.vcs.export.VcsRepositoryDataExporter;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinition;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinitionImpl;
import com.atlassian.bamboo.vcs.viewer.legacy.LegacyVcsRepositoryViewerModuleDescriptor;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerEmptyConfigurator;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerExporter;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerManager;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerModuleDescriptor;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class RepositoryExporterImpl
implements RepositoryExporter {
    @Autowired
    private HierarchicalConfigurationExporter hierarchicalConfigurationExporter;
    @Autowired
    private VcsRepositoryManager vcsRepositoryManager;
    @Autowired
    private VcsRepositoryViewerManager vcsRepositoryViewerManager;
    @Autowired
    private RepositoryDefinitionManager repositoryDefinitionManager;

    @Override
    @NotNull
    public VcsRepository toSpecsEntity(@NotNull PartialVcsRepositoryData repositoryData, @NotNull VcsRepositoryContext repositoryContext) {
        if (repositoryData.getInheritedData() == null) {
            return this.toSpecsEntity(repositoryData.getCompleteData(), repositoryContext);
        }
        VcsRepositoryDataExporter exporter = this.getExporterForRepositoryData(repositoryData);
        VcsRepository builder = exporter.getEntityPropertiesBuilder(repositoryData.getCompleteData()).parent(repositoryData.getName()).oid(repositoryData.getOid().toExternalValue());
        if (repositoryData.getVcsLocation() != null) {
            BambooPluginUtils.callChangedApi(() -> exporter.appendLocationData(builder, repositoryData.getVcsLocation(), repositoryContext), () -> exporter.appendLocationData(builder, repositoryData.getVcsLocation()));
        }
        if (repositoryData.getBranch() != null) {
            exporter.appendBranchData(builder, repositoryData.getBranch());
        }
        if (repositoryData.getVcsChangeDetectionOptions() != null) {
            exporter.appendChangeDetectionOptions(builder, repositoryData.getVcsChangeDetectionOptions());
        }
        if (repositoryData.getVcsBranchDetectionOptions() != null) {
            exporter.appendBranchDetectionOptions(builder, repositoryData.getVcsBranchDetectionOptions());
        }
        if (repositoryData.getViewerConfiguration() != null && !"none:none".equals(repositoryData.getViewerConfiguration().getPluginKey())) {
            builder.repositoryViewer(this.toSpecsEntity(repositoryData.getViewerConfiguration()));
        }
        return builder;
    }

    @Override
    @NotNull
    public Pair<VcsRepository, VcsRepositoryBranch> toSpecsEntityAndBranchOverride(@NotNull PartialVcsRepositoryData repositoryData, @NotNull VcsRepositoryContext repositoryContext) {
        boolean onlyBranchOverridden;
        boolean bl = onlyBranchOverridden = repositoryData.getInheritedData() != null && repositoryData.getVcsLocation() == null && repositoryData.getVcsChangeDetectionOptions() == null && repositoryData.getVcsBranchDetectionOptions() == null && repositoryData.getViewerConfiguration() == null && repositoryData.getBranch() != null;
        if (onlyBranchOverridden) {
            NoOverridesVcsRepositoryDataExporter exporter = new NoOverridesVcsRepositoryDataExporter();
            VcsBranch vcsBranch = repositoryData.getBranch().getVcsBranch();
            VcsRepositoryBranch branchBuilder = new VcsRepositoryBranch(repositoryData.getName(), vcsBranch.getName());
            branchBuilder.branchDisplayName(vcsBranch.getDisplayName());
            VcsRepository builder = exporter.getEntityPropertiesBuilder(repositoryData.getCompleteData()).parent(repositoryData.getName()).oid(repositoryData.getOid().toExternalValue());
            return Pair.make((Object)builder, (Object)branchBuilder);
        }
        return Pair.make((Object)this.toSpecsEntity(repositoryData, repositoryContext), null);
    }

    @Override
    @NotNull
    public <T extends VcsRepository<T, E>, E extends VcsRepositoryProperties> T toSpecsEntity(@NotNull VcsRepositoryData repositoryData, @NotNull VcsRepositoryContext repositoryContext) {
        VcsRepositoryDataExporter<? extends VcsRepository<?, ?>, ? extends VcsRepositoryProperties> exporter = this.getExporterForRepositoryData(repositoryData);
        VcsRepository builder = exporter.getEntityPropertiesBuilder(repositoryData).name(repositoryData.getName()).oid(repositoryData.getOid().toExternalValue()).description(repositoryData.getDescription());
        if (repositoryData.getVcsLocation() != null) {
            BambooPluginUtils.callChangedApi(() -> exporter.appendLocationData(builder, repositoryData.getVcsLocation(), repositoryContext), () -> exporter.appendLocationData(builder, repositoryData.getVcsLocation()));
        }
        if (repositoryData.getBranch() != null) {
            exporter.appendBranchData(builder, repositoryData.getBranch());
        }
        if (repositoryData.getVcsChangeDetectionOptions() != null) {
            exporter.appendChangeDetectionOptions(builder, repositoryData.getVcsChangeDetectionOptions());
        }
        if (repositoryData.getVcsBranchDetectionOptions() != null) {
            exporter.appendBranchDetectionOptions(builder, repositoryData.getVcsBranchDetectionOptions());
        }
        if (repositoryData.getViewerConfiguration() != null && !"none:none".equals(repositoryData.getViewerConfiguration().getPluginKey())) {
            builder.repositoryViewer(this.toSpecsEntity(repositoryData.getViewerConfiguration()));
        }
        return (T)builder;
    }

    private VcsRepositoryDataExporter getExporterForRepositoryData(@NotNull PartialVcsRepositoryData repositoryData) {
        if (!(repositoryData.getInheritedData() == null || repositoryData.overridesLocation() || repositoryData.overridesBranch() || repositoryData.overridesBranchDetectionOptions() || repositoryData.overridesChangeDetectionOptions())) {
            return new NoOverridesVcsRepositoryDataExporter();
        }
        return this.getExporterForRepositoryData(repositoryData.getCompleteData());
    }

    private VcsRepositoryDataExporter<? extends VcsRepository<?, ?>, ? extends VcsRepositoryProperties> getExporterForRepositoryData(@NotNull VcsRepositoryData repositoryData) {
        VcsRepositoryModuleDescriptor repositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryData.getPluginKey());
        if (repositoryModuleDescriptor != null) {
            VcsRepositoryDataExporter exporter = repositoryModuleDescriptor.getExporter();
            return exporter != null ? exporter : new DefaultVcsRepositoryDataExporter();
        }
        if (repositoryData.isLegacyRepository()) {
            return new LegacyRepositoryConfigurationExporter(null);
        }
        return new DefaultVcsRepositoryDataExporter();
    }

    private VcsRepositoryViewerExporter getExporterForViewer(@NotNull VcsRepositoryViewerProperties properties) {
        if (properties instanceof AnyVcsRepositoryViewerProperties) {
            return new DefaultVcsRepositoryViewerExporter();
        }
        return this.getExporterForViewer(properties.getAtlassianPlugin().getCompleteModuleKey());
    }

    private VcsRepositoryViewerExporter getExporterForViewer(@NotNull String pluginKey) {
        VcsRepositoryViewerModuleDescriptor viewerModuleDescriptor = this.vcsRepositoryViewerManager.getVcsRepositoryViewerModuleDescriptor(pluginKey);
        if (viewerModuleDescriptor != null) {
            VcsRepositoryViewerExporter exporter = viewerModuleDescriptor.getExporter();
            if (exporter != null) {
                return exporter;
            }
            if (viewerModuleDescriptor.getConfigurator() instanceof VcsRepositoryViewerEmptyConfigurator) {
                return new NoConfigVcsRepositoryViewerExporter();
            }
        }
        return new DefaultVcsRepositoryViewerExporter();
    }

    private VcsRepositoryViewer toSpecsEntity(@NotNull VcsRepositoryViewerDefinition viewerConfiguration) {
        if (viewerConfiguration.isLegacyViewer()) {
            HierarchicalConfiguration hc = ((VcsRepositoryViewerDefinitionImpl)viewerConfiguration).getConfigurationRef().get();
            return new AnyVcsRepositoryViewer(new AtlassianModule(viewerConfiguration.getPluginKey())).configuration(this.hierarchicalConfigurationExporter.generateDataMap(hc));
        }
        VcsRepositoryViewerExporter exporter = this.getExporterForViewer(viewerConfiguration.getPluginKey());
        return exporter.toSpecsEntity(viewerConfiguration);
    }

    @Override
    @NotNull
    public VcsRepositoryProperties toEntityProperties(@NotNull String yaml) throws PropertiesValidationException, YamlValidationException {
        VcsRepositoryProperties properties = YamlHelper.parseAndNarrow(yaml, VcsRepositoryProperties.class);
        PropertiesValidator.validate((EntityProperties)properties);
        return properties;
    }

    @Contract(value="null, null -> null")
    private VcsRepositoryData getParentData(@Nullable BambooOidProperties parentOidProperties, @Nullable String parentName) throws PropertiesValidationException {
        VcsRepositoryData parentData = null;
        if (parentOidProperties != null) {
            BambooEntityOid parentOid = BambooEntityOid.createFromExternalValue((String)parentOidProperties.getOid());
            parentData = this.repositoryDefinitionManager.getVcsRepositoryDataByOid(parentOid);
            BambooPreconditions.checkThat((parentData != null ? 1 : 0) != 0, PropertiesValidationException::new, (String)"Couldn't find parent repository with oid: %s", (Object[])new Object[]{parentOid.toExternalValue()});
        } else if (parentName != null) {
            parentData = this.repositoryDefinitionManager.getLinkedRepositoryByName(parentName);
            BambooPreconditions.checkThat((parentData != null ? 1 : 0) != 0, PropertiesValidationException::new, (String)"Couldn't find parent repository with name: %s", (Object[])new Object[]{parentName});
        }
        return parentData;
    }

    @NotNull
    @VisibleForTesting
    String getRepositoryPluginKey(@NotNull VcsRepositoryProperties repositoryProperties, @Nullable VcsRepositoryData parentData) throws PropertiesValidationException {
        String parentModuleKey = Optional.ofNullable(parentData).map(PluginKeyProvider::getPluginKey).orElse(null);
        String completeModuleKey = Optional.ofNullable(repositoryProperties.getAtlassianPlugin()).map(AtlassianModuleProperties::getCompleteModuleKey).orElse(parentModuleKey);
        BambooPreconditions.checkThat((completeModuleKey != null ? 1 : 0) != 0, PropertiesValidationException::new, (String)"Repository must have information about Atlassian plugin (either explicit or inherited from it's parent)", (Object[])new Object[0]);
        if (parentModuleKey != null) {
            BambooPreconditions.checkThat((boolean)completeModuleKey.equals(parentModuleKey), PropertiesValidationException::new, (String)"Repository's plugin key (%s) must match it's parent plugin key (%s)", (Object[])new Object[]{completeModuleKey, parentModuleKey});
        }
        return completeModuleKey;
    }

    @Override
    @NotNull
    public PartialVcsRepositoryData importRepository(@NotNull VcsRepositoryProperties repositoryProperties, @Nullable VcsRepositoryData existingData, @Nullable VcsRepositoryData parentDataArg, boolean global, @Nullable VcsRepositoryBranchProperties branchOverride, @NotNull VcsRepositoryContext repositoryContext) throws PropertiesValidationException, YamlValidationException {
        VcsRepositoryData parentData = parentDataArg != null ? parentDataArg : this.getParentData(null, repositoryProperties.getParentName());
        String completeModuleKey = this.getRepositoryPluginKey(repositoryProperties, parentData);
        VcsRepositoryModuleDescriptor repositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(completeModuleKey);
        BambooPreconditions.checkThat((repositoryModuleDescriptor != null ? 1 : 0) != 0, PropertiesValidationException::new, (String)"No repository module found with key: %s", (Object[])new Object[]{completeModuleKey});
        VcsRepositoryDataExporter repositoryDataExporter = this.getRepositoryDataExporter(repositoryProperties, repositoryModuleDescriptor);
        VcsLocationDefinition repositoryData = existingData != null ? existingData.getVcsLocation() : null;
        Map vcsLocationConfiguration = (Map)BambooPluginUtils.callChangedApi(() -> repositoryDataExporter.importLocationData(repositoryProperties, repositoryData, repositoryContext), () -> repositoryDataExporter.importLocationData(repositoryProperties, repositoryData));
        Map<String, String> branchConfiguration = this.importBranchConfiguration(repositoryProperties, existingData, repositoryDataExporter, branchOverride);
        Map branchDetectionConfiguration = repositoryDataExporter.importBranchDetectionOptions(repositoryProperties, existingData != null ? existingData.getVcsBranchDetectionOptions() : null);
        Map bambooSpecsDetectionConfiguration = repositoryDataExporter.importBambooSpecsDetectionOptions(repositoryProperties, existingData != null ? existingData.getBambooSpecsDetectionOptions() : null);
        VcsBranchImpl vcsBranch = null;
        if (branchOverride != null) {
            vcsBranch = new VcsBranchImpl(branchOverride.getBranchName(), branchOverride.getBranchDisplayName());
            VcsBranchConfigurator branchConfigurator2 = repositoryModuleDescriptor.getVcsBranchConfigurator();
            if (branchConfigurator2 == null) {
                throw new PropertiesValidationException("Vcs branch specified but repository plugin does not support branching");
            }
            branchConfigurator2.setVcsBranchInConfig(branchConfiguration, (VcsBranch)vcsBranch);
        } else if (branchConfiguration != null) {
            vcsBranch = Optional.ofNullable(repositoryModuleDescriptor.getVcsBranchConfigurator()).map(branchConfigurator -> branchConfigurator.getVcsBranchFromConfig(branchConfiguration)).orElse(null);
        }
        BambooEntityOid oid = Optional.ofNullable(repositoryProperties.getOid()).map(BambooOidProperties::getOid).map(BambooEntityOid::createFromExternalValue).orElse(null);
        VcsRepositoryViewerProperties repositoryViewerProperties = repositoryProperties.getRepositoryViewerProperties();
        String repositoryViewerKey = Optional.ofNullable(repositoryViewerProperties).map(VcsRepositoryViewerProperties::getAtlassianPlugin).map(AtlassianModuleProperties::getCompleteModuleKey).orElse(null);
        Map changeDetectionOptions = repositoryDataExporter.importChangeDetectionOptions(repositoryProperties, existingData != null ? existingData.getVcsChangeDetectionOptions() : null);
        String name = this.getRepositoryName(repositoryProperties, parentData);
        PartialVcsRepositoryDataBuilder repositoryDataBuilder = PartialVcsRepositoryDataBuilder.newBuilder().linked(global).oid(oid).pluginKey(completeModuleKey).name(name).description(repositoryProperties.getDescription()).vcsBranch((VcsBranch)vcsBranch).viewerPluginKey(repositoryViewerKey).changeDetectionConfiguration(changeDetectionOptions).branchDetectionConfiguration(branchDetectionConfiguration).branchConfiguration(branchConfiguration).bambooSpecsDetectionConfiguration(bambooSpecsDetectionConfiguration).inheritedData(parentData);
        if (vcsLocationConfiguration != null) {
            if (repositoryModuleDescriptor instanceof LegacyRepositoryModuleDescriptor) {
                repositoryDataBuilder.serverConfiguration(Collections.emptyMap());
                repositoryDataBuilder.legacyXml((String)vcsLocationConfiguration.get("legacyXml"));
            } else {
                repositoryDataBuilder.serverConfiguration(vcsLocationConfiguration);
            }
        }
        if (repositoryViewerKey != null && repositoryViewerProperties != null) {
            VcsRepositoryViewerModuleDescriptor viewerModuleDescriptor = this.vcsRepositoryViewerManager.getVcsRepositoryViewerModuleDescriptor(repositoryViewerKey);
            BambooPreconditions.checkThat((viewerModuleDescriptor != null ? 1 : 0) != 0, PropertiesValidationException::new, (String)"No VCS repository viewer found of type '%s'", (Object[])new Object[]{repositoryViewerKey});
            BambooPreconditions.checkThat((boolean)viewerModuleDescriptor.supportsVcsRepositoryType(completeModuleKey), PropertiesValidationException::new, (String)"VCS repository viewer of type '%s' is not supported for VCS repository type '%s'", (Object[])new Object[]{repositoryViewerKey, completeModuleKey});
            if (viewerModuleDescriptor instanceof LegacyVcsRepositoryViewerModuleDescriptor) {
                HierarchicalConfiguration hierarchicalConfiguration = this.hierarchicalConfigurationExporter.fromDataMap(((AnyVcsRepositoryViewerProperties)repositoryViewerProperties).getConfiguration());
                repositoryDataBuilder.legacyViewerXml(ConfigUtils.asXmlString((HierarchicalConfiguration)hierarchicalConfiguration));
                repositoryDataBuilder.viewerConfiguration(Collections.emptyMap());
            } else {
                VcsRepositoryViewerExporter exporter = this.getExporterForViewer(repositoryViewerProperties);
                Map viewerConfiguration = exporter.toViewerConfiguration(repositoryViewerProperties);
                repositoryDataBuilder.viewerConfiguration((Map)ObjectUtils.defaultIfNull((Object)viewerConfiguration, Collections.emptyMap()));
            }
        }
        return repositoryDataBuilder.build();
    }

    private Map<String, String> importBranchConfiguration(@NotNull VcsRepositoryProperties repositoryProperties, @Nullable VcsRepositoryData existingData, @Nullable VcsRepositoryDataExporter repositoryDataExporter, VcsRepositoryBranchProperties branchOverride) {
        Map branchConfiguration = repositoryDataExporter.importBranchData(repositoryProperties, existingData != null ? existingData.getBranch() : null);
        if (branchOverride != null && branchConfiguration == null) {
            return new HashMap<String, String>();
        }
        return branchConfiguration;
    }

    @NotNull
    private VcsRepositoryDataExporter getRepositoryDataExporter(@NotNull VcsRepositoryProperties repositoryProperties, @NotNull VcsRepositoryModuleDescriptor repositoryModuleDescriptor) {
        if (repositoryProperties instanceof PlanRepositoryLinkProperties.LinkedGlobalRepository) {
            return new NoOverridesVcsRepositoryDataExporter();
        }
        if (repositoryModuleDescriptor instanceof LegacyRepositoryModuleDescriptor) {
            return new LegacyRepositoryConfigurationExporter(null);
        }
        if (repositoryProperties instanceof AnyVcsRepositoryProperties) {
            return new DefaultVcsRepositoryDataExporter();
        }
        VcsRepositoryDataExporter exporter = repositoryModuleDescriptor.getExporter();
        return exporter != null ? exporter : new DefaultVcsRepositoryDataExporter();
    }

    @NotNull
    private String getRepositoryName(@NotNull VcsRepositoryProperties repositoryProperties, @Nullable VcsRepositoryData parentData) throws PropertiesValidationException {
        if (repositoryProperties.getName() != null) {
            return repositoryProperties.getName();
        }
        if (parentData != null) {
            return parentData.getName();
        }
        throw new PropertiesValidationException("Repository must have information about name (either explicit or inherited from it's parent)");
    }
}

