/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.exporters;

import com.atlassian.bamboo.configuration.external.exporters.PermissionExporter;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.GroupPrincipalSid;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.IdentityUnavailableException;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class PermissionExporterImpl
implements PermissionExporter {
    private static final int ROLES_PREFIX_LENGTH = "role_".length();
    private static final Logger log = Logger.getLogger(PermissionExporterImpl.class);
    @Autowired
    private HibernateMutableAclService aclService;

    @Override
    @NotNull
    public Map<String, Object> exportPermissions(@NotNull ImmutablePlan plan) {
        Acl acl = this.aclService.readAclById((ObjectIdentity)new HibernateObjectIdentityImpl((Object)plan));
        return this.getStringObjectMap(acl);
    }

    @Override
    @NotNull
    public Map<String, Object> exportPermissions(@NotNull DeploymentProject deploymentProject) {
        MutableAcl acl = this.aclService.readMutableAclById((ObjectIdentity)new HibernateObjectIdentityImpl((Object)deploymentProject));
        return this.getStringObjectMap((Acl)acl);
    }

    @Override
    @NotNull
    public Map<String, Object> exportPermissions(@NotNull Environment environment) {
        try {
            MutableAcl acl = this.aclService.readMutableAclById((ObjectIdentity)new HibernateObjectIdentityImpl((Object)environment));
            return this.getStringObjectMap((Acl)acl);
        }
        catch (NotFoundException notFoundException) {
        }
        catch (IdentityUnavailableException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return Collections.emptyMap();
    }

    private void storePermissions(@NotNull String key, Permission permission, @NotNull Map<String, List<String>> data) {
        List permissions = data.computeIfAbsent(key, someKey -> new LinkedList());
        String permissionName = BambooPermission.determineNameFromPermission((Permission)permission);
        if (StringUtils.isNotEmpty((CharSequence)permissionName)) {
            permissions.add(permissionName.toLowerCase());
            Collections.sort(permissions);
        }
    }

    @NotNull
    private Map<String, Object> getStringObjectMap(Acl acl) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, List<String>> users = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<String>> groups = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<String>> roles = new LinkedHashMap<String, List<String>>();
        data.put("users", users);
        data.put("groups", groups);
        data.put("roles", roles);
        for (AccessControlEntry entry : acl.getEntries()) {
            Sid aceSid = entry.getSid();
            Permission permission = entry.getPermission();
            if (aceSid instanceof PrincipalSid) {
                this.storePermissions(((PrincipalSid)aceSid).getPrincipal(), permission, users);
                continue;
            }
            if (aceSid instanceof GroupPrincipalSid) {
                this.storePermissions(((GroupPrincipalSid)aceSid).getPrincipal(), permission, groups);
                continue;
            }
            if (!(aceSid instanceof GrantedAuthoritySid)) continue;
            String key = ((GrantedAuthoritySid)aceSid).getGrantedAuthority().substring(ROLES_PREFIX_LENGTH).toLowerCase();
            this.storePermissions(key, permission, roles);
        }
        return data;
    }
}

