/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.exporters;

import com.atlassian.bamboo.configuration.external.exporters.NotificationExporter;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.event.SpecsExplicitDeletionEvent;
import com.atlassian.bamboo.notification.DefaultNotificationTypeExporter;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRecipientExporter;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.notification.NotificationType;
import com.atlassian.bamboo.notification.NotificationTypeExporter;
import com.atlassian.bamboo.notification.recipients.DefaultNotificationRecipientExporter;
import com.atlassian.bamboo.plugin.descriptor.NotificationRecipientModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.NotificationTypeModuleDescriptor;
import com.atlassian.bamboo.specs.api.builders.notification.EmptyNotificationsList;
import com.atlassian.bamboo.specs.api.builders.notification.Notification;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.deployment.DeploymentProperties;
import com.atlassian.bamboo.specs.api.model.notification.AnyNotificationRecipientProperties;
import com.atlassian.bamboo.specs.api.model.notification.AnyNotificationTypeProperties;
import com.atlassian.bamboo.specs.api.model.notification.EmptyNotificationsListProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationRecipientProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationTypeProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class NotificationExporterImpl
implements NotificationExporter {
    private static final EnumSet<NotificationType.Scope> PLAN_SCOPES = EnumSet.of(NotificationType.Scope.CHAIN, NotificationType.Scope.PLAN);
    @Autowired
    private NotificationManager notificationManager;
    @Autowired
    private EventPublisher eventPublisher;

    @Override
    @NotNull
    public Notification toSpecEntity(@NotNull NotificationRule notificationRule) {
        NotificationTypeExporter notificationTypeExporter = this.getNotificationTypeExporter(notificationRule.getConditionKey());
        NotificationRecipientExporter notificationRecipientExporter = this.getNotificationRecipientExporter(notificationRule.getRecipientType());
        return new Notification().type(notificationTypeExporter.toSpecsEntity(notificationRule.getConditionKey(), notificationRule.getConditionData())).recipients(new com.atlassian.bamboo.specs.api.builders.notification.NotificationRecipient[]{notificationRecipientExporter.toSpecsEntity(notificationRule.getRecipientType(), notificationRule.getRecipient())});
    }

    @Override
    @NotNull
    public List<Notification> exportNotificationSet(@NotNull NotificationSet notificationSet) {
        TreeMultimap conditions2Rules = TreeMultimap.create((Comparator)Pair.pairOfComparableComparator(), (Comparator)Ordering.natural());
        ArrayList<Notification> result = new ArrayList<Notification>();
        for (NotificationRule rule : notificationSet.getNotificationRules()) {
            conditions2Rules.put((Object)Pair.make((Object)rule.getConditionKey(), (Object)rule.getConditionData()), (Object)rule);
        }
        for (Pair condition : conditions2Rules.keySet()) {
            NotificationTypeExporter notificationTypeExporter = this.getNotificationTypeExporter((String)condition.getFirst());
            Notification notification = new Notification().type(notificationTypeExporter.toSpecsEntity((String)condition.getFirst(), (String)condition.getSecond()));
            for (NotificationRule rule : conditions2Rules.get((Object)condition)) {
                NotificationRecipientExporter notificationRecipientExporter = this.getNotificationRecipientExporter(rule.getRecipientType());
                notification.recipients(new com.atlassian.bamboo.specs.api.builders.notification.NotificationRecipient[]{notificationRecipientExporter.toSpecsEntity(rule.getRecipientType(), rule.getRecipient())});
            }
            result.add(notification);
        }
        return result;
    }

    @NotNull
    private NotificationRecipientExporter getNotificationRecipientExporter(String recipientType) {
        return Optional.ofNullable(recipientType).map(rt -> this.notificationManager.getNotificationRecipientFromKey(recipientType)).map(rec -> (NotificationRecipientModuleDescriptor)rec.getModuleDescriptor()).map(NotificationRecipientModuleDescriptor::getExporter).orElse((NotificationRecipientExporter)new DefaultNotificationRecipientExporter());
    }

    @NotNull
    private NotificationTypeExporter getNotificationTypeExporter(String conditionKey) {
        return Optional.ofNullable(conditionKey).map(ck -> this.notificationManager.getNotificationTypeFromKey(ck)).map(notificationType -> (NotificationTypeModuleDescriptor)notificationType.getModuleDescriptor()).map(NotificationTypeModuleDescriptor::getExporter).orElse((NotificationTypeExporter)new DefaultNotificationTypeExporter());
    }

    @NotNull
    private NotificationTypeExporter getNotificationTypeExporter(NotificationTypeProperties properties, EntityProperties owner) {
        String completeModuleKey = properties.getAtlassianPlugin().getCompleteModuleKey();
        NotificationType type = this.notificationManager.getNotificationTypeFromKey(completeModuleKey);
        if (type == null) {
            throw new PropertiesValidationException(String.format("Notification type is not found: '%s'. Check if app is installed and active", completeModuleKey));
        }
        if (!this.canUseInContext(type, owner)) {
            throw new PropertiesValidationException(String.format("Can't use %s in %s context.", properties.getAtlassianPlugin().getCompleteModuleKey(), owner.getClass().getSimpleName()));
        }
        if (properties instanceof AnyNotificationTypeProperties) {
            return new DefaultNotificationTypeExporter();
        }
        return Optional.ofNullable(type).map(t -> (NotificationTypeModuleDescriptor)t.getModuleDescriptor()).map(NotificationTypeModuleDescriptor::getExporter).orElse((NotificationTypeExporter)new DefaultNotificationTypeExporter());
    }

    @NotNull
    private NotificationRecipientExporter getNotificationRecipientExporter(NotificationRecipientProperties properties, EntityProperties owner) {
        String completeModuleKey = properties.getAtlassianPlugin().getCompleteModuleKey();
        NotificationRecipient recipient = this.notificationManager.getNotificationRecipientFromKey(completeModuleKey);
        if (recipient == null) {
            throw new PropertiesValidationException(String.format("Notification recipient is not found: '%s'. Check if app is installed and active", completeModuleKey));
        }
        if (!this.canUseInContext(recipient, owner)) {
            throw new PropertiesValidationException(String.format("Can't use %s in %s context.", properties.getClass().getSimpleName(), owner.getClass().getSimpleName()));
        }
        if (properties instanceof AnyNotificationRecipientProperties) {
            return new DefaultNotificationRecipientExporter();
        }
        return Optional.ofNullable(recipient).map(r -> (NotificationRecipientModuleDescriptor)r.getModuleDescriptor()).map(NotificationRecipientModuleDescriptor::getExporter).orElse((NotificationRecipientExporter)new DefaultNotificationRecipientExporter());
    }

    private boolean canUseInContext(NotificationType notificationType, EntityProperties owner) {
        if (owner instanceof PlanProperties) {
            return this.canUseInPlanContext(notificationType);
        }
        return this.canUseInDeploymentContext(notificationType);
    }

    private boolean canUseInPlanContext(NotificationType notificationType) {
        return PLAN_SCOPES.contains(notificationType.getScope());
    }

    private boolean canUseInDeploymentContext(NotificationType notificationType) {
        return NotificationType.Scope.DEPLOYMENT == notificationType.getScope();
    }

    private boolean canUseInContext(NotificationRecipient notificationRecipient, EntityProperties owner) {
        return !(owner instanceof DeploymentProperties && notificationRecipient instanceof NotificationRecipient.RequiresPlan || owner instanceof DeploymentProperties && !notificationRecipient.getScopes().isEmpty() && !notificationRecipient.getScopes().contains(NotificationRecipient.Scope.DEPLOYMENT) || owner instanceof PlanProperties && !notificationRecipient.getScopes().isEmpty() && !notificationRecipient.getScopes().contains(NotificationRecipient.Scope.CHAIN));
    }

    @Override
    @NotNull
    public List<NotificationRule> importNotificationRules(@NotNull NotificationProperties notification, @NotNull EntityProperties owner) {
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        NotificationTypeExporter notificationTypeExporter = this.getNotificationTypeExporter(notification.getType(), owner);
        String typePluginKey = notification.getType().getAtlassianPlugin().getCompleteModuleKey();
        String notificationConditionData = "";
        try {
            notificationConditionData = notificationTypeExporter.importNotificationType(notification.getType());
        }
        catch (PropertiesValidationException e) {
            problems.add(new ValidationProblem(e.getMessage()));
        }
        ArrayList<NotificationRule> notifications = new ArrayList<NotificationRule>();
        for (NotificationRecipientProperties recipient : notification.getRecipients()) {
            NotificationRecipientExporter notificationRecipientExporter = this.getNotificationRecipientExporter(recipient, owner);
            try {
                notifications.add(this.notificationManager.createNotificationRule(typePluginKey, notificationConditionData, notificationRecipientExporter.importNotificationRecipient(recipient), recipient.getAtlassianPlugin().getCompleteModuleKey()));
            }
            catch (PropertiesValidationException e) {
                problems.add(new ValidationProblem(e.getMessage()));
            }
        }
        if (!problems.isEmpty()) {
            throw new PropertiesValidationException(problems);
        }
        return notifications;
    }

    @Override
    public boolean updateNotificationSet(@NotNull NotificationSet notificationSet, @NotNull Collection<NotificationProperties> notifications, @NotNull EntityProperties owner) {
        HashSet existingRules = new HashSet(notificationSet.getNotificationRules());
        if (notifications.size() == 1) {
            if (notifications.stream().allMatch(EmptyNotificationsListProperties.class::isInstance)) {
                this.eventPublisher.publish((Object)new SpecsExplicitDeletionEvent(EmptyNotificationsList.class.getSimpleName()));
                existingRules.stream().map(BambooIdProvider::getId).forEach(arg_0 -> ((NotificationSet)notificationSet).removeNotificationRule(arg_0));
                return !existingRules.isEmpty();
            }
        }
        Set importedRules = notifications.stream().map(notification -> this.importNotificationRules((NotificationProperties)notification, owner)).flatMap(Collection::stream).collect(Collectors.toSet());
        boolean anythingModified = existingRules.stream().filter(r -> !importedRules.contains(r)).map(r -> {
            notificationSet.removeNotificationRule(r.getId());
            return true;
        }).reduce(Boolean::logicalOr).orElse(false);
        return anythingModified |= importedRules.stream().filter(r -> !existingRules.contains(r)).map(r -> {
            notificationSet.addNotification(r);
            return true;
        }).reduce(Boolean::logicalOr).orElse(false).booleanValue();
    }
}

