/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.exporters;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.PartialBuildDefinition;
import com.atlassian.bamboo.build.PlanDependency;
import com.atlassian.bamboo.build.PlanDependencyManager;
import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.configuration.external.exporters.ChainDependenciesExporter;
import com.atlassian.bamboo.event.SpecsExplicitDeletionEvent;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier;
import com.atlassian.bamboo.specs.api.builders.plan.dependencies.Dependencies;
import com.atlassian.bamboo.specs.api.builders.plan.dependencies.DependenciesConfiguration;
import com.atlassian.bamboo.specs.api.builders.plan.dependencies.EmptyDependenciesList;
import com.atlassian.bamboo.specs.api.model.plan.dependencies.DependenciesConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.plan.dependencies.DependenciesProperties;
import com.atlassian.bamboo.specs.api.model.plan.dependencies.EmptyDependenciesListProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.v2.build.trigger.DependencyBlockingStrategy;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.event.api.EventPublisher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.acegisecurity.acls.Permission;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class ChainDependenciesExporterImpl
implements ChainDependenciesExporter {
    ValidationContext validationContext = ValidationContext.of((String)"Plan Dependencies");
    @Autowired
    private BambooPermissionManager bambooPermissionManager;
    @Autowired
    private BuildDefinitionConverter buildDefinitionConverter;
    @Autowired
    private PlanDependencyManager planDependencyManager;
    @Lazy
    @Autowired
    private CachedPlanManager cachedPlanManager;
    @Autowired
    private EventPublisher eventPublisher;

    @Override
    @NotNull
    public Dependencies toSpecsEntity(@NotNull ImmutableTopLevelPlan chain) {
        Dependencies builder = new Dependencies();
        builder.configuration(this.getDependenciesConfiguration(chain));
        this.exportDependentChains(chain).stream().map(this::planIdentifier).forEach(xva$0 -> builder.childPlans(new PlanIdentifier[]{xva$0}));
        return builder;
    }

    @NotNull
    private DependenciesConfiguration getDependenciesConfiguration(@NotNull ImmutableTopLevelPlan chain) {
        DependenciesConfiguration configuration = new DependenciesConfiguration();
        BuildConfiguration buildConfiguration = new BuildConfiguration((HierarchicalConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)chain.getBuildDefinition()));
        configuration.enabledForBranches(buildConfiguration.getBoolean("custom.dependencies.triggerForBranches"));
        configuration.requireAllStagesPassing(buildConfiguration.getBoolean("custom.dependencies.triggerOnlyAfterAllStages"));
        DependencyBlockingStrategy blockingStrategy = this.getBlockingStrategyByValue(buildConfiguration.getString("custom.dependencies.trigger.remote.strategy"));
        configuration.blockingStrategy(blockingStrategy.toSpecsConstant());
        return configuration;
    }

    private PlanIdentifier planIdentifier(ImmutablePlan plan) {
        String key = plan.getBuildKey();
        String projectKey = plan.getProject().getKey();
        return new PlanIdentifier(projectKey, key);
    }

    @NotNull
    private DependencyBlockingStrategy getBlockingStrategyByValue(@Nullable String value) {
        return Arrays.stream(DependencyBlockingStrategy.values()).filter(strategy -> strategy.getValue().equals(value)).findAny().orElse(DependencyBlockingStrategy.None);
    }

    @NotNull
    private List<ImmutablePlan> exportDependentChains(@NotNull ImmutableTopLevelPlan chain) {
        return this.planDependencyManager.getChildPlanDependencies((com.atlassian.bamboo.plan.PlanIdentifier)chain).stream().filter(PlanDependency::isEditable).map(PlanDependency::getChildPlan).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void validateDependencies(DefaultChain topLevelPlan, DependenciesProperties dependencies) {
        if (dependencies instanceof EmptyDependenciesListProperties) {
            return;
        }
        Set<PlanKey> childKeys = dependencies.getChildPlans().stream().map(identifier -> PlanKeys.getPlanKey((String)identifier.getProjectKey().getKey(), (String)identifier.getKey().getKey())).collect(Collectors.toSet());
        this.verifyChildKeys(childKeys, topLevelPlan.getPlanKey());
    }

    @Override
    public void importDependenciesConfiguration(BuildDefinition buildDefinition, DependenciesProperties dependencies) {
        this.addDependenciesConfiguration(buildDefinition, dependencies.getDependenciesConfigurationProperties());
    }

    @Override
    public void importDependencies(DefaultChain topLevelPlan, BuildDefinition buildDefinition, DependenciesProperties dependencies) {
        if (dependencies instanceof EmptyDependenciesListProperties) {
            this.eventPublisher.publish((Object)new SpecsExplicitDeletionEvent(EmptyDependenciesList.class.getSimpleName()));
            dependencies = (DependenciesProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new Dependencies());
        }
        this.addDependenciesConfiguration(buildDefinition, dependencies.getDependenciesConfigurationProperties());
        Set childKeys = dependencies.getChildPlans().stream().map(identifier -> PlanKeys.getPlanKey((String)identifier.getProjectKey().getKey(), (String)identifier.getKey().getKey())).collect(Collectors.toSet());
        this.planDependencyManager.adjustChildDependencyList("atlassian.dependency.default", (Plan)topLevelPlan, childKeys, true);
    }

    private void verifyChildKeys(@NotNull Set<PlanKey> keys, PlanKey parentKey) {
        for (PlanKey key : keys) {
            ImporterUtils.checkThat((ValidationContext)this.validationContext, (this.cachedPlanManager.getPlanByKey(key) != null ? 1 : 0) != 0, (String)"plan %s does not exist", (Object[])new Object[]{key.getKey()});
            ImporterUtils.checkThat((ValidationContext)this.validationContext, (!key.equals((Object)parentKey) ? 1 : 0) != 0, (String)"plan can't depend on itself", (Object[])new Object[0]);
            ImporterUtils.checkThat((ValidationContext)this.validationContext, (boolean)this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.BUILD, key), (String)"you have insufficient permissions to access plan %s", (Object[])new Object[]{key.getKey()});
        }
    }

    private void addDependenciesConfiguration(BuildDefinition buildDefinition, DependenciesConfigurationProperties dependenciesConfigurationProperties) {
        Map customConfiguration = buildDefinition.getCustomConfiguration();
        customConfiguration.put("custom.dependencies.triggerOnlyAfterAllStages", Boolean.toString(dependenciesConfigurationProperties.isRequireAllStagesPassing()));
        customConfiguration.put("custom.dependencies.triggerForBranches", Boolean.toString(dependenciesConfigurationProperties.isEnabledForBranches()));
        customConfiguration.put("custom.dependencies.trigger.remote.strategy", DependencyBlockingStrategy.fromSpecsConstant((DependenciesConfiguration.DependencyBlockingStrategy)dependenciesConfigurationProperties.getBlockingStrategy()).getValue());
    }
}

