/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.exporters;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.configuration.external.exporters.ChainBranchExporter;
import com.atlassian.bamboo.configuration.external.helpers.TriggerDefinitionExportHelper;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationStrategy;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfiguration;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.specs.api.builders.plan.branches.BranchCleanup;
import com.atlassian.bamboo.specs.api.builders.plan.branches.BranchIntegration;
import com.atlassian.bamboo.specs.api.builders.plan.branches.PlanBranchManagement;
import com.atlassian.bamboo.trigger.Triggerable;
import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ChainBranchExporterImpl
implements ChainBranchExporter {
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private TriggerDefinitionExportHelper triggerDefinitionExportHelper;

    @Override
    @NotNull
    public BranchIntegration exportBranchIntegrationConfiguration(@NotNull BranchIntegrationConfiguration branchIntegrationConfiguration, @NotNull PlanKey chainKey, @NotNull PlanBranchWorkflow planBranchWorkflow) {
        return this.exportBranchIntegrationConfigurationBuilder(branchIntegrationConfiguration, chainKey, planBranchWorkflow);
    }

    @NotNull
    private BranchIntegration exportBranchIntegrationConfigurationBuilder(@NotNull BranchIntegrationConfiguration branchIntegrationConfiguration, @NotNull PlanKey chainKey, @NotNull PlanBranchWorkflow planBranchWorkflow) {
        BranchIntegration branchIntegration = new BranchIntegration().enabled(branchIntegrationConfiguration.isEnabled());
        if (branchIntegrationConfiguration.isEnabled()) {
            branchIntegration.gatekeeper(branchIntegrationConfiguration.getStrategy() == BranchIntegrationStrategy.GATE_KEEPER);
            branchIntegration.pushOnSuccessfulBuild(branchIntegrationConfiguration.isPushEnabled());
            PlanKey planKey = branchIntegrationConfiguration.getIntegrationPlanBranchKey();
            if (planKey != null) {
                ImmutablePlan integrationBranch = this.cachedPlanManager.getPlanByKey(planKey);
                Preconditions.checkNotNull((Object)integrationBranch, (String)"Couldn't find plan with key %s", (Object)chainKey.getKey());
                branchIntegration.integrationBranchKey(integrationBranch.getPlanKey().getPartialKey());
                branchIntegration.integrationBranchOid(integrationBranch.getOid().toExternalValue());
            } else if (planBranchWorkflow == PlanBranchWorkflow.BRANCH_WORKFLOW) {
                throw new IllegalStateException("Integration plan branch can't be null when Branch workflow is used");
            }
        }
        return branchIntegration;
    }

    @Override
    @NotNull
    public PlanBranchManagement exportPlanBranchManagement(@NotNull ImmutableTopLevelPlan plan) {
        BuildDefinition buildDefinition = plan.getBuildDefinition();
        BranchMonitoringConfiguration monitoringConfiguration = buildDefinition.getBranchMonitoringConfiguration();
        PlanBranchWorkflow planBranchWorkflow = monitoringConfiguration.getPlanBranchWorkflow();
        PlanBranchManagement planBranchManagement = new PlanBranchManagement().delete(this.getRemovedBranchCleanupData(monitoringConfiguration)).branchIntegration(this.exportBranchIntegrationConfigurationBuilder(monitoringConfiguration.getDefaultBranchIntegrationConfiguration(), plan.getPlanKey(), planBranchWorkflow)).issueLinkingEnabled(monitoringConfiguration.isRemoteJiraBranchLinkingEnabled());
        this.updateNotificationSettings(monitoringConfiguration, planBranchManagement);
        this.updateTriggeringOptions((ImmutableChain)plan, monitoringConfiguration, planBranchManagement);
        this.updateCreatePlanBranchSettings(monitoringConfiguration, planBranchManagement);
        return planBranchManagement;
    }

    private void updateNotificationSettings(BranchMonitoringConfiguration monitoringConfiguration, PlanBranchManagement planBranchManagement) {
        switch (monitoringConfiguration.getDefaultBranchNotificationStrategy()) {
            case NONE: {
                planBranchManagement.notificationDisabled();
                break;
            }
            case NOTIFY_COMMITTERS: {
                planBranchManagement.notificationForCommitters();
                break;
            }
            default: {
                planBranchManagement.notificationLikeParentPlan();
            }
        }
    }

    private void updateTriggeringOptions(ImmutableChain plan, BranchMonitoringConfiguration monitoringConfiguration, PlanBranchManagement planBranchManagement) {
        switch (monitoringConfiguration.getBranchTriggeringOption()) {
            case INHERITED: {
                planBranchManagement.triggerBuildsLikeParentPlan();
                break;
            }
            case CUSTOM: {
                LinkedHashMap planRepositories = PlanHelper.getPlanRepositoryDefinitionMap((ImmutablePlan)plan);
                planBranchManagement.defaultTrigger(this.triggerDefinitionExportHelper.toSpecsEntity(planRepositories.keySet(), monitoringConfiguration.getDefaultTrigger(), (Triggerable)plan));
                break;
            }
            default: {
                planBranchManagement.triggerBuildsManually();
            }
        }
    }

    private BranchCleanup getRemovedBranchCleanupData(@NotNull BranchMonitoringConfiguration branchMonitoringConfiguration) {
        BranchCleanup branchCleanup = new BranchCleanup();
        if (branchMonitoringConfiguration.isRemovedBranchCleanUpEnabled()) {
            branchCleanup.whenRemovedFromRepositoryAfterDays(branchMonitoringConfiguration.getRemovedBranchCleanUpPeriodInDays());
        }
        if (branchMonitoringConfiguration.isInactiveBranchCleanUpEnabled()) {
            branchCleanup.whenInactiveInRepositoryAfterDays(branchMonitoringConfiguration.getInactiveBranchCleanUpPeriodInDays());
        }
        return branchCleanup;
    }

    private void updateCreatePlanBranchSettings(@NotNull BranchMonitoringConfiguration branchMonitoringConfiguration, @NotNull PlanBranchManagement planBranchManagement) {
        switch (branchMonitoringConfiguration.getPlanBranchWorkflow()) {
            case MANUAL_WORKFLOW: {
                planBranchManagement.createManually();
                break;
            }
            case BRANCH_WORKFLOW: {
                if (StringUtils.isBlank((CharSequence)branchMonitoringConfiguration.getMatchingPattern())) {
                    planBranchManagement.createForVcsBranch();
                    break;
                }
                planBranchManagement.createForVcsBranchMatching(branchMonitoringConfiguration.getMatchingPattern());
                break;
            }
            case PULL_REQUEST_WORKFLOW: {
                planBranchManagement.createForPullRequest();
                break;
            }
            default: {
                planBranchManagement.createManually();
            }
        }
    }
}

