/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.detection;

import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RssDetectionWork {
    private final long repositoryId;
    @NotNull
    private final VcsBranch vcsBranch;
    @NotNull
    private final SpecsConsumer specsConsumer;
    @GuardedBy(value="this")
    private boolean forced;
    @GuardedBy(value="this")
    private boolean completed;
    @GuardedBy(value="this")
    private boolean specsExecuted;
    @GuardedBy(value="this")
    private Exception executionException;

    public RssDetectionWork(long repositoryId, @NotNull VcsBranch vcsBranch, boolean forced, @NotNull SpecsConsumer specsConsumer) {
        this.repositoryId = repositoryId;
        this.vcsBranch = vcsBranch;
        this.forced = forced;
        this.specsConsumer = specsConsumer;
    }

    public long getRepositoryId() {
        return this.repositoryId;
    }

    @NotNull
    public VcsBranch getVcsBranch() {
        return this.vcsBranch;
    }

    @NotNull
    public SpecsConsumer getSpecsConsumer() {
        return this.specsConsumer;
    }

    public boolean isForced() {
        return this.forced;
    }

    @GuardedBy(value="this")
    public boolean isCompleted() {
        return this.completed;
    }

    @GuardedBy(value="this")
    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    @GuardedBy(value="this")
    public boolean isSpecsExecuted() {
        return this.specsExecuted;
    }

    @GuardedBy(value="this")
    public void setSpecsExecuted(boolean specsExecuted) {
        this.specsExecuted = specsExecuted;
    }

    @GuardedBy(value="this")
    @Nullable
    public Exception getExecutionException() {
        return this.executionException;
    }

    @GuardedBy(value="this")
    public void setExecutionException(@Nullable Exception executionException) {
        this.executionException = executionException;
    }

    @GuardedBy(value="this")
    public void enforce() {
        this.forced = true;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("repository", this.repositoryId).append("branch", (Object)this.vcsBranch.getName());
        return toStringBuilder.toString();
    }
}

