/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.detection;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RssDetectionShutdownFuture
implements Future<Boolean> {
    private static final Logger log = Logger.getLogger(RssDetectionShutdownFuture.class);
    private final ExecutorService executorService;

    public RssDetectionShutdownFuture(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.executorService.isTerminated();
    }

    @Override
    public Boolean get() throws InterruptedException {
        this.logIfNeeded();
        while (!this.executorService.isTerminated()) {
            this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        return true;
    }

    @Override
    public Boolean get(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        this.logIfNeeded();
        return this.executorService.isTerminated() || this.executorService.awaitTermination(timeout, unit);
    }

    private void logIfNeeded() {
        if (!this.isDone()) {
            log.info((Object)"Waiting for Bamboo Specs detection threads to stop...");
        }
    }
}

