/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.detection;

import com.atlassian.bamboo.configuration.external.RssDetectionServiceImpl;
import com.atlassian.bamboo.configuration.external.detection.RssDetectionQueue;
import com.atlassian.bamboo.configuration.external.detection.RssDetectionWork;
import org.apache.log4j.Logger;

public class RssDetectionRunnable
implements Runnable {
    private static final Logger log = Logger.getLogger(RssDetectionRunnable.class);
    private final RssDetectionServiceImpl rssDetectionService;
    private final RssDetectionQueue rssDetectionQueue;

    public RssDetectionRunnable(RssDetectionServiceImpl rssDetectionService, RssDetectionQueue rssDetectionQueue) {
        this.rssDetectionService = rssDetectionService;
        this.rssDetectionQueue = rssDetectionQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            Object specsExecuted232;
            Object object;
            RssDetectionWork currentDetectionWork;
            block38: {
                currentDetectionWork = null;
                log.debug((Object)"Checking Bamboo Specs detection queue for requests");
                RssDetectionQueue rssDetectionQueue = this.rssDetectionQueue;
                // MONITORENTER : rssDetectionQueue
                while (!this.rssDetectionQueue.isShuttingDown() && !this.rssDetectionQueue.hasNext()) {
                    log.trace((Object)"Waiting for next Bamboo Specs detection request...");
                    this.rssDetectionQueue.wait();
                }
                if (!this.rssDetectionQueue.isShuttingDown()) break block38;
                log.debug((Object)"Bamboo Specs detection shutting down, quitting");
                // MONITOREXIT : rssDetectionQueue
                if (currentDetectionWork == null) return;
                object = this.rssDetectionQueue;
                // MONITORENTER : object
                this.rssDetectionQueue.markDone(currentDetectionWork);
                // MONITOREXIT : object
                object = currentDetectionWork;
                // MONITORENTER : object
                currentDetectionWork.notifyAll();
                // MONITOREXIT : object
                return;
            }
            try {
                currentDetectionWork = this.rssDetectionQueue.getNext();
                // MONITOREXIT : rssDetectionQueue
                log.debug((Object)("Obtained Bamboo Specs detection request for " + currentDetectionWork));
                boolean specsExecuted232 = this.rssDetectionService.runRssDetection(currentDetectionWork.getRepositoryId(), currentDetectionWork.getVcsBranch(), currentDetectionWork.isForced(), currentDetectionWork.getSpecsConsumer());
                log.debug((Object)("Executed Bamboo Specs detection for " + currentDetectionWork));
                object = currentDetectionWork;
                // MONITORENTER : object
                currentDetectionWork.setCompleted(true);
                currentDetectionWork.setSpecsExecuted(specsExecuted232);
                currentDetectionWork.setExecutionException(null);
                // MONITOREXIT : object
                if (currentDetectionWork == null) continue;
                specsExecuted232 = this.rssDetectionQueue;
            }
            catch (InterruptedException e22) {
                log.debug((Object)"RSS detection interrupted", (Throwable)e22);
                Thread.currentThread().interrupt();
                if (currentDetectionWork == null) continue;
                Object e22 = this.rssDetectionQueue;
                {
                    catch (Throwable throwable) {
                        if (currentDetectionWork == null) throw throwable;
                        Object object2 = this.rssDetectionQueue;
                        // MONITORENTER : object2
                        this.rssDetectionQueue.markDone(currentDetectionWork);
                        // MONITOREXIT : object2
                        object2 = currentDetectionWork;
                        // MONITORENTER : object2
                        currentDetectionWork.notifyAll();
                        // MONITOREXIT : object2
                        throw throwable;
                    }
                }
                // MONITORENTER : e22
                this.rssDetectionQueue.markDone(currentDetectionWork);
                // MONITOREXIT : e22
                e22 = currentDetectionWork;
                // MONITORENTER : e22
                currentDetectionWork.notifyAll();
                // MONITOREXIT : e22
                continue;
                catch (Exception e222) {
                    String message = currentDetectionWork != null ? "Exception while executing RSS detection for " + currentDetectionWork : "Exception while executing RSS detection";
                    log.info((Object)message, (Throwable)e222);
                    if (currentDetectionWork != null) {
                        RssDetectionWork rssDetectionWork = currentDetectionWork;
                        // MONITORENTER : rssDetectionWork
                        if (!currentDetectionWork.isCompleted()) {
                            currentDetectionWork.setCompleted(true);
                            currentDetectionWork.setSpecsExecuted(false);
                            currentDetectionWork.setExecutionException(e222);
                        }
                        // MONITOREXIT : rssDetectionWork
                    }
                    if (currentDetectionWork == null) continue;
                    Object object3 = this.rssDetectionQueue;
                    this.rssDetectionQueue.markDone(currentDetectionWork);
                    // MONITOREXIT : object3
                    object3 = currentDetectionWork;
                    // MONITORENTER : object3
                    currentDetectionWork.notifyAll();
                    // MONITOREXIT : object3
                    continue;
                }
            }
            // MONITORENTER : specsExecuted232
            this.rssDetectionQueue.markDone(currentDetectionWork);
            // MONITOREXIT : specsExecuted232
            specsExecuted232 = currentDetectionWork;
            // MONITORENTER : specsExecuted232
            currentDetectionWork.notifyAll();
            // MONITOREXIT : specsExecuted232
            continue;
            break;
        }
    }
}

