/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.detection;

import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.configuration.external.detection.RssDetectionWork;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RssDetectionQueue {
    private static final Logger log = Logger.getLogger(RssDetectionQueue.class);
    @GuardedBy(value="this")
    private final Map<RssDetectionWorkKey, RssDetectionWork> workQueue = new LinkedHashMap<RssDetectionWorkKey, RssDetectionWork>();
    @GuardedBy(value="this")
    private final Set<RssDetectionWorkKey> currentWork = new HashSet<RssDetectionWorkKey>();
    @GuardedBy(value="this")
    private boolean shuttingDown = false;

    @GuardedBy(value="this")
    public RssDetectionWork enqueue(long repositoryId, @NotNull VcsBranch vcsBranch, boolean force, @NotNull SpecsConsumer specsConsumer) {
        Preconditions.checkState((!this.shuttingDown ? 1 : 0) != 0, (Object)("Specs detection is shutting down, can't register work for repository " + repositoryId));
        RssDetectionWorkKey rssDetectionWorkKey = new RssDetectionWorkKey(repositoryId, vcsBranch);
        if (this.workQueue.containsKey(rssDetectionWorkKey)) {
            RssDetectionWork existingWork = this.workQueue.get(rssDetectionWorkKey);
            log.info((Object)("Specs detection already registered for " + existingWork));
            existingWork.getSpecsConsumer().mergeConsumers(specsConsumer);
            if (force) {
                log.debug((Object)("Enforcing detection previously registered for " + existingWork));
                existingWork.enforce();
            }
            return existingWork;
        }
        RssDetectionWork detectionWork = new RssDetectionWork(repositoryId, vcsBranch, force, specsConsumer);
        log.debug((Object)("Specs detection work registered for " + detectionWork));
        this.workQueue.put(rssDetectionWorkKey, detectionWork);
        this.notifyAll();
        return detectionWork;
    }

    @GuardedBy(value="this")
    public boolean hasNext() {
        return this.workQueue.keySet().stream().anyMatch(k -> !this.currentWork.contains(k));
    }

    @GuardedBy(value="this")
    public RssDetectionWork getNext() {
        Iterator<RssDetectionWork> queueIterator = this.workQueue.values().iterator();
        while (queueIterator.hasNext()) {
            RssDetectionWork nextWork = queueIterator.next();
            if (!this.currentWork.add(new RssDetectionWorkKey(nextWork.getRepositoryId(), nextWork.getVcsBranch()))) continue;
            queueIterator.remove();
            return nextWork;
        }
        throw new IllegalStateException("No RSS detection work available");
    }

    @GuardedBy(value="this")
    public List<RssDetectionWork> peekRemaining() {
        return new ArrayList<RssDetectionWork>(this.workQueue.values());
    }

    @GuardedBy(value="this")
    public Set<RssDetectionWorkKey> peekAllQueued() {
        return Stream.concat(this.workQueue.keySet().stream(), this.currentWork.stream()).collect(Collectors.toSet());
    }

    @GuardedBy(value="this")
    public void markDone(@NotNull RssDetectionWork detectionWork) {
        log.trace((Object)("Specs detection work finished for " + detectionWork));
        this.currentWork.remove(new RssDetectionWorkKey(detectionWork.getRepositoryId(), detectionWork.getVcsBranch()));
        this.notifyAll();
    }

    @GuardedBy(value="this")
    public List<RssDetectionWork> shutdown() {
        log.trace((Object)"Shutdown registered");
        List<RssDetectionWork> unfinishedWork = this.peekRemaining();
        this.workQueue.clear();
        this.shuttingDown = true;
        this.notifyAll();
        return unfinishedWork;
    }

    @GuardedBy(value="this")
    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    @GuardedBy(value="this")
    public boolean isInProgress(long vcsRepositoryId, @NotNull VcsBranch vcsBranch) {
        RssDetectionWorkKey key = new RssDetectionWorkKey(vcsRepositoryId, vcsBranch);
        return this.currentWork.contains(key) || this.workQueue.containsKey(key);
    }

    public static class RssDetectionWorkKey {
        private final long repositoryId;
        private final VcsBranch vcsBranch;

        private RssDetectionWorkKey(long repositoryId, @NotNull VcsBranch vcsBranch) {
            this.repositoryId = repositoryId;
            this.vcsBranch = vcsBranch;
        }

        public long getRepositoryId() {
            return this.repositoryId;
        }

        public VcsBranch getVcsBranch() {
            return this.vcsBranch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RssDetectionWorkKey that = (RssDetectionWorkKey)o;
            return this.repositoryId == that.repositoryId && Objects.equals(this.vcsBranch, that.vcsBranch);
        }

        public int hashCode() {
            return Objects.hash(this.repositoryId, this.vcsBranch);
        }
    }
}

