/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.detection;

import com.atlassian.bamboo.configuration.external.detection.RssDetectionWork;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RssDetectionFuture
implements Future<Boolean> {
    private static final Logger log = Logger.getLogger(RssDetectionFuture.class);
    private final RssDetectionWork detectionWork;

    public RssDetectionFuture(@NotNull RssDetectionWork detectionWork) {
        this.detectionWork = detectionWork;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        RssDetectionWork rssDetectionWork = this.detectionWork;
        synchronized (rssDetectionWork) {
            return this.detectionWork.isCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean get() throws InterruptedException, ExecutionException {
        RssDetectionWork rssDetectionWork = this.detectionWork;
        synchronized (rssDetectionWork) {
            while (!this.detectionWork.isCompleted()) {
                String message = String.format("Waiting for Bamboo Specs detection to finish for repository %s ...", this.detectionWork);
                log.trace((Object)message);
                this.detectionWork.wait();
            }
            Exception executionException = this.detectionWork.getExecutionException();
            if (executionException != null) {
                String message = String.format("Exception thrown during Specs execution for repository %s", this.detectionWork);
                log.trace((Object)message, (Throwable)executionException);
                throw new ExecutionException(executionException);
            }
            boolean specsExecuted = this.detectionWork.isSpecsExecuted();
            String message = String.format("Bamboo Specs detection completed for repository %s. Specs executed: %s", this.detectionWork, specsExecuted);
            log.trace((Object)message);
            return specsExecuted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException {
        RssDetectionWork rssDetectionWork = this.detectionWork;
        synchronized (rssDetectionWork) {
            Exception executionException;
            if (!this.detectionWork.isCompleted()) {
                String message = String.format("Waiting for Bamboo Specs detection to finish for repository %s for %d %s...", this.detectionWork, timeout, unit.name());
                log.trace((Object)message);
                this.detectionWork.wait(unit.toMillis(timeout));
            }
            if ((executionException = this.detectionWork.getExecutionException()) != null) {
                String message = String.format("Exception thrown during Specs execution for repository %s", this.detectionWork);
                log.trace((Object)message, (Throwable)executionException);
                throw new ExecutionException(executionException);
            }
            boolean completed = this.detectionWork.isCompleted();
            boolean specsExecuted = this.detectionWork.isSpecsExecuted();
            String message = String.format("Bamboo Specs detection %s for repository %s in %d %s, Specs executed: %s", completed ? "completed" : "not completed", this.detectionWork, timeout, unit.name(), specsExecuted);
            log.trace((Object)message);
            return completed && specsExecuted;
        }
    }
}

